
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.drivers.commons.DriverException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import static org.lsst.ccs.subsystems.fcs.FcsEnumerations.FcsAlert.HARDWARE_ERROR;

/**
 * A class for Loader when it's in whole Exchange System. Hardware can be
 * missing. Loader can be connected and disconnected.
 *
 * @author virieux
 */
public class LoaderCanOpenProxy extends CanOpenProxy {

    public LoaderCanOpenProxy(long hardwareBootTimeout) {
        super(hardwareBootTimeout);
    }

    @Override
    public void start() {
        // nothing to be started automatically.
    }

    // TODO what was done here in CanOpenProxy should be done after the manual connectToCANbus
    @Override
    public void postStart() {
        // nothing to be started automatically.
    }

    // delete? This is a copy-paste from CanOpenProxy
    @Override
    public void connectToCANbus() {
        FCSLOG.info(name + " connecting to CANbus. " + this.toString());

        try {
            canInterface.init(master, baud, busName, masterNodeID); // for JNI
            canbusConnected = true;

        } catch (DriverException ex) {
            String msg = name + " could not init canInterface. " + this.toString();
            this.raiseAlarm(HARDWARE_ERROR, msg, ex);
            FCSLOG.info(name + " canbusConnected= " + canbusConnected + " baud=" + baud);
        }

        // at some time a scan of canbus was added here and removed.
    }
}
