/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenEPOS
extends CanOpenDevice
implements EPOSController {
    protected boolean parametersOK = true;
    protected EPOSEnumerations.EposMode mode;
    protected int statusWord;
    protected int current;
    protected int position;
    protected int followingError;
    protected int velocity;
    @ConfigurationParameter
    private Map<String, Integer> paramsForHoming;
    @ConfigurationParameter
    private Map<String, Integer> paramsForProfilePosition;
    @ConfigurationParameter
    private Map<String, Integer> paramsForCurrent;
    protected boolean enabledToPublish = false;

    public CanOpenEPOS(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public int getCurrent() {
        return this.current;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public int getFollowingError() {
        return this.followingError;
    }

    @Override
    public int getVelocity() {
        return this.velocity;
    }

    @Override
    public boolean isEnabledToPublish() {
        return this.enabledToPublish;
    }

    @Override
    public void setEnabledToPublish(boolean enabledToPublish) {
        this.enabledToPublish = enabledToPublish;
    }

    @Override
    public boolean isParametersOK() {
        return this.parametersOK;
    }

    @Override
    public EPOSEnumerations.EposMode getMode() {
        return this.mode;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Reads the EPOS mode in the CPU of the EPOS device and updates the field mode.")
    public EPOSEnumerations.EposMode readMode() {
        try {
            EPOSEnumerations.EposMode readMode;
            int m = (int)this.readSDO(24673, 0);
            this.mode = readMode = EPOSEnumerations.EposMode.getMode(m);
            return readMode;
        }
        catch (SDORequestException ex) {
            String msg = " no response to command: readMode - POWER FAILURE ? ";
            this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, msg, this.name, ex);
            return this.mode;
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Changes EPOS mode in the CPU of the EPOS device and updates the field mode.")
    public void changeMode(EPOSEnumerations.EposMode newMode) {
        this.writeSDO(24672, 0, 1, newMode.getMode());
        this.mode = newMode;
        this.publishData();
    }

    @Override
    public void changeProfileVelocity(int newVelocity) {
        try {
            this.writeParameter(EPOSEnumerations.Parameter.ProfileVelocity, newVelocity);
        }
        catch (Exception ex) {
            String msg = this.name + " : could not change ProfileVelocity to value " + newVelocity;
            FCSCst.FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg, ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Changes an EPOS parameter for this controller. Writes the new value on the CPU of the controller.Changes the new value in the configuration. But doesn't save the new parameter in the CPU. To save in CPU controller, use command saveParameters and saveAllChanges.To save configuration, use command saveAllChanges.")
    public void changeEPOSParameter(String key, int value) {
        String paramsToChangeName;
        Map<String, Integer> paramsToChange;
        EPOSEnumerations.Parameter parameter = EPOSEnumerations.Parameter.valueOf(key);
        this.writeParameter(parameter, value);
        EPOSEnumerations.EposMode eposMode = EPOSEnumerations.EposMode.getModeForParameter(parameter);
        if (EPOSEnumerations.EposMode.CURRENT.equals((Object)eposMode)) {
            paramsToChange = this.paramsForCurrent;
            paramsToChangeName = "paramsForCurrent";
        } else if (EPOSEnumerations.EposMode.PROFILE_POSITION.equals((Object)eposMode)) {
            paramsToChange = this.paramsForProfilePosition;
            paramsToChangeName = "paramsForProfilePosition";
        } else if (EPOSEnumerations.EposMode.HOMING.equals((Object)eposMode)) {
            paramsToChange = this.paramsForHoming;
            paramsToChangeName = "paramsForHoming";
        } else {
            throw new IllegalArgumentException(key + " no parameter list is defined for mode: " + (Object)((Object)eposMode));
        }
        paramsToChange.put(key, value);
        ((ConfigurationService)this.subs.getAgentService(ConfigurationService.class)).getComponentConfigurationEnvironment(this.name).change(paramsToChangeName, paramsToChange);
        FCSCst.FCSLOG.info((Object)(this.name + ":changed EPOS parameter " + key + "for mode " + (Object)((Object)eposMode)));
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="This methods writes in the CPU of the EPOS device the values of the parameters set for the mode given as argument")
    public void writeParameters(EPOSEnumerations.EposMode mode) {
        String modeIS = mode.toString();
        Map<String, Integer> paramsMap = null;
        switch (mode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                assert (false) : mode;
                break;
            }
        }
        if (paramsMap == null) {
            throw new EPOSConfigurationException(this.name + "parameters for mode :" + modeIS + "are NULL");
        }
        if (paramsMap.isEmpty()) {
            throw new EPOSConfigurationException(this.name + "parameters for mode :" + modeIS + "are not defined.");
        }
        this.writeParameters(paramsMap);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Set EPOS parameter with the value given as argument.")
    public void writeParameter(EPOSEnumerations.Parameter param, int value) {
        this.writeSDO(param.getIndex(), param.getSubindex(), param.getSize(), value);
    }

    @Override
    public long readParameter(EPOSEnumerations.Parameter param) {
        try {
            long value = this.readSDO(param.getIndex(), param.getSubindex());
            FCSCst.FCSLOG.debug((Object)(this.name + " readParameter:" + param.name() + "=" + value + " in decimal format  (valueInHexa=" + Long.toHexString(value) + ")"));
            return EPOSController.convertEPOSValue(param, value, this.name);
        }
        catch (SDORequestException ex) {
            String msg = this.getName() + " Error in reading Parameter: " + (Object)((Object)param);
            this.raiseWarning(FcsEnumerations.FcsAlert.PARAMETER_ERROR, msg, this.name, ex);
            return 0L;
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read controller's parameter in the CPU for each mode and warn if a parameter has not the same value as in the configuration.Then publish data.")
    public void initializeAndCheckHardware() {
        this.checkBooted();
        this.mode = this.readMode();
        this.parametersOK = true;
        this.checkParameters(EPOSEnumerations.EposMode.CURRENT);
        this.checkParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.checkParameters(EPOSEnumerations.EposMode.HOMING);
        this.checkFault();
        this.initialized = true;
        if (!this.parametersOK) {
            FCSCst.FCSLOG.warning((Object)(this.name + " Some parameter values are not the same in CPU and configuration system."));
        }
        this.publishData();
        FCSCst.FCSLOG.info((Object)(this.name + ": is INITIALIZED."));
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Restore default parameters. AT YOUR OWN RISK.")
    public void restoreParameters() {
        this.writeSDO(4113, 1, 4, 1684107116);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Write a value in the control world (index: 6040, subindex: 0, size: 2)")
    public void writeControlWord(int value) {
        this.writeSDO(24640, 0, 2, value);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read control world (index: 6040, subindex: 0, size: 2) and print it in hexadecimal format.")
    public String printControlWord() {
        return Integer.toHexString((short)this.readSDO(24640, 0));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read control world (index: 6040, subindex: 0, size: 2) in controller CPU.")
    public short readControlWord() {
        return (short)this.readSDO(24640, 0);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read status world (index: 6041, subindex: 0, size: 2)")
    public int readStatusWord() {
        return (int)this.readSDO(24641, 0);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Sent current to controller the EPOS CPU. UNIT in mA / FORMAT in decimal")
    public void writeCurrent(int aValue) {
        if (!EPOSEnumerations.EposMode.CURRENT.equals((Object)this.mode)) {
            throw new RejectedCommandException(this.name + " is not in CURRENT mode.");
        }
        this.writeSDO(8240, 0, 2, aValue);
        FCSCst.FCSLOG.info((Object)(this.name + ": sent current to controller=" + aValue));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="readCurrentActualValue", description="In Current Mode this methods returns the current actualy received by the motor.")
    public int readCurrent() {
        long unsCurrent = this.readSDO(24696, 0);
        this.current = FcsUtils.convertInteger16(unsCurrent);
        FCSCst.FCSLOG.debug((Object)(this.name + ":readCurrent=" + this.current + " Integer16 read=" + unsCurrent));
        return this.current;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="readCurrentAverage", description="In Current Mode this methods returns the average of the current  received by the motor.")
    public int readCurrentAverageValue() {
        long readAverageCurrent = this.readSDO(8231, 0);
        this.current = FcsUtils.convertInteger16(this.current);
        FCSCst.FCSLOG.debug((Object)(this.name + ":readAverageCurrent SDO=" + readAverageCurrent + " current = " + this.current));
        return this.current;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return motor velocity read on controller CPU. Unit: rpm")
    public int readVelocity() {
        long unsVelocity = this.readSDO(8232, 0);
        this.velocity = FcsUtils.convertInteger32(unsVelocity);
        FCSCst.FCSLOG.debug((Object)(this.name + " Velocity actual value averaged:" + this.velocity + " Unsigned value:" + unsVelocity));
        return this.velocity;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return Following Error Actual Value read on controller CPU.")
    public int readFollowingError() {
        this.followingError = FcsUtils.convertInteger16(this.readSDO(8436, 0));
        FCSCst.FCSLOG.debug((Object)(this.name + " Following Error Actual Value =" + this.followingError));
        return this.followingError;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position. Target position has to be given in microns.")
    public void writeTargetPosition(int aValue) {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new RejectedCommandException(this.name + " is not in PROFILE_POSITION mode");
        }
        this.writeSDO(24698, 0, 4, aValue);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="set target velocity in mode PROFILE_VELOCITY.")
    public void writeTargetVelocity(int velocity) {
        if (!this.mode.equals((Object)EPOSEnumerations.EposMode.PROFILE_VELOCITY)) {
            throw new RejectedCommandException(this.name + " is not in PROFILE_VELOCITY mode");
        }
        this.writeSDO(24831, 0, 4, velocity);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() {
        this.checkBooted();
        if (this.readNumberOfErrors() > 0) {
            this.inError = true;
            int errorRegisterCode = this.readErrorRegister();
            this.errorRegister = CanOpenErrorsTable.getErrorRegisterNameByCode(errorRegisterCode);
            this.updateErrorHistory();
            this.publishData();
            String errorHistoryString = this.displayErrorHistory();
            this.raiseAlarm(FcsEnumerations.FcsAlert.EMCY, errorHistoryString, this.name);
            throw new FcsHardwareException(this.name + " is in fault. " + errorHistoryString);
        }
        this.resetError();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clear faults on the controller.", alias="resetFault")
    public void faultReset() {
        this.writeControlWord(128);
        this.resetError();
        this.clearAlarm(FcsEnumerations.FcsAlert.EMCY, this.name);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="For every parameter to be defined for this mode this method compares the values in configuration with the value stored in controller CPUand throws a FcsHardwareException if these values are not equal.")
    public void checkParameters(EPOSEnumerations.EposMode aMode) {
        Map<String, Integer> paramsMap = null;
        switch (aMode) {
            case HOMING: {
                paramsMap = this.paramsForHoming;
                break;
            }
            case PROFILE_POSITION: {
                paramsMap = this.paramsForProfilePosition;
                break;
            }
            case CURRENT: {
                paramsMap = this.paramsForCurrent;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (paramsMap == null) {
            throw new FcsHardwareException(this.name + "parameters for mode :" + aMode.toString() + "are NULL in configuration system.");
        }
        if (paramsMap.isEmpty()) {
            throw new FcsHardwareException(this.name + "parameters for mode :" + aMode.toString() + "are not defined in configuration system.");
        }
        this.checkParameters(paramsMap);
    }

    public void checkParameters(Map<String, Integer> paramsMap) {
        boolean errorFound = false;
        String causeError = "";
        for (Map.Entry<String, Integer> entry : paramsMap.entrySet()) {
            String paramName = entry.getKey();
            int configValue = entry.getValue();
            long controllerValue = 0L;
            try {
                controllerValue = this.readParameter(paramName);
            }
            catch (SDORequestException ex) {
                String cause = this.getName() + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription() + " to command: checkParameters - POWER FAILURE ? ";
                this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, cause, this.name, ex);
            }
            if ((long)configValue == controllerValue) continue;
            causeError = causeError + paramName + " value found in configuration=" + configValue + " value read in CPU=" + controllerValue + "\n";
            errorFound = true;
        }
        if (errorFound) {
            this.raiseWarning(FcsEnumerations.FcsAlert.PARAMETER_ERROR, causeError, this.name);
        }
        this.parametersOK = !errorFound;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Publish data for the controller on the status bus.")
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByEPOSController()));
    }
}

