/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public interface EPOSControllerForCarousel
extends EPOSController {
    @Command(type=Command.CommandType.ACTION, level=1, description="Set PositionSensorType to Absolute encoder SSI (value is 4)")
    default public void setPositionSensorTypeEncoderSSI() {
        FCSCst.FCSLOG.info((Object)(this.getName() + " setting PositionSensorType Absolute encoder SSI"));
        int sleepTime = 100;
        this.disableOperation();
        FcsUtils.sleep(sleepTime, this.getName());
        this.disableVoltage();
        FcsUtils.sleep(sleepTime, this.getName());
        this.writeParameter(EPOSEnumerations.Parameter.PositionSensorType, 4);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Set PositionSensorType to Sinus Incremental Encoder(value is 8)")
    default public void setPositionSensorTypeSinusIncrementalEncoder() {
        FCSCst.FCSLOG.info((Object)(this.getName() + " setting PositionSensorType Sinus Incremental Encoder"));
        int sleepTime = 100;
        this.disableOperation();
        FcsUtils.sleep(sleepTime, this.getName());
        this.disableVoltage();
        FcsUtils.sleep(sleepTime, this.getName());
        this.writeParameter(EPOSEnumerations.Parameter.PositionSensorType, 8);
        FcsUtils.sleep(sleepTime, this.getName());
        long positionSensorType = this.readParameter(EPOSEnumerations.Parameter.PositionSensorType);
        if (positionSensorType != 8L) {
            throw new FcsHardwareException(this.getName() + " PositionSensorType should be 8.");
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    default public void defineAbsolutePosition(int position) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " Defining Absolute Position:" + position));
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
        this.enable();
        this.writeControlWord(31);
        this.checkHomingDone();
    }
}

