/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarousel;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;

public class SimuCarouselControllerTest
extends CcsTestCaseTemplate {
    private static Subsystem carouselSubsystem;
    private static SimuCarousel carousel;
    private static SimuCarouselController carouselController;
    private static CarouselSocket socket1;
    private static CarouselSocket socket2;
    private static CarouselSocket socket3;
    private static CarouselSocket socket4;
    private static CarouselSocket socket5;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF SimuCarouselController        ");
        System.out.println("***************************************");
        CCS.initializeScriptingEnvironment();
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        carouselSubsystem = BootUtils.getSubsystemFromFile((String)"carousel", (String)"");
        carouselSubsystem.startAgent();
        ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = carouselSubsystem.getComponentLookup();
        carousel = (SimuCarousel)lookup.getComponentByPath("carousel");
        carouselController = (SimuCarouselController)lookup.getComponentByPath("carouselController");
        socket1 = (CarouselSocket)lookup.getComponentByPath("socket1");
        socket2 = (CarouselSocket)lookup.getComponentByPath("socket2");
        socket3 = (CarouselSocket)lookup.getComponentByPath("socket3");
        socket4 = (CarouselSocket)lookup.getComponentByPath("socket4");
        socket5 = (CarouselSocket)lookup.getComponentByPath("socket5");
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("****************************************************");
        System.out.println("*** shutdown of carousel subsystem               ***");
        System.out.println("****************************************************");
        carouselSubsystem.shutdownAgent();
        ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() throws DriverException {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testWriteTargetPosition() {
        System.out.println("###############################################################");
        System.out.println("test of testWriteTargetPosition of class SimuCarouselController");
        System.out.println("###############################################################");
        int finalPosition = socket2.getStandbyPosition();
        int initialPosition = carousel.getPosition();
        System.out.println("test with finalPosition=" + finalPosition + " and initialPosition=" + initialPosition);
        carouselController.writeTargetPosition(finalPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket2 is at standby", (boolean)socket2.isAtStandby());
        Assert.assertFalse((String)"socket1 is not at standby", (boolean)socket1.isAtStandby());
        Assert.assertEquals((String)"carouselController.readPosition", (long)finalPosition, (long)carouselController.readPosition());
        finalPosition = socket4.getStandbyPosition();
        initialPosition = carousel.getPosition();
        System.out.println("test with finalPosition=" + finalPosition + " and initialPosition=" + initialPosition);
        carouselController.writeTargetPosition(finalPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket4 is at standby", (boolean)socket4.isAtStandby());
        Assert.assertFalse((String)"socket2 is not at standby", (boolean)socket2.isAtStandby());
        finalPosition = socket5.getStandbyPosition();
        initialPosition = carousel.getPosition();
        System.out.println("test with pos=" + finalPosition + " and initialPosition=" + initialPosition);
        carouselController.writeTargetPosition(finalPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket5 is at standby", (boolean)socket5.isAtStandby());
        Assert.assertFalse((String)"socket4 is not at standby", (boolean)socket4.isAtStandby());
        finalPosition = socket3.getStandbyPosition();
        initialPosition = carousel.getPosition();
        System.out.println("test with pos=" + finalPosition + " and initialPosition=" + initialPosition);
        carouselController.writeTargetPosition(finalPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket3 is at standby", (boolean)socket3.isAtStandby());
        Assert.assertFalse((String)"socket5 is not at standby", (boolean)socket5.isAtStandby());
        finalPosition = socket1.getStandbyPosition();
        initialPosition = carousel.getPosition();
        System.out.println("test with pos=" + finalPosition + " and initialPosition=" + initialPosition);
        carouselController.writeTargetPosition(finalPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket1 is at standby", (boolean)socket1.isAtStandby());
        Assert.assertFalse((String)"socket3 is not at standby", (boolean)socket3.isAtStandby());
    }

    @Test
    public void testUpdateFakePDOData() {
        System.out.println("updateFakePDOData of class SimuCarouselController");
        long value = 0L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = 1L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = 65535L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = -2234066821449711617L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = -2305671193734396952L;
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
    }

    @Test
    public void testSimulatePosition() {
        System.out.println("simulatePosition of class SimuCarouselController");
        int pos = 1;
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        Assert.assertEquals((String)"carouselController position", (long)pos, (long)carouselController.readPosition());
        pos = 0;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        pos = 1;
        System.out.println("pos = " + pos);
        long pdo = (long)pos << 32;
        long mask = 0xFFFFFFFFL;
        long newpdo = pdo | carouselController.getPdo1() & mask;
        carouselController.simulatePosition(pos);
        Assert.assertEquals((String)"pdo1", (long)newpdo, (long)carouselController.getPdo1());
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        pos = 3000;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        pos = -204200;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        carousel.updateState();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -1075906;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -1948470;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -2821074;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -3694258;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -1;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
    }
}

