/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.FcsMain;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;

public class FcsToto
extends CcsTestCaseTemplate {
    private static Subsystem fcsSubsystem = null;
    private static FcsMain main;
    private static Autochanger autochanger;
    private static AutochangerTwoTrucks trucks;
    private static SimuAutochangerPlutoGateway acPlutoGateway;
    private static AutochangerOnlineClamp onlineClampXminus;
    private static AutochangerOnlineClamp onlineClampXplus;
    private static AutochangerOnlineClamp onlineClampYminus;
    private static AutochangerOnlineClamp[] onelineClampsList;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("************************************************************************************");
        System.out.println("***                  TESTS OF THE WHOLE FCS SIMULATED                            ***");
        System.out.println("************************************************************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.fcs.run.mode", "simulation");
        fcsSubsystem = BootUtils.getSubsystemFromFile((String)"fcs", (String)"");
        fcsSubsystem.startAgent();
        ((AgentStateService)fcsSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = fcsSubsystem.getComponentLookup();
        main = (FcsMain)lookup.getComponentByPath("main");
        autochanger = (Autochanger)lookup.getComponentByPath("autochanger");
        acPlutoGateway = (SimuAutochangerPlutoGateway)lookup.getComponentByPath("acSensorsGateway");
        trucks = (AutochangerTwoTrucks)lookup.getComponentByPath("autochangerTrucks");
        trucks.updatePosition();
        onlineClampXminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXminus");
        onlineClampXplus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXplus");
        onlineClampYminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampYminus");
        for (AutochangerOnlineClamp clamp : onelineClampsList = new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus, onlineClampYminus}) {
            clamp.setIncrementCurrentToClose(300);
            clamp.setIncrementCurrentToOpen(300);
            clamp.setIncrementCurrentToClamp(532);
            clamp.setInitialCurrentToClose(300);
            clamp.setFinalCurrentToClose(1800);
            clamp.setCurrentToOpen(-300);
            clamp.setCurrentToClamp(4992);
        }
        Assert.assertTrue((String)"Carousel and Autochanger hardware is ready", (boolean)main.isChangerReady());
    }

    @AfterClass
    public static void after() throws Exception {
        fcsSubsystem.shutdownAgent();
        ((AgentStateService)fcsSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
    }

    @Before
    public void setUp() throws DriverException {
        Utils.printJoliSetUp("FcsTest");
    }

    @Test
    public void testSimulateAutochangerTrucksAreAtStandby() {
        System.out.println("************************************************************************************");
        System.out.println("*** test simulateAutochangerTrucksAreAtStandby from SimuAutochangerPlutoGateway  ***");
        System.out.println("************************************************************************************");
        int id = 29;
        acPlutoGateway.simulateFilterIDOnAutochanger(29);
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)("filter on trucks is now " + id), (long)id, (long)autochanger.getFilterID());
        Assert.assertTrue((String)"filter ID 29 is on AC", (boolean)autochanger.isFilterOnAC(29));
        acPlutoGateway.simulateAutochangerTrucksAreAtStandby();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"AC trucks at STANDBY", (boolean)trucks.isAtStandby());
        Assert.assertTrue((String)"filter ID 29 is still on AC", (boolean)autochanger.isFilterOnAC(29));
    }

    @Test
    public void testExchangeBetweenCarouselAndAutochanger() throws DriverException {
        System.out.println("*******************************************************");
        System.out.println("*** test Exchange Between Carousel And Autochanger  ***");
        System.out.println("*******************************************************");
        main.setFilter(15);
        Assert.assertEquals((String)"filter online ID", (long)15L, (long)autochanger.getFilterID());
    }

    public void launchScript() throws Exception {
        System.out.println("**************************************");
        System.out.println("***       launch  fcsTest.py       ***");
        System.out.println("**************************************");
        CCS.initializeScriptingEnvironment();
        Assert.assertTrue((String)"fcsSubsystem should be in OPERATIONAL phase.", (boolean)((AgentStateService)fcsSubsystem.getAgentService(AgentStateService.class)).isInState((Enum)PhaseState.OPERATIONAL));
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/fcsTest.py", (String[])new String[0]);
        System.out.println("**************************************");
        System.out.println("*** end of execution of fcsTest.py ***");
        System.out.println("**************************************");
    }
}

