
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;

/**
 * This represents a model for the pluto GAteway used in loader-standalone subsystem.
 * In loader-standalone there is a fakeAutochanger : an electric switch which can be switched ON and OFF.
 This simulates that the filter in the loader (if there is one) is held by the autochanger.
 This is used to test the opening or closing of the clamp in the same way that for the loader when it's
 attached to the camera.

 The value of the switch is given by a numeric sensor (value 0 or 1) : acAF3
 that we have in the loader-standalone.

 The simulation of the loader-standalone have to simulate that the fakeAutochnager holds or not the filter.
 This is the goal of the class SimuLoaderStandalonePlutoGateway.
 *
 * @author virieux
 */
public class SimuLoaderStandalonePlutoGateway extends SimuLoaderPlutoGateway {

    //autochangerHoldingFilterSensor
    private ComplementarySensors autochangerHoldingFilterSensor;

    public SimuLoaderStandalonePlutoGateway(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void init() {
        super.init();
        ComponentLookup lookup = subs.getComponentLookup();
        this.autochangerHoldingFilterSensor = (ComplementarySensors) lookup.getComponentByPath("acAF3");
        simulateAutochangerIsNotHoldingFilter();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsHoldingFilter() {
        replaceSensorValue(autochangerHoldingFilterSensor.getSensor(), true);
        replaceSensorValue(autochangerHoldingFilterSensor.getSensorC(), false);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsNotHoldingFilter() {
        replaceSensorValue(autochangerHoldingFilterSensor.getSensor(), false);
        replaceSensorValue(autochangerHoldingFilterSensor.getSensorC(), true);

    }

}
