/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenTTC580;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarousel;

public class SimuTTC580
extends CanOpenTTC580 {
    CarouselSocket socket1;
    CarouselSocket socket2;
    CarouselSocket socket3;
    CarouselSocket socket4;
    CarouselSocket socket5;
    SimuCarousel carousel;
    protected final Map<String, CarouselSocket> socketMapByID = new HashMap<String, CarouselSocket>();

    public SimuTTC580(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void init() {
        super.init();
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.carousel = (SimuCarousel)lookup.getComponentByPath("carousel");
        this.socket1 = (CarouselSocket)lookup.getComponentByPath("socket1");
        this.socket1 = (CarouselSocket)lookup.getComponentByPath("socket1");
        this.socket2 = (CarouselSocket)lookup.getComponentByPath("socket2");
        this.socket3 = (CarouselSocket)lookup.getComponentByPath("socket3");
        this.socket4 = (CarouselSocket)lookup.getComponentByPath("socket4");
        this.socket5 = (CarouselSocket)lookup.getComponentByPath("socket5");
        this.socketMapByID.put("1", this.socket1);
        this.socketMapByID.put("2", this.socket2);
        this.socketMapByID.put("3", this.socket3);
        this.socketMapByID.put("4", this.socket4);
        this.socketMapByID.put("5", this.socket5);
    }

    public void simulateAllSocketCLAMPEDONFILTER() {
        FCSCst.FCSLOG.info((Object)"===> INITIALISATION OF CLAMPS STATE <===");
        this.simulateSocketClampedOnFilter(true, (short)1);
        this.simulateSocketClampedOnFilter(false, (short)2);
        this.simulateSocketClampedOnFilter(false, (short)3);
        this.simulateSocketClampedOnFilter(false, (short)4);
        this.simulateSocketClampedOnFilter(false, (short)5);
    }

    @Override
    public void initializeAndCheckHardware() {
        super.initializeAndCheckHardware();
        this.updateFakePDOData(this.cobid1, 0L);
        this.updateFakePDOData(this.cobid2, (long)Math.pow(2.0, 59.0));
    }

    public void updateFakePDOData(int cobid, long newPdo) {
        if (cobid == this.cobid1) {
            this.pdo1 = newPdo;
        } else if (cobid == this.cobid2) {
            this.pdo2 = newPdo;
        }
        ((SimuCanOpenInterface)this.tcpProxy.getCanInterface()).simulatePDOData(cobid, newPdo);
    }

    private static void checkID(short id) {
        if (id < 1 || id > 5) {
            throw new IllegalArgumentException(id + " not a valid socket number");
        }
    }

    private static void checkSensorValue(int value) {
        if (value > 4095) {
            throw new IllegalArgumentException(value + " value can't be > " + 4095);
        }
    }

    public void simulateSocketAtStandby(short socketID) {
        System.out.println("simulate socket at STANDBY: " + socketID);
        SimuTTC580.checkID(socketID);
        long sock = (long)socketID << 61;
        long mask = 0x1FFFFFFFFFFFFFFFL;
        long newpdo = sock | this.pdo1 & mask;
        System.out.println("   pdo1=" + Long.toBinaryString(this.pdo1));
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
        this.simulateSlaveStatus((short)1);
        CarouselSocket socket = this.socketMapByID.get(Integer.toString(socketID));
        this.carousel.simulateCarouselPosition(socket.getStandbyPosition());
    }

    public void simulateSocketNotAtStandby(short socketID) {
        System.out.println("simulate socket NOT at STANDBY: " + socketID);
        SimuTTC580.checkID(socketID);
        long sock = (long)socketID << 61;
        long mask = 0x1FFFFFFFFFFFFFFFL;
        long newpdo = sock | this.pdo2 & mask;
        System.out.println("   pdo2=" + Long.toBinaryString(this.pdo2));
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
        this.simulateSlaveStatusNotAtS((short)2);
    }

    public void updatePdo1ForNoSocketInPosition() {
        long sock = 0L;
        long mask = 0x1FFFFFFFFFFFFFFFL;
        long newpdo = sock | this.pdo1 & mask;
        System.out.println("   pdo1=" + Long.toBinaryString(this.pdo1));
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
        this.simulateSlaveStatus((short)2);
    }

    public void simulateSlaveStatus(short slaveStatus) {
        System.out.println("simulate SlaveStatus: " + slaveStatus);
        long status = (long)slaveStatus << 58;
        long mask = -2017612633061982209L;
        long newpdo = status | this.pdo1 & mask;
        System.out.println("   pdo1=" + Long.toBinaryString(this.pdo1));
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateSlaveStatusNotAtS(short slaveStatus) {
        System.out.println("simulate SlaveStatus: " + slaveStatus);
        long status = (long)slaveStatus << 58;
        long mask = -2017612633061982209L;
        long newpdo = status | this.pdo2 & mask;
        System.out.println("   pdo2=" + Long.toBinaryString(this.pdo2));
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    @Command
    public void simuSocketAtSandbyIsLocked(short id) {
        this.simulateSocketAtStandby(id);
        boolean atStandby = true;
        this.simuSocketIsLocked(atStandby, id);
    }

    public void simuSocketNotAtStandbyIsLocked(short id) {
        this.simulateSocketNotAtStandby(id);
        boolean atStandby = false;
        this.simuSocketIsLocked(atStandby, id);
    }

    public void simuSocketIsLocked(boolean atStandby, short id) {
        CarouselSocket socket = this.socketMapByID.get(Integer.toString(id));
        this.simulateClampIsLocked(atStandby, socket.getClampXminus());
        this.simulateClampIsLocked(atStandby, socket.getClampXplus());
    }

    public void simuSocketIsUnlocked(boolean atStandby, short id) {
        CarouselSocket socket = this.socketMapByID.get(Integer.toString(id));
        this.simulateClampIsUnlocked(atStandby, socket.getClampXminus());
        this.simulateClampIsUnlocked(atStandby, socket.getClampXplus());
    }

    public void simuSocketLockable(boolean atStandby, short id) {
        CarouselSocket socket = this.socketMapByID.get(Integer.toString(id));
        this.simulateClampFilterIsLockable(atStandby, socket.getClampXminus());
        this.simulateClampFilterIsLockable(atStandby, socket.getClampXplus());
    }

    public void simuSocketNoFilter(boolean atStandby, short id) {
        CarouselSocket socket = this.socketMapByID.get(Integer.toString(id));
        this.simulateClampNoFilter(atStandby, socket.getClampXminus());
        this.simulateClampNoFilter(atStandby, socket.getClampXplus());
    }

    public void simulateSocketClampedOnFilter(boolean atStandby, short id) {
        FCSCst.FCSLOG.info((Object)("==== simulateSocketClampedOnFilter for socket" + id));
        if (atStandby) {
            this.simulateSocketAtStandby(id);
        } else {
            this.simulateSocketNotAtStandby(id);
        }
        this.simuSocketLockable(atStandby, id);
        this.simuSocketIsLocked(atStandby, id);
        this.carousel.updateStateWithSensors();
    }

    public void simulateSocketUnclampedOnFilter(boolean atStandby, short id) {
        FCSCst.FCSLOG.info((Object)("==== simulateSocketUnclampedOnFilter for socket" + id));
        if (atStandby) {
            this.simulateSocketAtStandby(id);
        } else {
            this.simulateSocketNotAtStandby(id);
        }
        this.simuSocketLockable(atStandby, id);
        this.simuSocketIsUnlocked(atStandby, id);
        this.carousel.updateStateWithSensors();
    }

    public void simulateSocketUnclampedEmpty(boolean atStandby, short id) {
        FCSCst.FCSLOG.info((Object)("==== simulateSocketUnclampedEmpty for socket" + id));
        if (atStandby) {
            this.simulateSocketAtStandby(id);
        } else {
            this.simulateSocketNotAtStandby(id);
        }
        this.simuSocketNoFilter(atStandby, id);
        this.simuSocketIsUnlocked(atStandby, id);
        this.carousel.updateStateWithSensors();
    }

    public void simulateSocketREADYTOCLAMP(short id) {
        this.simuSocketNoFilter(true, id);
        this.simulateSocketAtStandby(id);
        CarouselSocket socket = this.socketMapByID.get(Integer.toString(id));
        this.simulateClampIsUnlocked(true, socket.getClampXminus());
        this.simulateClampIsLocked(true, socket.getClampXplus());
        socket.getClampXminus().getController().disableOperation();
        socket.getClampXplus().getController().disableOperation();
        this.carousel.updateStateWithSensors();
    }

    protected void simulateLockSensorXminusValue(boolean atStandby, long lockValue) {
        System.out.println("lockValue=" + Long.toBinaryString(lockValue));
        long pdo = lockValue << 36;
        long mask = -281406257233921L;
        if (atStandby) {
            long newpdo = pdo | this.pdo1 & mask;
            System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
            this.updateFakePDOData(this.cobid1, newpdo);
        } else {
            long newpdo = pdo | this.pdo2 & mask;
            System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
            this.updateFakePDOData(this.cobid2, newpdo);
        }
    }

    protected void simulateFilterPresenceXminusValue(boolean atStandby, long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue << 24;
        long mask = -68702699521L;
        if (atStandby) {
            long newpdo = pdo | this.pdo1 & mask;
            System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
            this.updateFakePDOData(this.cobid1, newpdo);
        } else {
            long newpdo = pdo | this.pdo2 & mask;
            System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
            this.updateFakePDOData(this.cobid2, newpdo);
        }
    }

    protected void simulateLockSensorXplusValue(boolean atStandby, long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue << 12;
        long mask = -16773121L;
        if (atStandby) {
            long newpdo = pdo | this.pdo1 & mask;
            System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
            this.updateFakePDOData(this.cobid1, newpdo);
        } else {
            long newpdo = pdo | this.pdo2 & mask;
            System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
            this.updateFakePDOData(this.cobid2, newpdo);
        }
    }

    protected void simulateFilterPresenceXplusValue(boolean atStandby, long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue & 0xFFFL;
        long mask = -4096L;
        if (atStandby) {
            long newpdo = pdo | this.pdo1 & mask;
            System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
            this.updateFakePDOData(this.cobid1, newpdo);
        } else {
            long newpdo = pdo | this.pdo2 & mask;
            System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
            this.updateFakePDOData(this.cobid2, newpdo);
        }
    }

    public void simulateClampIsLocked(boolean atStandby, CarouselClamp clamp) {
        int milieu = (clamp.getLockSensorMaxValue() - clamp.getLockSensorValueB()) / 2;
        int lockVal = (clamp.getLockSensorValueB() + milieu) / 4;
        this.simulateClampLockValue(atStandby, clamp, lockVal);
    }

    public void simulateClampIsUnlocked(boolean atStandby, CarouselClamp clamp) {
        int milieu = (clamp.getLockSensorValueA() - clamp.getLockSensorMinValue()) / 2;
        int lockVal = (clamp.getLockSensorMinValue() + milieu) / 4;
        this.simulateClampLockValue(atStandby, clamp, lockVal);
    }

    private void simulateClampLockValue(boolean atStandby, CarouselClamp clamp, int lockVal) {
        SimuTTC580.checkSensorValue(lockVal);
        if (clamp.getName().contains("Xminus")) {
            this.simulateLockSensorXminusValue(atStandby, lockVal);
        } else if (clamp.getName().contains("Xplus")) {
            this.simulateLockSensorXplusValue(atStandby, lockVal);
        } else {
            throw new IllegalArgumentException(clamp.getName() + " illegal value. Should contain Xminus or Xplus");
        }
    }

    public void simulateClampFilterIsLockable(boolean atStandby, CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceOffset1() + clamp.getFilterPresenceOffset2()) / 8;
        this.simulateClampFilterPresenceValue(atStandby, clamp, val);
    }

    public void simulateClampFilterIsNotLockable(boolean atStandby, CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceOffset2() + clamp.getFilterPresenceValueB()) / 8;
        this.simulateClampFilterPresenceValue(atStandby, clamp, val);
    }

    public void simulateClampNoFilter(boolean atStandby, CarouselClamp clamp) {
        int val = clamp.getFilterPresenceValueB() / 4 + 1;
        this.simulateClampFilterPresenceValue(atStandby, clamp, val);
    }

    public void simulateClampFilterIsInError(boolean atStandby, CarouselClamp clamp) {
        int val = clamp.getFilterPresenceOffset1() / 4 - 1;
        this.simulateClampFilterPresenceValue(atStandby, clamp, val);
    }

    private void simulateClampFilterPresenceValue(boolean atStandby, CarouselClamp clamp, int val) {
        SimuTTC580.checkSensorValue(val);
        if (clamp.getName().contains("Xminus")) {
            this.simulateFilterPresenceXminusValue(atStandby, val);
        } else if (clamp.getName().contains("Xplus")) {
            this.simulateFilterPresenceXplusValue(atStandby, val);
        } else {
            throw new IllegalArgumentException(clamp.getName() + " illegal value. Should contain Xminus or Xplus");
        }
    }

    public void simulateSocketAtStandbyOthersNotAtStandby(short socketID) {
        for (short i = 1; i < 6; i = (short)(i + 1)) {
            this.simulateSocketAtStandby(socketID);
            if (i == socketID) continue;
            this.simulateSocketNotAtStandby(i);
            this.carousel.updateStateWithSensors();
        }
    }

    public void simulateNoSocketAtStandby() {
        this.updatePdo1ForNoSocketInPosition();
        for (short i = 1; i < 6; i = (short)(i + 1)) {
            this.simulateSocketNotAtStandby(i);
            this.carousel.updateStateWithSensors();
        }
    }

    public void simulateSocketSensors(int pos) {
        System.out.println(this.name + " simulateSocketSensors with position = " + pos);
        short socketAtStandbyID = this.carousel.getSocketAtStandbyID(pos);
        if (socketAtStandbyID == 0) {
            this.simulateNoSocketAtStandby();
        } else {
            this.simulateSocketAtStandbyOthersNotAtStandby(socketAtStandbyID);
        }
    }

    public void updateDisengageFromAC() {
        CarouselSocket socketAtS = this.carousel.getSocketAtStandby();
        if (socketAtS == null) {
            FCSCst.FCSLOG.error((Object)(this.name + " no socket at standby"));
        } else {
            this.simuSocketNoFilter(true, (short)socketAtS.getId());
        }
    }

    public void updateStoreFilterOnCarousel(int filterID) {
        CarouselSocket socketAtS = this.carousel.getSocketAtStandby();
        if (socketAtS == null) {
            FCSCst.FCSLOG.error((Object)(this.name + " no socket at standby"));
        } else {
            this.carousel.getSocketAtStandby().setFilterID(filterID);
            this.simulateSocketClampedOnFilter(true, (short)socketAtS.getId());
        }
        FCSCst.FCSLOG.info((Object)("carousel filter ID = " + this.carousel.getSocketAtStandby().getFilterID()));
    }
}

