#####################################################################
#Script to test the simulated hardware of autochanger in standalone.
#This can be used with real hardware.
#This test is a part of integration tests.
#####################################################################
#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import CCS
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from org.lsst.ccs.command import CommandInvocationException
import java.time
#

timeoutFiveMillis = java.time.Duration.ofMillis(5)
timeoutThreeSec = java.time.Duration.ofSeconds(3)

CCS.setThrowExceptions(True);
#####################################################################
# launch autochanger-standalone subsystem and initialize
#####################################################################
subsName = "autochanger-standalone-simu"
autochangerStandalone = CCS.attachSubsystem(subsName)

print "Connected to autochanger ", autochangerStandalone

###autochanger
autochanger = CCS.attachSubsystem(subsName + "/autochanger")
###plutoGateway
plutoGateway = CCS.attachSubsystem(subsName + "/acSensorsGateway")
###autochangerTrucks
trucks = CCS.attachSubsystem(subsName + "/autochangerTrucks")
###latches
latches = CCS.attachSubsystem(subsName + "/latches")

timeoutForTrucksMotion = java.time.Duration.ofMillis(int(trucks.sendSynchCommand(timeoutFiveMillis,"getTimeoutForTrucksMotion")))
standbyPosition = int((trucks.sendSynchCommand(timeoutFiveMillis,"getStandbyPosition")))
handoffPosition = int((trucks.sendSynchCommand(timeoutFiveMillis,"getHandoffPosition")))
onlinePosition = int((trucks.sendSynchCommand(timeoutFiveMillis,"getOnlinePosition")))

timeoutForOpeningLatches = java.time.Duration.ofMillis(int(latches.sendSynchCommand(timeoutFiveMillis,"getTimeoutForOpening")))
timeoutForClosingLatches = java.time.Duration.ofMillis(int(latches.sendSynchCommand(timeoutFiveMillis,"getTimeoutForClosing")))

#####################################################################
# read sensors and updateState
#####################################################################
CCS.setThrowExceptions(False);

#Handle the thrown exceptions                                                                                                 
print "=> Read sensors and update state "
result = autochanger.sendSynchCommand(timeoutThreeSec,"updateStateWithSensors")

if isinstance(result.getResult(), CommandInvocationException):
     raise Exception(result.getResult())
print "state has been updated"

CCS.setThrowExceptions(True)

#####################################################################
# FONCTION move trucks to ONLINE
#####################################################################
def moveToOnline():
    "Move trucks to ONLINE"
    print "=>Moving to ONLINE"
    trucks.sendSynchCommand(timeoutForTrucksMotion, "goToOnline")
    #check that trucks are at ONLINE
    trucksPosition = int((trucks.sendSynchCommand(timeoutFiveMillis,"getPosition")))
    print "trucks position=", trucksPosition
    print "ONLINE position=", onlinePosition
    if trucksPosition == onlinePosition :
        print "=>Gone to ONLINE."
    else :
        raise Exception("Autochanger Trucks are NOT at ONLINE position")

#####################################################################
# FONCTION move trucks to HANDOFF
#####################################################################
def moveToHandoff():
    print "=>Moving to HANDOFF"
    CCS.setThrowExceptions(True);
    trucks.sendSynchCommand(timeoutForTrucksMotion,"goToHandoff")
    #check that trucks are at HANDOFF
    trucksPosition = int((trucks.sendSynchCommand(timeoutFiveMillis,"getPosition")))
    print "trucks position=", trucksPosition
    print "HANDOFF position=", handoffPosition
    if trucksPosition == handoffPosition:
        print "=>Gone to HANDOFF."
    else :
        raise Exception("Autochanger Trucks are NOT at HANDOFF position")


#####################################################################
# FONCTION move trucks to STANDBY
#####################################################################
def moveToStandby():
    print "=> Moving to STANDBY"
    trucks.sendSynchCommand(timeoutForTrucksMotion,"goToStandby")
    #check that trucks are at STANDBY
    trucksPosition = int((trucks.sendSynchCommand(timeoutFiveMillis,"getPosition")))
    print "trucks position =", trucksPosition
    print "STANDBY position =", standbyPosition
    if trucksPosition == standbyPosition :
        print "=> Gone to STANDBY."
    else :
        raise Exception("Autochanger Trucks are NOT at STANDBY position")

#####################################################################
# FONCTION should be empty. If not empty, raise an Exception
#####################################################################
def shouldBeEmpty(action):
    """
    If autochanger is NOT empty, raise an exception.
    """
    isEmpty = (autochanger.sendSynchCommand(timeoutFiveMillis," isEmpty"));
    print "isEmpty =", isEmpty
    if isEmpty :
        print "No filter on autochanger"
    else :
        raise Exception("Autochanger should be empty after action: " + action)
    
#####################################################################
# FONCTION should NOT be empty. If empty, raise an Exception
#####################################################################
def shouldNotBeEmpty(action):
    """
    If autochanger is empty, raise an exception.
    """
    isEmpty = (autochanger.sendSynchCommand(timeoutFiveMillis," isEmpty"));
    print "isEmpty =", isEmpty
    if isEmpty :
        raise Exception("Autochanger should NOT be empty after action: " + action)  
    else :
        print "A filter is on autochanger"


#################################################################################
# move trucks to ONLINE, then to HANDOFF, then to STANDBY, then back to HANDOFF 
#################################################################################
moveToOnline()
shouldBeEmpty("moveToOnline")

moveToHandoff()
shouldBeEmpty("moveToHandoff1")

moveToStandby()
shouldNotBeEmpty("moveToStandby")

moveToHandoff()
shouldBeEmpty("moveToHandoff2")

#############################################################################
# Go to STANDBY, grab filter, moves it to ONLINE, moves it back to STANDBY,
# ungrab it at STANDBY, and returns empty to HANDOFF.
#############################################################################
isEmpty = (autochanger.sendSynchCommand(timeoutFiveMillis, "isEmpty"))
if isEmpty :
    print "===> BEGIN Sequence"
else :
    raise Exception("Autochanger is not Empty.")
###
moveToStandby()
###
print "=> simulateFilterID"
plutoGateway.sendSynchCommand(timeoutFiveMillis, "simulateFilterID 1");

print "=> grabFilterAtStandby"
print "timeoutForOpeningLatches", timeoutForOpeningLatches
autochanger.sendSynchCommand(timeoutForOpeningLatches, "grabFilterAtStandby");

isEmpty = (autochanger.sendSynchCommand(timeoutFiveMillis, "isEmpty"));
if isEmpty :
    raise Exception("Autochanger is empty after grabFilterAtStandby. Something weird happened.")
else :
    filterID=int((autochanger.sendSynchCommand(timeoutFiveMillis, "getFilterOnTrucksID")))
    print "filter on autochanger trucks ID=", filterID
    print "===> Sequence can continue"

###Simulate that carousel is not holding a filter
###ONLY for simulation
print "=> simulateCarouselIsNotHoldingFilter"
plutoGateway.sendSynchCommand(timeoutFiveMillis, "simulateCarouselIsNotHoldingFilter")
autochangerStandalone.sendSynchCommand(timeoutFiveMillis, "updateStateWithSensors")

###
moveToOnline()

###
moveToStandby()
print "=> simulateCarouselIsHoldingFilter"
plutoGateway.sendSynchCommand(timeoutFiveMillis,"simulateCarouselIsHoldingFilter")
autochangerStandalone.sendSynchCommand(timeoutFiveMillis,"updateStateWithSensors")

###
print "=> ungrabFilterAtStandby"
print "timeoutForClosingLatches",timeoutForClosingLatches
autochanger.sendSynchCommand(timeoutForClosingLatches,"ungrabFilterAtStandby")

###
moveToHandoff()
print "===> END Sequence"

