/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuEPOSControllerTest
extends CcsTestCaseTemplate {
    private static Subsystem subs;
    private static SimuEPOSController controller;
    private static final String name = "controller";
    private static final Map<String, Integer> paramsForCurrent;
    private static final Map<String, Integer> paramsForProfilePosition;
    private static final Map<String, Integer> paramsForHoming;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF SimuEPOSControllerModule");
        System.out.println("***************************************");
        paramsForCurrent.put(EPOSEnumerations.Parameter.MotorType.toString(), 11);
        paramsForCurrent.put(EPOSEnumerations.Parameter.ContinuousCurrentLimit.toString(), 2360);
        paramsForCurrent.put(EPOSEnumerations.Parameter.OutputCurrentLimit.toString(), 4720);
        paramsForProfilePosition.put(EPOSEnumerations.Parameter.MotionProfileType.toString(), 0);
        paramsForHoming.put(EPOSEnumerations.Parameter.HomeOffset.toString(), 0);
        subs = BootUtils.getSubsystemFromFile((String)"test-simuEPOSController");
        subs.startAgent();
        ((AgentStateService)subs.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 10L, TimeUnit.SECONDS);
        controller = (SimuEPOSController)subs.getComponentLookup().getComponentByPath(name);
    }

    @AfterClass
    public static void after() throws Exception {
        subs.shutdownAgent();
        System.out.println("********* end of SimuEPOSControllerModule tests *************");
        ((AgentStateService)subs.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSetPosition() {
        System.out.println("setPosition");
        int actualPosition = 732;
        controller.setPosition(actualPosition);
        Assert.assertEquals((String)("controller position = " + actualPosition), (long)actualPosition, (long)controller.readPosition());
    }

    @Test
    public void testIsEnabledToPublish() {
        System.out.println("isEnabledToPublish");
        controller.enable();
        Assert.assertTrue((String)"controller is enabled", (boolean)controller.isEnabledToPublish());
    }

    @Test
    public void testIsParametersOK() {
        System.out.println("isParametersOK");
        Assert.assertTrue((String)"In simulation parameters are always OK.", (boolean)controller.isParametersOK());
    }

    @Test
    public void testInitializeAndCheckHardware() {
        System.out.println("initializeAndCheckHardware");
        controller.initializeAndCheckHardware();
        Assert.assertTrue((String)"controller is initialized", (boolean)controller.isInitialized());
    }

    @Test
    public void testGetMode() {
        System.out.println("getMode");
        controller.changeMode(EPOSEnumerations.EposMode.HOMING);
        Assert.assertEquals((String)"mode is HOMING", (Object)EPOSEnumerations.EposMode.HOMING, (Object)controller.getMode());
    }

    @Test
    public void testReadMode() {
        System.out.println("readMode");
        controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
        Assert.assertEquals((String)"mode is CURRENT", (Object)EPOSEnumerations.EposMode.CURRENT, (Object)controller.readMode());
    }

    @Test
    public void testChangeMode_EPOSEnumerationsEposMode() {
        System.out.println("changeMode");
        controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
        Assert.assertEquals((String)"mode is CURRENT", (Object)EPOSEnumerations.EposMode.CURRENT, (Object)controller.getMode());
    }

    @Test
    public void testIsInMode() {
        System.out.println("Test of method isInMode of class CanOpenEPOS");
        EPOSEnumerations.EposMode aMode = EPOSEnumerations.EposMode.PROFILE_POSITION;
        controller.changeMode(aMode);
        Assert.assertTrue((String)("controller should be in mode " + aMode), (boolean)controller.isInMode(aMode));
    }

    @Test
    public void testDefineAbsolutePosition() {
        System.out.println("defineAbsolutePosition");
        int position = 35;
        controller.defineAbsolutePosition(position);
        Assert.assertEquals((String)("position controller is " + position), (long)position, (long)controller.getPosition());
    }

    @Test
    public void testDisable() {
        System.out.println("disable");
        controller.shutdownController();
        Assert.assertFalse((String)"controller is disabled", (boolean)controller.isEnabled());
    }

    @Test
    public void testWriteTargetPosition() {
        System.out.println("writeTargetPosition");
        int position = 66;
        controller.writeTargetPosition(position);
        Assert.assertEquals((String)("position controller is " + position), (long)position, (long)controller.getPosition());
    }

    @Test
    public void testWriteCurrent() {
        System.out.println("writeCurrent");
        int aValue = 2314;
        controller.writeCurrent(aValue);
        Assert.assertEquals((String)("actualCurrent is " + aValue), (long)aValue, (long)SimuEPOSControllerTest.controller.actualCurrent);
    }

    @Test
    public void testReadPosition() {
        System.out.println("readPosition");
        int position = 378;
        controller.writeTargetPosition(position);
        Assert.assertEquals((String)("controller position is " + position), (long)position, (long)controller.readPosition());
    }

    @Test
    public void testReadSSIPosition() {
        System.out.println("readSSIPosition");
        SimuEPOSControllerTest.controller.ssiPosition = 63456;
        Assert.assertEquals((String)("controller.ssiPosition = " + SimuEPOSControllerTest.controller.ssiPosition), (long)SimuEPOSControllerTest.controller.ssiPosition, (long)controller.readSSIPosition());
    }

    @Test
    public void testSwitchOnEnableOperation() {
        System.out.println("switchOnEnableOperation");
        controller.switchOnEnableOperation();
        Assert.assertEquals((String)"statusWord", (long)7L, (long)controller.readStatusWord());
        Assert.assertTrue((String)"controller is enabled", (boolean)controller.isEnabled());
    }

    @Test
    public void testEnable() {
        System.out.println("enable");
        controller.enable();
        Assert.assertTrue((String)"controller is enabled", (boolean)controller.isEnabled());
    }

    public void testIsEnabled() {
        System.out.println("isEnabled");
        controller.writeControlWord(0);
        Assert.assertFalse((String)"controller is not enabled", (boolean)controller.isEnabled());
        controller.writeControlWord(7);
        Assert.assertTrue((String)"controller is enabled", (boolean)controller.isEnabled());
        controller.writeControlWord(1847);
        Assert.assertTrue((String)"controller is enabled", (boolean)controller.isEnabled());
        controller.writeControlWord(18227);
        Assert.assertFalse((String)"controller is not enabled", (boolean)controller.isEnabled());
        controller.writeControlWord(832);
        Assert.assertFalse((String)"controller is not enabled", (boolean)controller.isEnabled());
        controller.writeControlWord(17203);
        Assert.assertFalse((String)"controller is not enabled", (boolean)controller.isEnabled());
        controller.writeControlWord(823);
        Assert.assertTrue((String)"controller is enabled", (boolean)controller.isEnabled());
        controller.writeControlWord(50995);
        Assert.assertFalse((String)"controller is not enabled", (boolean)controller.isEnabled());
        controller.writeControlWord(34615);
        Assert.assertTrue((String)"controller is enabled", (boolean)controller.isEnabled());
    }

    public void testIsTargetReached() {
        System.out.println("isTargetReached");
        controller.writeControlWord(0);
        Assert.assertFalse((String)"target not reached", (boolean)controller.isTargetReached());
        int statusWord = controller.readStatusWord();
        controller.writeControlWord(FcsUtils.force2one((int)statusWord, (int)10));
        Assert.assertTrue((String)"target is reached", (boolean)controller.isTargetReached());
        controller.writeControlWord(823);
        Assert.assertFalse((String)"target is not reached", (boolean)controller.isTargetReached());
        statusWord = controller.readStatusWord();
        controller.writeControlWord(FcsUtils.force2one((int)statusWord, (int)10));
        Assert.assertTrue((String)"target is reached", (boolean)controller.isTargetReached());
        controller.writeControlWord(50995);
        Assert.assertTrue((String)"target is reached", (boolean)controller.isTargetReached());
        statusWord = controller.readStatusWord();
        controller.writeControlWord(FcsUtils.force2zero((int)statusWord, (int)10));
        Assert.assertFalse((String)"target is not reached", (boolean)controller.isTargetReached());
    }

    @Test
    public void testReadCurrent() {
        System.out.println("readCurrent");
        int current = 6547;
        controller.writeCurrent(current);
        Assert.assertEquals((String)("controller current is " + current), (long)current, (long)controller.readCurrent());
    }

    @Test
    public void testReadNumberOfErrors() {
        System.out.println("readNumberOfErrors");
        int expResult = 0;
        int result = controller.getErrorHistoryNB();
        Assert.assertEquals((String)"no error in simulation", (long)expResult, (long)result);
    }

    @Test
    public void testReadErrorRegister() {
        System.out.println("readErrorRegister");
        Assert.assertEquals((String)"in simulation error register is empty", (long)0L, (long)controller.readErrorRegister());
    }

    @Test
    public void testReadErrorHistory() {
        System.out.println("updateErrorHistory");
        controller.updateErrorHistory();
        Assert.assertArrayEquals((String)"in simulation error history is empty", (int[])new int[0], (int[])controller.getErrorHistory());
    }

    @Test
    public void testDisplayErrorHistory() {
        System.out.println("displayErrorHistory");
        String expResult = "No ERROR";
        Assert.assertEquals((String)"in simulation no error", (Object)expResult, (Object)controller.displayErrorHistory());
    }

    static {
        paramsForCurrent = new HashMap<String, Integer>();
        paramsForProfilePosition = new HashMap<String, Integer>();
        paramsForHoming = new HashMap<String, Integer>();
    }
}

