
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.drivers.CanCBXAI420;

/**
 * A Simulated CanCBXAI420 to be used in AC trucks simulation for proximity
 * sensors device.
 * The real device must return a value between umin and umax, 2
 * AC trucks configuration parameters. Those 2 parameters should not change a
 * lot, so for simulation a value between umin and umax has been choosen.
 *
 * @author virieux
 */
public class SimuCanCBXAI420 extends CanCBXAI420 {

    /**
     * A value between umin and umax.
     */
    public static double SIMULATED_VOLTAGE = 4.4;

    public SimuCanCBXAI420(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    /**
     *
     * @param inputNB
     * @return
     */
    @Override
    public double readVoltage(int inputNB) {
        return SIMULATED_VOLTAGE;
    }

}
