
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * Used to measure temperatures in carousel motor and brakes.
 *
 * @author virieux
 */
public class CanOpenPT100 extends CanOpenDevice {

    public static int processValueIndex = 0x9130;

    Long[] temperatures = new Long[5];

    @Override
    public void init() {
        for (int i = 1; i < 5; i++) {
            temperatures[i] = Long.valueOf(0);
        }
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1,
            description = "read temperatures on the device and update temperatures fields")
    public void updateTemperatures() {
        for (int i = 1; i < 5; i++) {
            temperatures[i] = readTemperature(i);
            FcsUtils.sleep(2, name);
        }
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1,
            description = "read temperature, argument : 1..4")
    public long readTemperature(int subindex) {
        return this.readSDO(processValueIndex, subindex);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1,
            description = "print the 4 temperatures read by this device")
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("\n");
        for (int i = 1; i < 5; i++) {
            sb.append("temperature")
                .append(i)
                .append(" = ")
                .append(temperatures[i])
                .append("\n");
        }
        return sb.toString();
    }

}
