/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenPT100
extends CanOpenDevice {
    public static int processValueIndex = 37168;
    Long[] temperatures = new Long[5];

    public void init() {
        for (int i = 1; i < 5; ++i) {
            this.temperatures[i] = 0L;
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read temperatures on the device and update temperatures fields")
    public void updateTemperatures() {
        for (int i = 1; i < 5; ++i) {
            this.temperatures[i] = this.readTemperature(i);
            FcsUtils.sleep(2, this.name);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read temperature, argument : 1..4")
    public long readTemperature(int subindex) {
        return this.readSDO(processValueIndex, subindex);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="print the 4 temperatures read by this device")
    public String toString() {
        StringBuilder sb = new StringBuilder("\n");
        for (int i = 1; i < 5; ++i) {
            sb.append("temperature").append(i).append(" = ").append(this.temperatures[i]).append("\n");
        }
        return sb.toString();
    }
}

