/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerLatch;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class AutochangerTwoLatches
extends MobileItem {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    private final AutochangerLatch latchXminus;
    private final AutochangerLatch latchXplus;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="lpmLatchesStatus")
    private DigitalSensor lpmLatchesStatus;
    private volatile FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private volatile FcsEnumerations.FilterPresenceStatus filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.UNKNOWN;
    private final long timeoutForClosing;
    private final long timeoutForOpening;

    public AutochangerTwoLatches(AutochangerLatch latchXminus, AutochangerLatch latchXplus) {
        this.latchXminus = latchXminus;
        this.latchXplus = latchXplus;
        this.timeoutForClosing = Math.max(latchXminus.getTimeoutForClosing(), latchXplus.getTimeoutForClosing());
        this.timeoutForOpening = Math.max(latchXminus.getTimeoutForOpening(), latchXplus.getTimeoutForOpening());
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutochangerTwoLatches.class, this.name);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 2 latches are initialized.")
    public boolean isInitialized() {
        return this.latchXminus.isInitialized() && this.latchXplus.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="return filterPresenceStatus")
    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max time for closing in millisecond.")
    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max time for opening in millisecond.")
    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if both latches are CLOSED.")
    public boolean isClosed() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.CLOSED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if both latches are OPENED.")
    public boolean isOpened() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.OPENED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if one of the latches is in ERROR state.")
    public boolean isInError() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
    }

    private boolean isInTravel() {
        return this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if there is no filter is latches.")
    public boolean isEmpty() {
        return this.latchXminus.isEmpty() && this.latchXplus.isEmpty();
    }

    public boolean isFilterEngagedInError() {
        return this.latchXminus.isFilterEngagedInError() || this.latchXplus.isFilterEngagedInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if autochanger is holding a filter.")
    public boolean isHoldingFilter() {
        return this.isFilterEngaged() && this.isClosed();
    }

    private boolean isFilterEngaged() {
        return !this.latchXminus.isEmpty() && !this.latchXplus.isEmpty();
    }

    @Override
    public boolean myDevicesReady() {
        return this.isInitialized();
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.latchXminus.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, "latchXminus");
        this.latchXplus.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, "latchXplus");
        if (this.latchXminus.getLockStatus() != this.latchXplus.getLockStatus()) {
            String msg = this.name + " sensors are in ERROR: latchXminus state=" + this.latchXminus.getLockStatus() + " latchXplus state=" + this.latchXplus.getLockStatus();
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, msg);
            throw new FcsHardwareException(this.name + " LockStatus is different on both side. Can't close neither open latches.");
        }
        if (this.latchXminus.isEmpty() != this.latchXplus.isEmpty()) {
            String msg = this.name + " Error in filterPresenceSensors of autochanger : the 2 sensors send different values. latchXminus.isEmpty=" + this.latchXminus.isEmpty() + " latchXplus.isEmpty=" + this.latchXplus.isEmpty();
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, msg);
            throw new FcsHardwareException(msg + "Can't close neither open latches.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState() {
        AutochangerTwoLatches autochangerTwoLatches = this;
        synchronized (autochangerTwoLatches) {
            this.latchXminus.updateState();
            this.latchXplus.updateState();
            this.computeLockStatus();
            this.computeFilterPresenceStatus();
        }
        this.publishData();
    }

    private void computeLockStatus() {
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isClosed() ? FcsEnumerations.LockStatus.CLOSED : (this.isOpened() ? FcsEnumerations.LockStatus.OPENED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
    }

    private void computeFilterPresenceStatus() {
        this.filterPresenceStatus = this.latchXminus.isEmpty() != this.latchXplus.isEmpty() ? FcsEnumerations.FilterPresenceStatus.ERROR : (this.isEmpty() ? FcsEnumerations.FilterPresenceStatus.NOFILTER : (this.isFilterEngaged() ? FcsEnumerations.FilterPresenceStatus.ENGAGED : FcsEnumerations.FilterPresenceStatus.UNKNOWN));
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    public void close() {
        FCSLOG.info((Object)(this.name + " about to close., timeout is " + this.timeoutForClosing));
        this.autochanger.updateStateWithSensors();
        if (this.lockStatus == FcsEnumerations.LockStatus.CLOSED) {
            throw new RejectedCommandException(this.name + " are already CLOSED.");
        }
        this.autochanger.checkConditionsForClosingLatches();
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSELATCHES, this.timeoutForClosing);
    }

    public void open() {
        if (this.latchXminus.isOpened() && this.latchXplus.isOpened()) {
            throw new RejectedCommandException(this.name + " are already OPENED.");
        }
        this.autochanger.checkConditionsForOpeningLatches();
        this.executeAction(FcsEnumerations.MobileItemAction.OPENLATCHES, this.timeoutForOpening);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.autochanger.checkLatchMotionAllowed();
        switch (action) {
            case OPENLATCHES: {
                this.latchXminus.getController().enable();
                this.latchXplus.getController().enable();
                this.latchXminus.getController().writeCurrent((short)(-this.latchXminus.getCurrentToClose()));
                this.latchXplus.getController().writeCurrent((short)(-this.latchXplus.getCurrentToClose()));
                break;
            }
            case CLOSELATCHES: {
                this.latchXminus.getController().enable();
                this.latchXplus.getController().enable();
                this.latchXminus.getController().writeCurrent((short)this.latchXminus.getCurrentToClose());
                this.latchXplus.getController().writeCurrent((short)this.latchXplus.getCurrentToClose());
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.latchXminus.getController().stopAction();
        this.latchXplus.getController().stopAction();
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " is ENDING action " + action.toString()));
        this.latchXminus.getController().stopAction();
        this.latchXplus.getController().stopAction();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPENLATCHES: {
                return this.latchXminus.isOpened() && this.latchXplus.isOpened();
            }
            case CLOSELATCHES: {
                return this.latchXminus.isClosed() && this.latchXplus.isClosed();
            }
        }
        assert (false) : action;
        return false;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize AC latches hardware after initialization. To be executed if during boot process some hardware is missing.")
    public void initializeHardware() {
        this.latchXminus.postStart();
        this.latchXplus.postStart();
    }

    public StatusDataPublishedByAutochangerTwoLatches createStatusDataPublishedByTwoLatches() {
        StatusDataPublishedByAutochangerTwoLatches status = new StatusDataPublishedByAutochangerTwoLatches();
        status.setLockStatus(this.lockStatus);
        status.setFilterPresenceStatus(this.filterPresenceStatus);
        status.setFilterName(this.autochanger.getFilterOnTrucksName());
        return status;
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByTwoLatches()));
    }
}

