/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.StrainGauge;
import org.lsst.ccs.subsystems.fcs.drivers.MonitorDeviceInterface;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerThreeOnlineClamps
extends MobileItem
implements ControlledBySensors {
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*onlineStrainGauge")
    private StrainGauge onlineStrainGauge;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*tempSensorsDevice1")
    private MonitorDeviceInterface tempSensorsDevice1;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*tempSensorsDevice2")
    private MonitorDeviceInterface tempSensorsDevice2;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="lpmOnlineClampsStatus")
    private DigitalSensor lpmOnlineClampsStatus;
    protected final AutochangerOnlineClamp onlineClampXminus;
    protected final AutochangerOnlineClamp onlineClampXplus;
    protected final AutochangerOnlineClamp onlineClampYminus;
    protected final AutochangerOnlineClamp[] clampsList;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    protected ScheduledFuture<?> currentRampHandle;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the clamps last more than this amount of time, then the subsystem goes in ERROR.")
    protected int timeoutForLockingClamps = 15000;
    @ConfigurationParameter(description="timeout in milliseconds : if unlocking the clamps last more than this amount of time, then the subsystem goes in ERROR.")
    protected int timeoutForUnlockingClamps = 20000;
    @ConfigurationParameter(description="maximum time in milliseconds to lock the 3 clamps")
    protected int maxTimeToLockAllClamps = 3000;
    @ConfigurationParameter(description="maximum time in milliseconds to unlock the 3 clamps")
    protected int maxTimeToUnlockAllClamps = 3000;
    @ConfigurationParameter(description="maximum time in milliseconds to open the 3 clamps")
    protected int maxTimeToOpenClampsX = 2000;
    @ConfigurationParameter(description="maximum time in milliseconds to close the 3 clamps")
    protected int maxTimeToCloseClampsX = 2000;
    @ConfigurationParameter(description="minimal period for current ramps. should be > 50")
    protected int minPeriod = 200;
    @ConfigurationParameter
    private short maxLockedStrain = (short)1484;
    @ConfigurationParameter
    private short minLockedStrain = (short)500;
    @ConfigurationParameter
    private short maxClosedStrain = (short)1572;
    @ConfigurationParameter
    private double strainGain = 2.978;
    private short readStrain = 0;
    private short normalizedStrain = 0;
    private boolean lockStatusInitialized = false;

    public AutochangerThreeOnlineClamps(AutochangerOnlineClamp onlineClampXminus, AutochangerOnlineClamp onlineClampXplus, AutochangerOnlineClamp onlineClampYminus) {
        this.onlineClampXminus = onlineClampXminus;
        this.onlineClampXplus = onlineClampXplus;
        this.onlineClampYminus = onlineClampYminus;
        this.clampsList = new AutochangerOnlineClamp[]{onlineClampYminus, onlineClampXminus, onlineClampXplus};
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutochangerThreeClamps.class, this.name);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if lockStatus has been first initialized from strain.")
    public boolean isLockStatusInitialized() {
        return this.lockStatusInitialized;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if homing has been done for the 3 ONLINE clamp controllers.")
    public boolean isHomingDone() {
        return this.onlineClampXminus.isHomingDone() && this.onlineClampXplus.isHomingDone() && this.onlineClampYminus.isHomingDone();
    }

    @ConfigurationParameterChanger
    public void setMinPeriod(int minPeriod) {
        if (minPeriod < 50) {
            throw new IllegalArgumentException(minPeriod + " bad value for minPeriod. should be > 50");
        }
        this.minPeriod = minPeriod;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if the 3 clamps are LOCKED.")
    public boolean isLocked() {
        return this.onlineClampXminus.isLocked() && this.onlineClampXplus.isLocked() && this.onlineClampYminus.isLocked();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if the 3 clamps are CLOSED.")
    public boolean isClosed() {
        return this.onlineClampXminus.isClosed() && this.onlineClampXplus.isClosed() && this.onlineClampYminus.isClosed();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if the 3 clamps are OPENED.")
    public boolean isOpened() {
        return this.onlineClampXminus.isOpened() && this.onlineClampXplus.isOpened() && this.onlineClampYminus.isOpened();
    }

    private boolean isInTravel() {
        return this.onlineClampXminus.isInTravel() && this.onlineClampXplus.isInTravel() && this.onlineClampYminus.isInTravel();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if one of the clamp is in error.")
    public boolean isInError() {
        return this.onlineClampXminus.isInError() || this.onlineClampXplus.isInError() || this.onlineClampYminus.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready : controllers ready, controllers parameters checked and controllers configured.")
    public boolean isInitialized() {
        return this.onlineClampXminus.isInitialized() && this.onlineClampXplus.isInitialized() && this.onlineClampYminus.isInitialized();
    }

    protected void enableAndCheckControllersBeforeAction(FcsEnumerations.MobileItemAction action) {
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.enableAndCheckControllerBeforeAction(action);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="do homing of the 3 ONLINE clamps : open in CURRENT mode and homing of controller", timeout=6000)
    public void homing() {
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.openInCurrentModeAndHoming();
        }
    }

    public void testPeriodTask() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(this.name + "-updateStateAndCheckSensors", this::updateStateAndCheckSensors).withIsFixedRate(true).withLogLevel(Level.WARNING).withPeriod(Duration.ofMillis(5000L)));
    }

    public void closeClamps() {
        if (!this.isHomingDone()) {
            throw new RejectedCommandException(this.name + " homing not done yet. Can't close.");
        }
        this.updateStateAndCheckSensors();
        if (this.isOpened()) {
            this.autochanger.checkConditionsForActioningOnlineClamps();
            this.onlineClampYminus.close();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPSX, this.timeoutForLockingClamps);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " clamps already CLOSED nothing to do"));
        } else {
            throw new RejectedCommandException(this.name + " has to be unlocked before.");
        }
    }

    public void openClamps() {
        if (!this.isHomingDone()) {
            throw new RejectedCommandException(this.name + " homing not done yet for the 3 clamps. Can't open.");
        }
        this.updateStateAndCheckSensors();
        if (this.isClosed()) {
            this.checkReadyForAction();
            this.onlineClampYminus.open();
            this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX, this.timeoutForUnlockingClamps);
        } else if (this.isOpened()) {
            FCSLOG.info((Object)(this.name + " clamps already OPENED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be closed before.");
        }
    }

    public void lockClamps() {
        this.updateStateAndCheckSensors();
        if (this.isClosed()) {
            this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
        } else if (this.isLocked()) {
            FCSLOG.info((Object)(this.name + " is already LOCKED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " have to be CLOSED before to be locked.");
        }
    }

    public void unlockClamps() {
        this.updateStateAndCheckSensors();
        if (this.isLocked()) {
            this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " have to be CLOSED before to be locked.");
        }
    }

    public void lockFilterAtOnline() {
        if (this.isLocked()) {
            FCSLOG.info((Object)(this.name + " onlineClamps LOCKED : nothing to do"));
        } else if (this.isClosed()) {
            this.disableYminus();
            this.lockClamps();
        } else if (this.isOpened()) {
            if (!this.isHomingDone()) {
                this.homing();
            }
            this.disableYminus();
            this.closeClamps();
            this.disableYminus();
            this.lockClamps();
        }
    }

    public void disableYminus() {
        FcsUtils.sleep(50, this.name);
        this.onlineClampYminus.getController().activateBrakeAndDisable();
    }

    private void sendCurrentToCloseAllClamps() {
        FCSLOG.info((Object)(this.name + " sending current to close all clamps"));
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.sendCurrentToControllerAndSaveValue(clamp.getFinalCurrentToClose());
        }
    }

    private void sendCurrentToLockAllClamps() {
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.sendCurrentToControllerAndSaveValue(clamp.getCurrentToClamp());
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready.")
    public boolean myDevicesReady() {
        return this.onlineClampXminus.myDevicesReady() && this.onlineClampXplus.myDevicesReady() && this.onlineClampYminus.myDevicesReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            return this.isClosed();
        }
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS) {
            return this.isLocked();
        }
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX) {
            return this.onlineClampXminus.isOpened() && this.onlineClampXplus.isOpened() && this.onlineClampXminus.isAtPositionOpen() && this.onlineClampXplus.isAtPositionOpen();
        }
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPSX) {
            return this.onlineClampXminus.isClosed() && this.onlineClampXplus.isClosed() && this.onlineClampXminus.isAtPositionClose() && this.onlineClampXplus.isAtPositionClose();
        }
        throw new IllegalArgumentException(this.name + " invalid action:" + action);
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.enableAndCheckControllersBeforeAction(action);
        this.autochanger.checkConditionsForActioningOnlineClamps();
        this.autochanger.checkOnlineClampMotionAllowed();
        if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            this.doUnlock();
        } else if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS) {
            this.doLock();
        } else if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX) {
            this.onlineClampXminus.getController().enableAndReleaseBrake();
            this.onlineClampXplus.getController().enableAndReleaseBrake();
            this.onlineClampXminus.getController().writeTargetPosition(this.onlineClampXminus.getTargetPositionToOpen());
            this.onlineClampXplus.getController().writeTargetPosition(this.onlineClampXplus.getTargetPositionToOpen());
            this.onlineClampXminus.getController().writeControlWord(63);
            this.onlineClampXplus.getController().writeControlWord(63);
        } else if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPSX) {
            this.onlineClampXminus.getController().enableAndReleaseBrake();
            this.onlineClampXplus.getController().enableAndReleaseBrake();
            this.onlineClampXminus.getController().writeTargetPosition(this.onlineClampXminus.getTargetPositionToClose());
            this.onlineClampXplus.getController().writeTargetPosition(this.onlineClampXplus.getTargetPositionToClose());
            this.onlineClampXminus.getController().writeControlWord(63);
            this.onlineClampXplus.getController().writeControlWord(63);
        } else {
            throw new IllegalArgumentException(this.name + " invalid action:" + action);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX || action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPSX) {
            this.onlineClampXminus.getController().stopAction();
            this.onlineClampXplus.getController().stopAction();
            this.onlineClampXminus.getController().activateBrake();
            this.onlineClampXplus.getController().activateBrake();
        } else {
            this.activateBrakesAndDisableOperation();
        }
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " is ENDING action " + action.toString()));
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX || action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPSX) {
            this.onlineClampXminus.getController().activateBrake();
            this.onlineClampXplus.getController().activateBrake();
            FcsUtils.sleep(this.autochanger.getWaitTimeForBrakeOC(), this.name);
            this.onlineClampXminus.getController().disableOperation();
            this.onlineClampXplus.getController().disableOperation();
            this.onlineClampXminus.getController().disableVoltage();
            this.onlineClampXplus.getController().disableVoltage();
        } else {
            this.activateBrakesAndDisableOperation();
        }
        this.onlineClampXminus.getController().checkFault();
        this.onlineClampXplus.getController().checkFault();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void activateBrakesAndDisableOperation() {
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.getController().activateBrake();
            FcsUtils.sleep(this.autochanger.getWaitTimeForBrakeOC(), this.name);
            clamp.getController().disableOperation();
            clamp.getController().disableVoltage();
        }
    }

    private void doReleaseBrakes() {
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.getController().doReleaseBrake();
        }
    }

    protected void doLock() {
        this.sendCurrentToCloseAllClamps();
        FcsUtils.sleep(250, this.name);
        this.doReleaseBrakes();
        this.executeCurrentRampToLockAllClamps();
        this.updateState();
    }

    protected void doUnlock() {
        this.sendCurrentToLockAllClamps();
        FcsUtils.sleep(250, this.name);
        this.doReleaseBrakes();
        this.executeCurrentRampToUnlockAllClamps();
        this.updateState();
    }

    private short computeNormalizedStrain() {
        double temp = 20.0;
        if (!this.tempSensorsDevice1.isBooted()) {
            this.tempSensorsDevice1.updateDeviceInfo();
        }
        if (this.tempSensorsDevice1.isBooted()) {
            temp = (double)this.tempSensorsDevice1.readChannel(3) / 10.0;
        } else {
            this.raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, " can't read temperature because tempSensorsDevice1 is not booted, temperature is supposed to be 20\u00b0C", this.name);
        }
        if (!this.onlineStrainGauge.isBooted()) {
            this.onlineStrainGauge.updateDeviceInfo();
        }
        if (this.onlineStrainGauge.isBooted()) {
            this.readStrain = this.onlineStrainGauge.readStrain();
        } else {
            this.raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, " can't read strainGain because onlineStrainGauge is not booted", this.name);
        }
        this.normalizedStrain = (short)((double)this.readStrain - this.strainGain * (temp - 20.0));
        FCSLOG.info((Object)("temperature=" + temp + " / ONLINE read strain=" + this.readStrain + " / normalized strain=" + this.normalizedStrain));
        return this.normalizedStrain;
    }

    public StatusDataPublishedByAutochangerThreeClamps createStatusDataPublishedByThreeClamps() {
        StatusDataPublishedByAutochangerThreeClamps status = new StatusDataPublishedByAutochangerThreeClamps();
        status.setLockStatus(this.lockStatus);
        status.setOnlineClampStrain((int)this.normalizedStrain);
        status.setOnlineClampRawStrain(this.readStrain);
        status.setHomingDone(this.isHomingDone());
        return status;
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByThreeClamps()));
    }

    protected void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, this.name);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state from sensors values.")
    public void updateState() {
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.updateState();
        }
        this.normalizedStrain = this.computeNormalizedStrain();
        this.computeLockStatus();
        this.publishData();
    }

    private void computeLockStatus() {
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isOpened() ? FcsEnumerations.LockStatus.OPENED : (this.isClosed() ? FcsEnumerations.LockStatus.CLOSED : (this.isLocked() ? FcsEnumerations.LockStatus.LOCKED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN))));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return a lock status computed from the normalizedStrain value")
    public FcsEnumerations.LockStatus computeStrainGaugeLockStatus() {
        this.normalizedStrain = this.computeNormalizedStrain();
        FCSLOG.info((Object)(this.name + " ONLINE strain = " + this.normalizedStrain));
        if (this.normalizedStrain > this.maxClosedStrain) {
            return FcsEnumerations.LockStatus.OPENED;
        }
        if (this.normalizedStrain > this.maxLockedStrain) {
            return FcsEnumerations.LockStatus.CLOSED;
        }
        if (this.normalizedStrain > this.minLockedStrain) {
            return FcsEnumerations.LockStatus.LOCKED;
        }
        return FcsEnumerations.LockStatus.ERROR;
    }

    private void computeLockStatusFromStrain() {
        FcsEnumerations.LockStatus strainLockStatus = this.computeStrainGaugeLockStatus();
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isOpened() ? FcsEnumerations.LockStatus.OPENED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : (this.isClosed() ? (strainLockStatus == FcsEnumerations.LockStatus.LOCKED ? FcsEnumerations.LockStatus.LOCKED : (strainLockStatus == FcsEnumerations.LockStatus.CLOSED ? FcsEnumerations.LockStatus.CLOSED : (strainLockStatus == FcsEnumerations.LockStatus.OPENED || strainLockStatus == FcsEnumerations.LockStatus.ERROR ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.ERROR))) : FcsEnumerations.LockStatus.UNKNOWN)));
    }

    private void executeCurrentRampToLockAllClamps() {
        FCSLOG.info((Object)(this.name + " executing current ramp to lock all clamps."));
        this.writeCurrentRampToLockAllClamps();
        this.waitForEndOfCurrentRamp(this.timeoutForLockingClamps);
    }

    protected void executeCurrentRampToUnlockAllClamps() {
        this.writeCurrentRampToUnlockAllClamps();
        this.waitForEndOfCurrentRamp(this.timeoutForUnlockingClamps);
    }

    protected void cancelCurrentRamp() {
        FCSLOG.finest((Object)" => stop writing current");
        this.currentRampHandle.cancel(true);
        FCSLOG.finest((Object)" => current ramp ended");
    }

    protected void waitForEndOfCurrentRamp(int timeout) {
        FCSLOG.info((Object)(this.name + " BEGIN WAITING FOR END OF CURRENT RAMP"));
        try {
            this.currentRampHandle.get(timeout, TimeUnit.SECONDS);
        }
        catch (CancellationException ex) {
            if (this.currentRampHandle.isDone()) {
                FCSLOG.info((Object)(this.name + " CURRENT RAMP ENDED"));
            } else {
                FCSLOG.error((Object)(this.name + " during action " + this.currentAction + " waiting was cancelled before END of CURRENT RAMP " + ex));
            }
        }
        catch (TimeoutException ex) {
            FCSLOG.error((Object)(this.name + " CURRENT RAMP IS DURING TOO LONG - timeout=" + timeout), (Throwable)ex);
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)(this.name + " interrupted while waiting end of current ramp during action=" + this.currentAction), (Throwable)ex);
            throw new FcsHardwareException(this.name + " interrupted while waiting end of current ramp during action=" + this.currentAction, (Throwable)ex);
        }
        catch (ExecutionException ex) {
            FCSLOG.error((Object)(this.name + " error during action=" + this.currentAction), (Throwable)ex);
            throw new FcsHardwareException(this.name + " error during action=" + this.currentAction + " cause=" + ex);
        }
        finally {
            this.cancelCurrentRamp();
            FCSLOG.info((Object)(this.name + " STOP WAITING FOR END OF CURRENT RAMP"));
        }
    }

    private void writeCurrentRampToLockAllClamps() {
        this.writeCurrentRampToAllClamps(this.onlineClampYminus.getFinalCurrentToClose(), this.onlineClampYminus.getCurrentToClamp(), this.onlineClampYminus.getIncrementCurrentToClamp(), this.onlineClampXminus.getFinalCurrentToClose(), this.onlineClampXminus.getCurrentToClamp(), this.onlineClampXminus.getIncrementCurrentToClamp(), this.onlineClampXplus.getFinalCurrentToClose(), this.onlineClampXplus.getCurrentToClamp(), this.onlineClampXplus.getIncrementCurrentToClamp(), this.maxTimeToLockAllClamps);
    }

    private void writeCurrentRampToUnlockAllClamps() {
        this.writeCurrentRampToAllClamps(this.onlineClampYminus.getCurrentToClamp(), this.onlineClampYminus.getFinalCurrentToClose(), this.onlineClampYminus.getIncrementCurrentToClamp(), this.onlineClampXminus.getCurrentToClamp(), this.onlineClampXminus.getFinalCurrentToClose(), this.onlineClampXminus.getIncrementCurrentToClamp(), this.onlineClampXplus.getCurrentToClamp(), this.onlineClampXplus.getFinalCurrentToClose(), this.onlineClampXplus.getIncrementCurrentToClamp(), this.maxTimeToUnlockAllClamps);
    }

    public void checkParametersToOpenClampsX() {
        int nbStepXplus;
        int initialValueXminus = this.onlineClampXminus.getFinalCurrentToClose();
        int finalValueXminus = this.onlineClampXminus.getCurrentToOpen();
        int incrementCurrentXminus = this.onlineClampXminus.getIncrementCurrentToOpen();
        int initialValueXplus = this.onlineClampXplus.getFinalCurrentToClose();
        int finalValueXplus = this.onlineClampXplus.getCurrentToOpen();
        int incrementCurrentXplus = this.onlineClampXplus.getIncrementCurrentToOpen();
        int nbStepXminus = Math.abs((finalValueXminus - initialValueXminus) / incrementCurrentXminus);
        int period = this.maxTimeToOpenClampsX / Math.min(nbStepXminus, nbStepXplus = Math.abs((finalValueXplus - initialValueXplus) / incrementCurrentXplus));
        if (period < this.minPeriod) {
            int newMaxTime = this.minPeriod * Math.min(nbStepXminus, nbStepXplus);
            throw new IllegalArgumentException(this.maxTimeToOpenClampsX + " : value too low for maxTimeToOpenClampsX. should be >= " + newMaxTime);
        }
        if (nbStepXminus != nbStepXplus) {
            FCSLOG.finest((Object)(this.name + ": nbstep to open are not equal for the 2 clamps X"));
        }
    }

    public void checkParametersToCloseClampsX() {
        int nbStepXplus;
        int initialValueXminus = this.onlineClampXminus.getInitialCurrentToClose();
        int finalValueXminus = this.onlineClampXminus.getFinalCurrentToClose();
        int incrementCurrentXminus = this.onlineClampXminus.getIncrementCurrentToClose();
        int initialValueXplus = this.onlineClampXplus.getInitialCurrentToClose();
        int finalValueXplus = this.onlineClampXplus.getFinalCurrentToClose();
        int incrementCurrentXplus = this.onlineClampXplus.getIncrementCurrentToClose();
        int nbStepXminus = Math.abs((finalValueXminus - initialValueXminus) / incrementCurrentXminus);
        int period = this.maxTimeToCloseClampsX / Math.min(nbStepXminus, nbStepXplus = Math.abs((finalValueXplus - initialValueXplus) / incrementCurrentXplus));
        if (period < this.minPeriod) {
            int newMaxTime = this.minPeriod * Math.min(nbStepXminus, nbStepXplus);
            throw new IllegalArgumentException(this.maxTimeToCloseClampsX + " : value too low. should be > " + newMaxTime);
        }
        if (nbStepXminus != nbStepXplus) {
            FCSLOG.finest((Object)(this.name + ": nbstep to open are not equal for the 2 clamps X"));
        }
    }

    private void writeCurrentRampToAllClamps(final int initialValueYminus, final int finalValueYminus, int incrementYminus, final int initialValueXminus, final int finalValueXminus, int incrementXminus, final int initialValueXplus, final int finalValueXplus, int incrementXplus, int maxTime) {
        final int stepHeightYminus = FcsUtils.getSignedStepHeight(initialValueYminus, finalValueYminus, incrementYminus);
        final int stepHeightXminus = FcsUtils.getSignedStepHeight(initialValueXminus, finalValueXminus, incrementXminus);
        final int stepHeightXplus = FcsUtils.getSignedStepHeight(initialValueXplus, finalValueXplus, incrementXplus);
        int nbStepYminus = Math.abs((finalValueYminus - initialValueYminus) / stepHeightYminus);
        int nbStepXminus = Math.abs((finalValueXminus - initialValueXminus) / stepHeightXminus);
        int nbStepXplus = Math.abs((finalValueXplus - initialValueXplus) / stepHeightXplus);
        int period = maxTime / nbStepYminus;
        if (period < 200) {
            throw new IllegalArgumentException(period + " : bad value for period");
        }
        FCSLOG.finest((Object)"############################################################");
        FCSLOG.finest((Object)("initialValue for clampYminus=" + initialValueYminus));
        FCSLOG.finest((Object)("finalValue for clampYminus=" + finalValueYminus));
        FCSLOG.finest((Object)("initialValue for clampXminus=" + initialValueXminus));
        FCSLOG.finest((Object)("finalValue for clampXminus=" + finalValueXminus));
        FCSLOG.finest((Object)("initialValue for clampXplus=" + initialValueXplus));
        FCSLOG.finest((Object)("finalValue for clampXplus=" + finalValueXplus));
        FCSLOG.finest((Object)("nbStepYminus=" + nbStepYminus + " nbStepXminus=" + nbStepXminus + " nbStepXplus=" + nbStepXplus));
        FCSLOG.finest((Object)("period=" + period));
        FCSLOG.finest((Object)("stepHeightYminus=" + stepHeightYminus));
        FCSLOG.finest((Object)("stepHeightXminus=" + stepHeightXminus));
        FCSLOG.finest((Object)("stepHeightXplus=" + stepHeightXplus));
        FCSLOG.finest((Object)"############################################################");
        Runnable currentRamp = new Runnable(){
            private int newCurrentValueYminus;
            private int newCurrentValueXminus;
            private int newCurrentValueXplus;
            boolean finalValueReachedYminus;
            boolean finalValueReachedXminus;
            boolean finalValueReachedXplus;
            {
                this.newCurrentValueYminus = initialValueYminus;
                this.newCurrentValueXminus = initialValueXminus;
                this.newCurrentValueXplus = initialValueXplus;
                this.finalValueReachedYminus = false;
                this.finalValueReachedXminus = false;
                this.finalValueReachedXplus = false;
            }

            @Override
            public void run() {
                this.newCurrentValueYminus = FcsUtils.computeNewCurrentValue(stepHeightYminus, this.newCurrentValueYminus, finalValueYminus);
                this.newCurrentValueXminus = FcsUtils.computeNewCurrentValue(stepHeightXminus, this.newCurrentValueXminus, finalValueXminus);
                this.newCurrentValueXplus = FcsUtils.computeNewCurrentValue(stepHeightXplus, this.newCurrentValueXplus, finalValueXplus);
                try {
                    if (!this.finalValueReachedYminus) {
                        AutochangerThreeOnlineClamps.this.onlineClampYminus.sendCurrentToControllerAndSaveValue(this.newCurrentValueYminus);
                    }
                    if (!this.finalValueReachedXminus) {
                        AutochangerThreeOnlineClamps.this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXminus);
                    }
                    if (!this.finalValueReachedXplus) {
                        AutochangerThreeOnlineClamps.this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXplus);
                    }
                    this.finalValueReachedYminus = this.newCurrentValueYminus == finalValueYminus;
                }
                catch (Throwable throwable) {
                    this.finalValueReachedYminus = this.newCurrentValueYminus == finalValueYminus;
                    this.finalValueReachedXminus = this.newCurrentValueXminus == finalValueXminus;
                    this.finalValueReachedXplus = this.newCurrentValueXplus == finalValueXplus;
                    throw throwable;
                }
                this.finalValueReachedXminus = this.newCurrentValueXminus == finalValueXminus;
                this.finalValueReachedXplus = this.newCurrentValueXplus == finalValueXplus;
                if (this.finalValueReachedYminus && this.finalValueReachedXminus && this.finalValueReachedXplus) {
                    AutochangerThreeOnlineClamps.this.cancelCurrentRamp();
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 0L, period, TimeUnit.MILLISECONDS);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize AC online clamps hardware after initialization. To be executed if during boot process some hardware is missing.")
    public void initializeHardware() {
        this.postStart();
        for (AutochangerOnlineClamp clamp : this.clampsList) {
            clamp.postStart();
        }
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.onlineStrainGauge.isBooted()) {
            this.onlineStrainGauge.initializeAndCheckHardware();
        } else {
            this.onlineStrainGauge.raiseAlarmIfMissing();
        }
        if (this.tempSensorsDevice1.isBooted()) {
            this.computeLockStatusFromStrain();
            this.lockStatusInitialized = true;
            this.publishData();
        } else {
            this.tempSensorsDevice1.raiseWarningIfMissing();
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }
}

