package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;

/**
 * This is a model for an optical filter for the camera.
 *
 */
public class Filter {

    @LookupName
    private String name;

    @ConfigurationParameter(isFinal = true, description = "weight of this filter", range = "0..100")
    private double weight;

    @ConfigurationParameter(isFinal = true, description = "FilterID which is coded on filter frame with 6 hall effect sensors.", range = "1..63")
    private int filterID;

    /**
     * Build a filter with an ID and a weight and a socketName.
     *
     * @param filterID
     * @param weight
     */
    public Filter(int filterID, double weight) {
        this.filterID = filterID;
        this.weight = weight;
    }

    public Filter(int filterID, double weight, String name) {
        this.filterID = filterID;
        this.weight = weight;
        this.name = name;
    }

    /**
     * Returns filterID as Integer
     *
     * @return
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL, description = "Returns filter id.")
    public int getFilterID() {
        return filterID;
    }

    public String getName() {
        return name;
    }

    /**
     * return filter weight
     *
     * @return
     */
    public double getWeight() {
        return weight;
    }

}
