/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.ForceSensor;
import org.lsst.ccs.subsystems.fcs.LoaderCarrier;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.RedondantSensors;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderCarrierController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuLoaderPlutoGateway
extends SimuPlutoGateway {
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*carrier")
    private LoaderCarrier carrier;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*clamp")
    private LoaderClamp clamp;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*carrierController")
    private SimuLoaderCarrierController carrierController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*hooksController")
    private SimuLoaderClampController hooksController;
    private DigitalSensor closeSensor1;
    private DigitalSensor openSensor1;
    private DigitalSensor closeSensor2;
    private DigitalSensor openSensor2;
    private DigitalSensor closeSensor3;
    private DigitalSensor openSensor3;
    private DigitalSensor closeSensor4;
    private DigitalSensor openSensor4;
    private DigitalSensor unclampedStatusSensor;
    private DigitalSensor underClampedStatusSensor;
    private DigitalSensor clampedStatusSensor;
    private DigitalSensor overClampedStatusSensor;
    private ForceSensor forceSensor0;
    private ForceSensor forceSensor1;
    private RedondantSensors filterPresenceSensors;
    private RedondantSensors loaderOnCameraSensors;
    private BinarySensor storagePositionSensors;
    private BinarySensor handoffPositionSensors;
    private BinarySensor engagedPositionSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="Loader_LRH")
    private ComplementarySensors loader_LRH;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="Loader_LPS")
    private ComplementarySensors loader_LPS;

    public SimuLoaderPlutoGateway(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void init() {
        super.init();
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.closeSensor1 = (DigitalSensor)lookup.getComponentByPath("loaderCloseSensor1");
        this.closeSensor2 = (DigitalSensor)lookup.getComponentByPath("loaderCloseSensor2");
        this.closeSensor3 = (DigitalSensor)lookup.getComponentByPath("loaderCloseSensor3");
        this.closeSensor4 = (DigitalSensor)lookup.getComponentByPath("loaderCloseSensor4");
        this.openSensor1 = (DigitalSensor)lookup.getComponentByPath("loaderOpenSensor1");
        this.openSensor2 = (DigitalSensor)lookup.getComponentByPath("loaderOpenSensor2");
        this.openSensor3 = (DigitalSensor)lookup.getComponentByPath("loaderOpenSensor3");
        this.openSensor4 = (DigitalSensor)lookup.getComponentByPath("loaderOpenSensor4");
        this.clampedStatusSensor = (DigitalSensor)lookup.getComponentByPath("clampedStatusSensor");
        this.unclampedStatusSensor = (DigitalSensor)lookup.getComponentByPath("unclampedStatusSensor");
        this.underClampedStatusSensor = (DigitalSensor)lookup.getComponentByPath("underClampedStatusSensor");
        this.overClampedStatusSensor = (DigitalSensor)lookup.getComponentByPath("overClampedStatusSensor");
        this.forceSensor0 = (ForceSensor)lookup.getComponentByPath("forceSensor0");
        this.forceSensor1 = (ForceSensor)lookup.getComponentByPath("forceSensor1");
        this.loaderOnCameraSensors = (RedondantSensors)lookup.getComponentByPath("loaderOnCameraSensors");
        this.filterPresenceSensors = (RedondantSensors)lookup.getComponentByPath("loaderFilterPresenceSensors");
        this.storagePositionSensors = (RedondantSensors)lookup.getComponentByPath("loaderStorageSensors");
        this.handoffPositionSensors = (BinarySensor)lookup.getComponentByPath("loaderHandoffSensors");
        this.engagedPositionSensors = (BinarySensor)lookup.getComponentByPath("loaderEngagedSensors");
        this.loader_LRH = (ComplementarySensors)lookup.getComponentByPath("Loader_LRH");
        this.loader_LPS = (ComplementarySensors)lookup.getComponentByPath("Loader_LPS");
        this.simulateLoaderClampIsClosed();
        this.simulateLoaderIsConnectedOnCamera();
        this.simulateClampedStatusSensorIsOn();
        this.simulateFilterIsOnLoader();
        this.simulateLoaderCarrierIsAtStorage();
    }

    protected void simuBinarySensorOn(BinarySensor sensor) {
        if (sensor instanceof RedondantSensors) {
            this.replaceSensorValue(((RedondantSensors)sensor).getSensor(), true);
            this.replaceSensorValue(((RedondantSensors)sensor).getSensorR(), true);
        } else if (sensor instanceof ComplementarySensors) {
            this.replaceSensorValue(((ComplementarySensors)sensor).getSensor(), true);
            this.replaceSensorValue(((ComplementarySensors)sensor).getSensorC(), false);
        } else {
            this.replaceSensorValue((DigitalSensor)sensor, true);
        }
    }

    protected void simuBinarySensorOff(BinarySensor sensor) {
        if (sensor instanceof RedondantSensors) {
            this.replaceSensorValue(((RedondantSensors)sensor).getSensor(), false);
            this.replaceSensorValue(((RedondantSensors)sensor).getSensorR(), false);
        } else if (sensor instanceof ComplementarySensors) {
            this.replaceSensorValue(((ComplementarySensors)sensor).getSensor(), false);
            this.replaceSensorValue(((ComplementarySensors)sensor).getSensorC(), true);
        } else {
            this.replaceSensorValue((DigitalSensor)sensor, false);
        }
    }

    protected void simuRedondantSensorsInError(RedondantSensors sensors) {
        this.replaceSensorValue(sensors.getSensor(), true);
        this.replaceSensorValue(sensors.getSensorR(), false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsClosed() {
        this.simulateHooksAreClosed();
        this.simulateUnclampedStatusSensorIsOn();
        this.hooksController.setPosition(this.clamp.getRelativePositionToClose());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsClamped() {
        this.simulateHooksAreClosed();
        this.simulateClampedStatusSensorIsOn();
        this.hooksController.setPosition(this.clamp.getTargetPositionToClamp());
    }

    private void simulateHooksAreClosed() {
        this.simulateHookIsClosed(this.closeSensor1, this.openSensor1);
        this.simulateHookIsClosed(this.closeSensor2, this.openSensor2);
        this.simulateHookIsClosed(this.closeSensor3, this.openSensor3);
        this.simulateHookIsClosed(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsOpened() {
        this.simulateHookIsOpened(this.closeSensor1, this.openSensor1);
        this.simulateHookIsOpened(this.closeSensor2, this.openSensor2);
        this.simulateHookIsOpened(this.closeSensor3, this.openSensor3);
        this.simulateHookIsOpened(this.closeSensor4, this.openSensor4);
        this.simulateUnclampedStatusSensorIsOn();
        this.hooksController.setPosition(this.clamp.getTargetPositionToOpen());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsInTravel() {
        this.simulateHookIsInTravel(this.closeSensor1, this.openSensor1);
        this.simulateHookIsInTravel(this.closeSensor2, this.openSensor2);
        this.simulateHookIsInTravel(this.closeSensor3, this.openSensor3);
        this.simulateHookIsInTravel(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampIsUnknown() {
        this.simulateHookIsOpened(this.closeSensor1, this.openSensor1);
        this.simulateHookIsOpened(this.closeSensor2, this.openSensor2);
        this.simulateHookIsOpened(this.closeSensor3, this.openSensor3);
        this.simulateHookIsClosed(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampIsInError() {
        this.simulateHookIsInError(this.closeSensor1, this.openSensor1);
        this.simulateHookIsOpened(this.closeSensor2, this.openSensor2);
        this.simulateHookIsOpened(this.closeSensor3, this.openSensor3);
        this.simulateHookIsClosed(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsClosed(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceSensorValue(closeSensor, true);
        this.replaceSensorValue(openSensor, false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsOpened(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceSensorValue(closeSensor, false);
        this.replaceSensorValue(openSensor, true);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsInError(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceSensorValue(closeSensor, true);
        this.replaceSensorValue(openSensor, true);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsInTravel(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceSensorValue(closeSensor, false);
        this.replaceSensorValue(openSensor, false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnectedOnCamera() {
        this.simuBinarySensorOn(this.loaderOnCameraSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsNotConnectedOnCamera() {
        this.simuBinarySensorOff(this.loaderOnCameraSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsOnLoader() {
        this.simuBinarySensorOn(this.filterPresenceSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsNotOnLoader() {
        this.simuBinarySensorOff(this.filterPresenceSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsAtStorage() {
        this.simuBinarySensorOn(this.storagePositionSensors);
        this.simuBinarySensorOff(this.handoffPositionSensors);
        this.simuBinarySensorOff(this.engagedPositionSensors);
        this.simuBinarySensorOn(this.loader_LPS);
        this.simuBinarySensorOff(this.loader_LRH);
        this.carrierController.setPosition(this.carrier.getStoragePosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsAtHandoff() {
        this.simuBinarySensorOff(this.storagePositionSensors);
        this.simuBinarySensorOn(this.handoffPositionSensors);
        this.simuBinarySensorOn(this.engagedPositionSensors);
        this.simuBinarySensorOff(this.loader_LPS);
        this.carrierController.setPosition(this.carrier.getHandoffPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsAtEngaged() {
        this.simuBinarySensorOff(this.storagePositionSensors);
        this.simuBinarySensorOff(this.handoffPositionSensors);
        this.simuBinarySensorOn(this.engagedPositionSensors);
        this.carrierController.setPosition(this.carrier.getEngagedPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsInTravel() {
        this.simuBinarySensorOff(this.storagePositionSensors);
        this.simuBinarySensorOff(this.handoffPositionSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHandoffSensorsAreInError() {
        this.simuRedondantSensorsInError((RedondantSensors)this.handoffPositionSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateStorageSensorsAreInError() {
        this.simuRedondantSensorsInError((RedondantSensors)this.storagePositionSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampedStatusSensorIsOn() {
        this.replaceSensorValue(this.clampedStatusSensor, true);
        this.replaceSensorValue(this.unclampedStatusSensor, false);
        this.replaceSensorValue(this.underClampedStatusSensor, false);
        this.replaceSensorValue(this.overClampedStatusSensor, false);
        this.simulateForceSensorsOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateUnclampedStatusSensorIsOn() {
        this.replaceSensorValue(this.unclampedStatusSensor, true);
        this.replaceSensorValue(this.clampedStatusSensor, false);
        this.replaceSensorValue(this.underClampedStatusSensor, false);
        this.replaceSensorValue(this.overClampedStatusSensor, false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateForceSensorsOn() {
        this.simulateForceSensorClamped(this.forceSensor0);
        this.simulateForceSensorClamped(this.forceSensor1);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateForceSensorsOff() {
        this.simulateForceSensorUnclamped(this.forceSensor0);
        this.simulateForceSensorUnclamped(this.forceSensor1);
    }

    public void simulateForceSensorClamped(ForceSensor forceSensor) {
        this.updateForceSensor(forceSensor, 30);
    }

    public void simulateForceSensorUnclamped(ForceSensor forceSensor) {
        this.updateForceSensor(forceSensor, 10);
    }

    private void updateForceSensor(ForceSensor forceSensor, int voltage) {
        this.readValues[forceSensor.getByteNumero()] = voltage;
    }
}

