/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;
import org.lsst.ccs.subsystems.fcs.utils.TTC580Utils;

public class SimuTTC580Toto {
    private static Subsystem ttc580Subsystem;
    private static SimuTTC580 ttc580;
    private static SimuCanOpenInterface canInterface;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF SimuTTC580                 ");
        System.out.println("***************************************");
        ttc580Subsystem = BootUtils.getSubsystemFromFile((String)"testSimuTTC580");
        ttc580Subsystem.startAgent();
        ComponentLookup lookup = ttc580Subsystem.getComponentLookup();
        ttc580 = (SimuTTC580)lookup.getComponentByPath("hyttc580");
        canInterface = (SimuCanOpenInterface)lookup.getComponentByPath("canInterface");
    }

    @AfterClass
    public static void after() throws Exception {
        ttc580Subsystem.shutdownAgent();
    }

    @Before
    public void setUp() throws DriverException {
        ttc580.initializeAndCheckHardware();
        canInterface.sync();
        ttc580.setPdo1(0L);
        ttc580.setPdo2(0L);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testUpdateFakePDOData() {
        System.out.println("updateFakePDOData");
        long value = 0L;
        ttc580.updateFakePDOData(ttc580.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)ttc580.getPdo1());
        ttc580.updateFakePDOData(ttc580.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)ttc580.getPdo2());
        value = 1L;
        ttc580.updateFakePDOData(ttc580.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)ttc580.getPdo1());
        ttc580.updateFakePDOData(ttc580.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)ttc580.getPdo2());
        value = 65535L;
        ttc580.updateFakePDOData(ttc580.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)ttc580.getPdo1());
        ttc580.updateFakePDOData(ttc580.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)ttc580.getPdo2());
        value = -2234066821449711617L;
        ttc580.updateFakePDOData(ttc580.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)ttc580.getPdo1());
        ttc580.updateFakePDOData(ttc580.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)ttc580.getPdo2());
        value = -2305671193734396952L;
        ttc580.updateFakePDOData(ttc580.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)ttc580.getPdo2());
    }

    @Test
    public void testSimulateSocketAtStandby() {
        System.out.println("simulateSocketAtStandby");
        short id = 2;
        System.out.println("socketID=" + id);
        ttc580.simulateSocketAtStandby(id);
        short socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        ttc580.setPdo1(65535L);
        id = 5;
        System.out.println("socketID=" + id);
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        ttc580.setPdo1(1024L);
        id = 5;
        System.out.println("socketID=" + id);
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        long value = -2305671193734396952L;
        id = 1;
        ttc580.setPdo1(value);
        System.out.println("socketID=" + id);
        System.out.println("pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        id = 2;
        ttc580.setPdo1(value);
        System.out.println("socketID=" + id);
        System.out.println("pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        id = 3;
        ttc580.setPdo1(value);
        System.out.println("socketID=" + id);
        System.out.println("pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        id = 4;
        ttc580.setPdo1(value);
        System.out.println("socketID=" + id);
        System.out.println("pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        id = 5;
        ttc580.setPdo1(value);
        System.out.println("socketID=" + id);
        System.out.println("pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        id = 1;
        value = -6629247107684441862L;
        System.out.println("socketID=" + id);
        System.out.println("pdo1=" + Long.toBinaryString(value));
        ttc580.simulateSocketAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo1());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
    }

    @Test
    public void testSimulateSocketNotAtStandby() {
        System.out.println("simulateSocketNotAtStandby");
        System.out.println("simulateSocketNotAtStandby");
        short id = 1;
        System.out.println("socketID=" + id);
        ttc580.simulateSocketNotAtStandby(id);
        short socketID = ttc580.getSocketId(ttc580.getPdo2());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        System.out.println("simulateSocketNotAtStandby");
        id = 3;
        System.out.println("socketID=" + id);
        ttc580.simulateSocketNotAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo2());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        long value = -2305671193734396952L;
        ttc580.setPdo2(value);
        System.out.println("simulateSocketNotAtStandby");
        id = 4;
        System.out.println("socketID=" + id);
        System.out.println("pdo2=" + Long.toBinaryString(value));
        ttc580.simulateSocketNotAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo2());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
        ttc580.setPdo2(value);
        System.out.println("simulateSocketNotAtStandby");
        id = 5;
        System.out.println("socketID=" + id);
        System.out.println("pdo2=" + Long.toBinaryString(value));
        ttc580.simulateSocketNotAtStandby(id);
        socketID = ttc580.getSocketId(ttc580.getPdo2());
        Assert.assertEquals((String)"socketID", (long)id, (long)socketID);
    }

    @Test
    public void testSimulateLockSensorXminusValue() {
        System.out.println("simulateLockSensorXminusValue");
        long lockValue = 0L;
        ttc580.simulateLockSensorXminusValue(lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo1()));
        lockValue = 300L;
        ttc580.simulateLockSensorXminusValue(lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo1()));
        lockValue = 4095L;
        ttc580.simulateLockSensorXminusValue(lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo1()));
    }

    @Test
    public void testSimulateLockSensorXminusValueNotAtS() {
        System.out.println("simulateLockSensorXminusValueNotAtS");
        long lockValue = 0L;
        ttc580.simulateLockSensorXminusValueNotAtS(lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo2()));
        lockValue = 300L;
        ttc580.simulateLockSensorXminusValueNotAtS(lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo2()));
        lockValue = 4095L;
        ttc580.simulateLockSensorXminusValueNotAtS(lockValue);
        Assert.assertEquals((String)"lockValue", (long)lockValue, (long)TTC580Utils.getLockXm((long)ttc580.getPdo2()));
    }

    @Test
    public void testSimulateFilterPresenceXminusValue() {
        System.out.println("simulateFilterPresenceXminusValue");
        long newValue = 0L;
        ttc580.simulateFilterPresenceXminusValue(newValue);
        Assert.assertEquals((String)"filterPresence", (long)newValue, (long)TTC580Utils.getFilterPresenceXm((long)ttc580.getPdo1()));
        newValue = 386L;
        ttc580.simulateFilterPresenceXminusValue(newValue);
        Assert.assertEquals((String)"filterPresence", (long)newValue, (long)TTC580Utils.getFilterPresenceXm((long)ttc580.getPdo1()));
        newValue = 4095L;
        ttc580.simulateFilterPresenceXminusValue(newValue);
        Assert.assertEquals((String)"filterPresence", (long)newValue, (long)TTC580Utils.getFilterPresenceXm((long)ttc580.getPdo1()));
    }

    @Test
    public void testSimulateLockSensorXplusValue() {
        System.out.println("simulateLockSensorXplusValue");
        long newValue = 0L;
        ttc580.simulateLockSensorXplusValue(newValue);
        Assert.assertEquals((String)"lockValueX+", (long)newValue, (long)TTC580Utils.getLockXp((long)ttc580.getPdo1()));
        newValue = 4000L;
        ttc580.simulateLockSensorXplusValue(newValue);
        Assert.assertEquals((String)"lockValueX+", (long)newValue, (long)TTC580Utils.getLockXp((long)ttc580.getPdo1()));
        newValue = 2500L;
        ttc580.simulateLockSensorXplusValue(newValue);
        Assert.assertEquals((String)"lockValueX+", (long)newValue, (long)TTC580Utils.getLockXp((long)ttc580.getPdo1()));
        newValue = 4095L;
        ttc580.simulateLockSensorXplusValue(newValue);
        Assert.assertEquals((String)"lockValueX+", (long)newValue, (long)TTC580Utils.getLockXp((long)ttc580.getPdo1()));
    }

    @Test
    public void testSimulateFilterPresenceXplusValue() {
        System.out.println("simulateFilterPresenceXplusValue");
        long newValue = 0L;
        ttc580.simulateFilterPresenceXplusValue(newValue);
        Assert.assertEquals((String)"filterPresenceX+", (long)newValue, (long)TTC580Utils.getFilterPresenceXp((long)ttc580.getPdo1()));
        newValue = 24L;
        ttc580.simulateFilterPresenceXplusValue(newValue);
        Assert.assertEquals((String)"filterPresenceX+", (long)newValue, (long)TTC580Utils.getFilterPresenceXp((long)ttc580.getPdo1()));
        newValue = 4095L;
        ttc580.simulateFilterPresenceXplusValue(newValue);
        Assert.assertEquals((String)"filterPresenceX+", (long)newValue, (long)TTC580Utils.getFilterPresenceXp((long)ttc580.getPdo1()));
    }

    @Test
    public void testSimulateSlaveModuleStatus() {
        System.out.println("simulateSimulateSlaveModuleStatus");
        short newValue = 1;
        ttc580.simulateSlaveStatus(newValue);
        Assert.assertEquals((String)"slave module status", (long)newValue, (long)TTC580Utils.getSlaveModuleStatus((long)ttc580.getPdo1()));
        newValue = 4;
        ttc580.simulateSlaveStatus(newValue);
        Assert.assertEquals((String)"slave module status", (long)newValue, (long)TTC580Utils.getSlaveModuleStatus((long)ttc580.getPdo1()));
        newValue = 7;
        ttc580.simulateSlaveStatus(newValue);
        Assert.assertEquals((String)"slave module status", (long)newValue, (long)TTC580Utils.getSlaveModuleStatus((long)ttc580.getPdo1()));
    }

    @Test
    public void testSimulateSlaveModuleStatusNotAtS() {
        System.out.println("simulateSimulateSlaveModuleStatusNotAtS");
        short newValue = 1;
        ttc580.simulateSlaveStatusNotAtS(newValue);
        Assert.assertEquals((String)"slave module status", (long)newValue, (long)TTC580Utils.getSlaveModuleStatus((long)ttc580.getPdo2()));
        newValue = 6;
        ttc580.simulateSlaveStatusNotAtS(newValue);
        Assert.assertEquals((String)"slave module status", (long)newValue, (long)TTC580Utils.getSlaveModuleStatus((long)ttc580.getPdo2()));
        newValue = 5;
        ttc580.simulateSlaveStatusNotAtS(newValue);
        Assert.assertEquals((String)"slave module status", (long)newValue, (long)TTC580Utils.getSlaveModuleStatus((long)ttc580.getPdo2()));
        newValue = 2;
        ttc580.simulateSlaveStatusNotAtS(newValue);
        Assert.assertEquals((String)"slave module status", (long)newValue, (long)TTC580Utils.getSlaveModuleStatus((long)ttc580.getPdo2()));
    }
}

