/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCanOpenDevice;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class CanOpenDevice
implements PieceOfHardware,
HasLifecycle {
    @ConfigurationParameter(isFinal=true, description="CANOpen node ID of this CANOpen device")
    protected int nodeID;
    @ConfigurationParameter(description="serial number of this CANOpen device", category="serialNB")
    protected String serialNB;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected CanOpenProxy tcpProxy;
    protected boolean initialized = false;
    protected boolean booted = false;
    protected boolean inError = false;
    protected int[] errorHistory = new int[0];
    protected int lastErrorCode;
    protected String lastErrorName;
    protected String errorRegister = "NO ERROR";
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subs;

    public CanOpenDevice(int nodeID, String serialNB) {
        this.nodeID = nodeID;
        this.serialNB = serialNB;
    }

    public CanOpenDevice() {
    }

    public void build() {
        this.dataProviderDictionaryService.registerData(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByCanOpenDevice()));
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this CANopen device's serial number.")
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this CANopen device's node ID and print it in decimal format.")
    public int getNodeID() {
        return this.nodeID;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this CANopen node is booted.")
    public boolean isBooted() {
        return this.booted;
    }

    @Override
    public void setBooted(boolean isBooted) {
        this.booted = isBooted;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this CANopen node is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public int getErrorHistoryNB() {
        return this.errorHistory.length;
    }

    public int getLastErrorCode() {
        return this.lastErrorCode;
    }

    public String getLastErrorName() {
        return this.lastErrorName;
    }

    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    public int[] getErrorHistory() {
        return (int[])this.errorHistory.clone();
    }

    public String getErrorRegister() {
        return this.errorRegister;
    }

    public boolean isInError() {
        return this.inError;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if device is booted and update device info.")
    public void updateDeviceInfo() {
        this.tcpProxy.updateDeviceInfo(this);
        this.publishData();
    }

    @Override
    public void onEmergencyMessage(EmergencyMessage emcyMsg) {
        if (this.agentStateService.isInState((Enum)PhaseState.INITIALIZING)) {
            FCSCst.FCSLOG.error((Object)(this.name + " received emergency message during INITIALIZATION : " + emcyMsg));
        } else if (0 != emcyMsg.getErrorRegisterCode()) {
            FCSCst.FCSLOG.error((Object)(this.name + " emergency message received: " + emcyMsg.toString()));
            this.inError = true;
            try {
                this.errorRegister = emcyMsg.getErrorRegisterName();
                this.updateErrorHistory();
                this.raiseAlarm(FcsEnumerations.FcsAlert.EMCY, emcyMsg.toString(), this.name);
                this.publishData();
            }
            catch (FcsHardwareException ex) {
                this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, " couldn't read EPOS error register ", this.name, (Exception)((Object)ex));
            }
        }
    }

    public void resetError() {
        this.inError = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = new int[0];
        this.lastErrorCode = 0;
        this.lastErrorName = "No Error";
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Initialize the device.")
    public void initializeAndCheckHardware() {
        if (this.isBooted()) {
            this.initialized = true;
            this.publishData();
            FCSCst.FCSLOG.info((Object)(this.name + ": is INITIALIZED."));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Write transmission type to the device.")
    protected void writeTransmissionTypeToDevice(int transmissionType) {
        if (this.isBooted()) {
            this.writeSDO(6145, 2, 1, transmissionType);
            this.writeSDO(6146, 2, 1, transmissionType);
            FCSCst.FCSLOG.info((Object)(this.name + " transmission type is now " + transmissionType));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Write on the Can Open Device with a command wsdo.")
    public void writeSDO(int index, int subindex, int size, int newValue) {
        this.tcpProxy.writeSDO(this.nodeID, index, subindex, size, newValue, 3);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Read Can Open Device with a command rsdo.")
    public long readSDO(int index, int subindex) {
        if (this.isBooted()) {
            return this.tcpProxy.readSDO(this.nodeID, index, subindex, 3);
        }
        throw new FcsHardwareException(this.name + " is not booted.");
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="return a Hexadecimal representation of serial number.")
    public String printSerialNumber() {
        return Integer.toHexString((int)this.readSDO(4120, 4));
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Reads Error Register on the controller (index 1001).")
    public int readErrorRegister() {
        return (int)this.readSDO(4097, 0);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Display Error Register on the controller (index 1001).")
    public String displayErrorRegister() {
        int error = this.readErrorRegister();
        String errorName = CanOpenErrorsTable.getErrorRegisterNameByCode(error);
        FCSCst.FCSLOG.debug((Object)("error register=" + Integer.toHexString(error) + " error name=" + errorName));
        return errorName;
    }

    public void updateErrorHistory() {
        int numberOfErrors = this.readNumberOfErrors();
        this.errorHistory = new int[numberOfErrors];
        for (int i = 0; i < numberOfErrors; ++i) {
            try {
                this.errorHistory[i] = (int)this.readSDO(4099, i + 1);
                continue;
            }
            catch (SDORequestException ex) {
                String msg = " no response to command: readErrorHistory - POWER FAILURE ? ";
                this.raiseWarning(FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, msg, this.name, (Exception)((Object)ex));
            }
        }
        if (this.errorHistory.length > 0) {
            this.lastErrorCode = this.errorHistory[0];
            this.lastErrorName = CanOpenDevice.truncate(this.displayError(this.errorHistory[0]));
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Display Error History for this device (index 1003).")
    public String displayErrorHistory() {
        this.updateErrorHistory();
        StringBuilder sb = new StringBuilder("Error history contains " + this.errorHistory.length + " errors.");
        if (this.errorHistory.length != 0) {
            sb.append("\nList of errors in history,the newest is the first, the oldest the last :\n");
            for (int ix = 0; ix < this.errorHistory.length; ++ix) {
                sb.append("Error code = 0x");
                sb.append(Integer.toHexString(this.errorHistory[ix]));
                sb.append(" / error name = ");
                sb.append(this.displayError(this.errorHistory[ix]));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String displayError(int err) {
        return CanOpenErrorsTable.getDeviceErrorNameByCode(err);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read and returns the number of errors registred in the Error History.")
    public int readNumberOfErrors() {
        return (int)this.readSDO(4099, 0);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="This method saves the parameters in the device memory.")
    public void saveParameters() {
        this.writeSDO(4112, 1, 4, 1702257011);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Configure a CANopen device as a heartbeat producer.")
    public void configAsHeartbeatProducer(int nodeID, int heartbeatTime) {
        if (heartbeatTime < 0 || heartbeatTime > 65535) {
            throw new IllegalArgumentException("heartbeat time is coded on 2 bytes can't be > 65535");
        }
        this.writeSDO(4119, 0, 2, heartbeatTime);
    }

    public void configAsHeartbeatConsumer(int nodeID, int producerNodeID, int heartbeatTime) {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and <=127");
        }
        if (producerNodeID < 0 || producerNodeID > 127) {
            throw new IllegalArgumentException("producerNodeID must be > 0 and <=127");
        }
        if (heartbeatTime < 0 || heartbeatTime > 65535) {
            throw new IllegalArgumentException("heartbeat time is coded on 2 bytes can't be > 65535");
        }
        int value = producerNodeID + heartbeatTime;
        this.writeSDO(4118, 1, 4, value);
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        FCSCst.FCSLOG.finest((Object)(this.name + " no PDO to be initialized."));
    }

    @Override
    public void updateFromPDO(PDOData pdo) {
        FCSCst.FCSLOG.finest((Object)(this.name + " no PDO to be updated."));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print CANopen device.")
    public String toString() {
        StringBuilder sb = this.name == null ? new StringBuilder() : new StringBuilder(this.name);
        sb.append("/SerialNumber=");
        sb.append(this.serialNB);
        sb.append("/NodeID=0x");
        sb.append(Integer.toHexString(this.nodeID));
        sb.append("/NodeID(in_decimal)=");
        sb.append(this.nodeID);
        sb.append("/");
        if (this.tcpProxy == null) {
            return sb.toString();
        }
        if (this.isBooted()) {
            sb.append("BOOTED/");
        } else {
            sb.append("NOT YET BOOTED/");
        }
        return sb.toString();
    }

    public StatusDataPublishedByCanOpenDevice createStatusDataPublishedByCanOpenDevice() {
        StatusDataPublishedByCanOpenDevice status = new StatusDataPublishedByCanOpenDevice(this.isBooted(), this.initialized, this.inError, this.errorRegister, this.errorHistory.length, this.lastErrorCode, this.lastErrorName);
        return status;
    }

    private static String truncate(String aString) {
        int x = 30;
        if (aString.length() > x) {
            return aString.substring(0, x);
        }
        return aString;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, alias="refreshGUI", description="Publish data for the device on the status bus.")
    public void publishData() {
        KeyValueData kvd = new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByCanOpenDevice());
        this.subs.publishSubsystemDataOnStatusBus(kvd);
    }
}

