/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class MobileItem
implements HardwareController,
AlertRaiser,
SignalHandler,
HasLifecycle {
    protected static final Logger FCSLOG = FCSCst.FCSLOG;
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    protected volatile boolean hasToWaitForEndOfAction = false;
    protected volatile FcsEnumerations.MobileItemAction currentAction;
    protected long commandDuration;
    protected long beginTime;
    protected boolean timeoutExceeded;
    private volatile boolean moving = false;
    protected final Lock lock = new ReentrantLock();
    private final Condition motionCompleted = this.lock.newCondition();
    @ConfigurationParameter(description="define intervale time between 2 read of sensors")
    private int readSensorsRate = 250;
    protected ScheduledFuture<?> readSensorsHandle;
    protected final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(2);
    private final AtomicBoolean haltRequired = new AtomicBoolean(false);
    private final AtomicBoolean stopRequired = new AtomicBoolean(false);

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public AtomicBoolean getHaltRequired() {
        return this.haltRequired;
    }

    protected void cancelReadingSensors() {
        this.lock.lock();
        try {
            FCSLOG.debug((Object)(this.name + " => stop reading sensors"));
            this.motionCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.readSensorsHandle.cancel(true);
        FCSLOG.debug((Object)(this.name + " => readingSensors canceled"));
    }

    public abstract boolean myDevicesReady();

    public abstract boolean isActionCompleted(FcsEnumerations.MobileItemAction var1);

    public abstract void updateStateWithSensorsToCheckIfActionIsCompleted();

    public abstract void startAction(FcsEnumerations.MobileItemAction var1);

    public abstract void abortAction(FcsEnumerations.MobileItemAction var1, long var2);

    public abstract void endAction(FcsEnumerations.MobileItemAction var1);

    public abstract void quickStopAction(FcsEnumerations.MobileItemAction var1, long var2);

    public abstract void publishData();

    protected void checkReadyForAction() {
        if (!this.myDevicesReady()) {
            throw new FcsHardwareException(this.name + ": hardware is not ready to execute ACTION commands.");
        }
        if (this.agentStateService.isInState((Enum)AlertState.ALARM)) {
            throw new FcsHardwareException(this.name + ": can't execute ACTION commands when subsystem is in ALARM state.");
        }
    }

    protected void executeAction(FcsEnumerations.MobileItemAction action, long timeoutForAction) {
        this.checkReadyForAction();
        this.beginTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.hasToWaitForEndOfAction = true;
            this.currentAction = action;
            this.commandDuration = 0L;
            this.timeoutExceeded = false;
            this.moving = true;
            FCSLOG.info((Object)(this.name + ": ===> STARTING ACTION:" + action.toString()));
            this.startAction(action);
            this.readSensorsUntilActionIsCompleted(action, timeoutForAction);
            this.waitForEndOfAction(action);
            if (this.haltRequired.get()) {
                this.abortAction(action, 0L);
                FCSLOG.info((Object)(this.name + "=> Received an ABORT command for action :" + action.toString()));
            } else if (this.stopRequired.get()) {
                this.quickStopAction(action, 0L);
                FCSLOG.info((Object)(this.name + "=> Received a STOP command for action :" + action.toString()));
            } else if (this.isActionCompleted(action)) {
                FCSLOG.info((Object)(this.name + " ===> ACTION COMPLETED : " + action.doneString()));
            }
            if (this.timeoutExceeded) {
                FCSLOG.info((Object)(this.name + " ===> ACTION NOT COMPLETED : " + action.doneString()));
                String msg = this.name + ":" + action.toString() + " exceeded timeout for this task: duration=" + this.commandDuration + ",timeout=" + timeoutForAction;
                FCSLOG.error((Object)msg);
                throw new FailedCommandException(msg);
            }
        }
        catch (Exception ex) {
            String msg = this.name + " ===> ERROR during ACTION : " + action.toString() + ex.getMessage();
            FCSLOG.error((Object)(msg + ex.getMessage()));
            FCSLOG.error((Object)action.getFailureMsg());
            throw new FailedCommandException(msg, (Throwable)ex);
        }
        finally {
            FCSLOG.debug((Object)(this.name + ": finally in executeAction."));
            this.moving = false;
            this.hasToWaitForEndOfAction = false;
            this.motionCompleted.signalAll();
            this.haltRequired.set(false);
            this.stopRequired.set(false);
            this.lock.unlock();
            this.endAction(action);
            this.commandDuration = System.currentTimeMillis() - this.beginTime;
            this.publishData();
            FCSLOG.info((Object)(this.name + " ===> END ACTION:" + action.toString() + " duration = " + this.commandDuration));
            this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name + "_" + action + "_duration", (Serializable)Long.valueOf(this.commandDuration)));
        }
    }

    public void readSensorsUntilActionIsCompleted(FcsEnumerations.MobileItemAction action, long timeout) {
        Runnable readSensors = () -> {
            try {
                this.commandDuration = System.currentTimeMillis() - this.beginTime;
                this.updateStateWithSensorsToCheckIfActionIsCompleted();
                boolean actionCompleted = this.isActionCompleted(action);
                if (this.haltRequired.get() || this.stopRequired.get()) {
                    this.hasToWaitForEndOfAction = false;
                    FCSLOG.info((Object)(this.name + ":" + action.toString() + " ABORT or STOP REQUESTED FOR ACTION BY ABORT or STOP COMMAND"));
                    this.cancelReadingSensors();
                } else if (actionCompleted) {
                    this.hasToWaitForEndOfAction = false;
                    FCSLOG.info((Object)(this.name + ":" + action.toString() + " ACTION COMPLETED"));
                    this.cancelReadingSensors();
                } else if (this.commandDuration >= timeout) {
                    this.hasToWaitForEndOfAction = false;
                    this.timeoutExceeded = true;
                    FCSLOG.info((Object)(this.name + ":" + action.toString() + " ACTION NOT COMPLETED during allocated time"));
                    this.cancelReadingSensors();
                } else {
                    FCSLOG.info((Object)(this.name + ":" + action.name() + " not completed... / duration=" + this.commandDuration));
                }
            }
            catch (Exception ex) {
                this.hasToWaitForEndOfAction = false;
                this.cancelReadingSensors();
                FCSLOG.error((Object)(this.name + ": ERROR in reading sensors during action " + action.name()), (Throwable)ex);
                throw new FcsHardwareException(this.name + ": ERROR in reading sensors during action " + action.name(), (Throwable)ex);
            }
        };
        this.readSensorsHandle = this.scheduler.scheduleAtFixedRate(readSensors, this.readSensorsRate, this.readSensorsRate, TimeUnit.MILLISECONDS);
    }

    protected void waitForEndOfAction(FcsEnumerations.MobileItemAction action) {
        while (this.hasToWaitForEndOfAction) {
            try {
                FCSLOG.info((Object)(this.name + " waiting for end of " + action.toString()));
                this.motionCompleted.await();
            }
            catch (InterruptedException ex) {
                FCSLOG.info((Object)(this.name + ": InterruptedException received=" + ex.toString()));
                break;
            }
        }
        FCSLOG.info((Object)(this.name + " STOP WAITING FOR END OF ACTION"));
    }

    private void halt(FcsEnumerations.MobileItemAction action, long delay) {
        if (action == null) {
            FCSLOG.warning((Object)(this.name + ": no current action running => nothing to abort."));
            return;
        }
        FCSLOG.debug((Object)(this.name + ": ABORTING ACTION " + action.toString() + "within delay=" + delay));
        this.abortAction(action, delay);
        this.moving = false;
    }

    private void quickStop(FcsEnumerations.MobileItemAction action, long delay) {
        if (action == null) {
            FCSLOG.warning((Object)(this.name + ": no current action running => nothing to stop."));
            return;
        }
        FCSLOG.debug((Object)(this.name + ": QUICKSTOP for" + action.toString() + "within delay=" + delay));
        this.quickStopAction(action, delay);
        this.moving = false;
    }

    public void shutdown() {
        FCSLOG.info((Object)(this.name + " is shutting down."));
        this.scheduler.shutdown();
    }

    public TreeWalkerDiag signal(Signal signal) {
        SignalLevel sl = signal.getLevel();
        FCSLOG.info((Object)sl.toString());
        if (!this.moving) {
            FCSLOG.warning((Object)(this.name + " is not moving; nothing to stop."));
        } else {
            switch (signal.getLevel()) {
                case HALT: {
                    FCSLOG.info((Object)(this.name + " HALT required"));
                    this.haltRequired.set(true);
                    this.halt(this.currentAction, signal.getTimeHint());
                    break;
                }
                case STOP: {
                    FCSLOG.info((Object)(this.name + " STOP required"));
                    this.stopRequired.set(true);
                    this.quickStop(this.currentAction, signal.getTimeHint());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public void checkStopped() throws HardwareException {
        if (this.moving) {
            throw new HardwareException(false, this.name + " is moving, has to be stopped before a shutdown.");
        }
    }
}

