/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.security.SecureRandom;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselMain;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselStandalonePlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class CarouselToto
extends CcsTestCaseTemplate {
    private static Subsystem carouselSubsystem = null;
    private static CarouselMain main;
    private static Carousel carousel;
    private static CarouselClamp clampXminus1;
    private static CarouselClamp clampXplus1;
    private static CarouselClamp clampXminus2;
    private static CarouselClamp clampXplus2;
    private static CarouselClamp clampXminus3;
    private static CarouselClamp clampXplus3;
    private static CarouselClamp clampXminus4;
    private static CarouselClamp clampXplus4;
    private static CarouselClamp clampXminus5;
    private static CarouselClamp clampXplus5;
    private static CarouselClamp[] clampsList;
    private static SimuCarouselController carouselController;
    private static SimuCarouselClampController clampXminusController;
    private final SecureRandom randomGenerator = new SecureRandom();
    private static SimuCarouselStandalonePlutoGateway plutoGateway;
    private static SimuTTC580 hyttc580;
    private static FilterManager filterManager;
    private static CanOpenProxy tcpProxy;
    private static ComponentLookup lookup;
    private static final String FILTER_U_NAME = "filterU";
    private static final String FILTER_G_NAME = "filterG";
    private static final String FILTER_R_NAME = "filterR";
    private static final String FILTER_I_NAME = "filterI";
    private static final String FILTER_Z_NAME = "filterZ";
    private static int LOCKA;
    private static int LOCKB;
    private static int LOCKC;
    private static int FILTERPRESENCEA;
    private static int FILTERPRESENCEB;
    private static int FILTERPRESENCEC;
    private static int socket1StandbyPos;
    private static CarouselSocket socket1;

    public CarouselToto() {
        socket1StandbyPos = carousel.getSocketByName("socket1").getStandbyPosition();
    }

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("********************************************************************************");
        System.out.println("                   TESTS OF CAROUSEL IN STANDALONE MODE");
        System.out.println("********************************************************************************");
        CCS.initializeScriptingEnvironment();
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        carouselSubsystem = BootUtils.getSubsystemFromFile((String)"carousel", (String)"");
        carouselSubsystem.startAgent();
        ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        lookup = carouselSubsystem.getComponentLookup();
        main = (CarouselMain)lookup.getComponentByPath("main");
        carousel = (Carousel)lookup.getComponentByPath("carousel");
        carouselController = (SimuCarouselController)lookup.getComponentByPath("carouselController");
        clampXminusController = (SimuCarouselClampController)lookup.getComponentByPath("clampXminusController");
        Assert.assertTrue((String)"carousel hardware is ready", (boolean)carousel.myDevicesReady());
        carouselController.initializeAndCheckHardware();
        Assert.assertTrue((String)"carouselController is initialized", (boolean)carouselController.isInitialized());
        carousel.homing();
        Assert.assertTrue((String)"carousel homing is done", (boolean)carousel.isHomingDone());
        plutoGateway = (SimuCarouselStandalonePlutoGateway)lookup.getComponentByPath("fakePlutoGateway");
        hyttc580 = (SimuTTC580)lookup.getComponentByPath("hyttc580");
        tcpProxy = (CanOpenProxy)lookup.getComponentByPath("tcpProxy");
        filterManager = (FilterManager)lookup.getComponentByPath("filterManager");
        filterManager.init();
        clampXminus1 = (CarouselClamp)lookup.getComponentByPath("clampXminus1");
        clampXplus1 = (CarouselClamp)lookup.getComponentByPath("clampXplus1");
        clampXminus2 = (CarouselClamp)lookup.getComponentByPath("clampXminus2");
        clampXplus2 = (CarouselClamp)lookup.getComponentByPath("clampXplus2");
        clampXminus3 = (CarouselClamp)lookup.getComponentByPath("clampXminus3");
        clampXplus3 = (CarouselClamp)lookup.getComponentByPath("clampXplus3");
        clampXminus4 = (CarouselClamp)lookup.getComponentByPath("clampXminus4");
        clampXplus4 = (CarouselClamp)lookup.getComponentByPath("clampXplus4");
        clampXminus5 = (CarouselClamp)lookup.getComponentByPath("clampXminus5");
        clampXplus5 = (CarouselClamp)lookup.getComponentByPath("clampXplus5");
        for (CarouselClamp clamp : clampsList = new CarouselClamp[]{clampXminus1, clampXplus1, clampXminus2, clampXplus2, clampXminus3, clampXplus3, clampXminus4, clampXplus4, clampXminus5, clampXplus5}) {
            clamp.setLockSensorValueA(Integer.valueOf(LOCKA));
            clamp.setLockSensorValueB(Integer.valueOf(LOCKB));
            clamp.setLockSensorMaxValue(Integer.valueOf(LOCKC));
            clamp.setFilterPresenceOffset1(Integer.valueOf(FILTERPRESENCEA));
            clamp.setFilterPresenceOffset2(Integer.valueOf(FILTERPRESENCEB));
            clamp.setFilterPresenceValueB(Integer.valueOf(FILTERPRESENCEC));
        }
        socket1 = (CarouselSocket)lookup.getComponentByPath("socket1");
    }

    private static void initializeSimulation() throws DriverException {
        hyttc580.initializeAndCheckHardware();
        carouselController.setPdo1(0L);
        carouselController.setPdo2(0L);
        System.out.println("socket1 initialization");
        carouselController.simulatePosition((long)socket1StandbyPos);
        hyttc580.simulateSocketAtStandby((short)1);
        hyttc580.simulateSlaveStatus((short)1);
        hyttc580.simulateClampIsLocked(clampXminus1);
        hyttc580.simulateClampIsLocked(clampXplus1);
        hyttc580.simulateClampFilterIsLockable(clampXminus1);
        hyttc580.simulateClampFilterIsLockable(clampXplus1);
        System.out.println("socket2 initialization");
        hyttc580.simulateSocketNotAtStandby((short)2);
        hyttc580.simulateSlaveStatusNotAtS((short)2);
        hyttc580.simulateClampIsLockedNotAtS(clampXminus2);
        hyttc580.simulateClampIsLockedNotAtS(clampXplus2);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXminus2);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXplus2);
        System.out.println("hyttc580:" + hyttc580);
        carousel.updateStateWithSensors();
        System.out.println("socket3 initialization");
        hyttc580.simulateSocketNotAtStandby((short)3);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXminus3);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXplus3);
        System.out.println("hyttc580:" + hyttc580);
        carousel.updateStateWithSensors();
        System.out.println("socket4 initialization");
        hyttc580.simulateSocketNotAtStandby((short)4);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXminus4);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXplus4);
        carousel.updateStateWithSensors();
        System.out.println("socket5 initialization");
        hyttc580.simulateSocketNotAtStandby((short)5);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXminus5);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXplus5);
        System.out.println("hyttc580:" + hyttc580);
        carousel.updateStateWithSensors();
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("*******************************************************************");
        System.out.println("********* end of TESTS OF CAROUSEL IN STANDALONE MODE *************");
        System.out.println("*******************************************************************");
        carouselSubsystem.shutdownAgent();
        ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() throws FcsHardwareException, DriverException {
        System.out.println("################################################");
        System.out.println("###            CarouselTest                  ###");
        System.out.println("###  Go back to initial conditions:          ###");
        System.out.println("###   socket1 at STANDBY                     ###");
        System.out.println("###   carousel holding a filter at STANDBY   ###");
        System.out.println("###   socket at STANDBY CLAMPEDONFILTER      ###");
        System.out.println("################################################");
        ((AlertService)carouselSubsystem.getAgentService(AlertService.class)).clearAllAlerts();
        carouselController.setSsiPosition(socket1StandbyPos);
        CarouselToto.initializeSimulation();
        Assert.assertEquals((String)"carousel position is socket1 STANDBY position", (long)socket1StandbyPos, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket in STANDBY is socket1", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
        Assert.assertEquals((String)"socket at standby ID", (long)1L, (long)carousel.getSocketAtStandby().getId());
        Assert.assertTrue((String)"clampXminus1 is LOCKED", (boolean)clampXminus1.isLocked());
        Assert.assertTrue((String)"clampXplus1 is LOCKED", (boolean)clampXplus1.isLocked());
        Assert.assertTrue((String)"clampXminus1 is LOCKABLE", (boolean)clampXminus1.isFilterEngaged());
        Assert.assertTrue((String)"clampXplus1 is LOCKABLE", (boolean)clampXplus1.isFilterEngaged());
        Assert.assertEquals((String)"clampXminus1 clampState", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)clampXminus1.getClampState());
        Assert.assertEquals((String)"clampXplus1 clampState", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)clampXplus1.getClampState());
        CarouselSocket socketAtStandby = carousel.getSocketAtStandby();
        hyttc580.simulateSlaveStatus((short)1);
        tcpProxy.updatePDOData();
        carousel.updateStateWithSensors();
        socketAtStandby.updateState();
        Assert.assertEquals((String)"socket at STANDBY slave status", (Object)FcsEnumerations.SlaveModuleStatus.IS_SOCKET_AT_STANDBY, (Object)socketAtStandby.getSlaveModuleStatus());
        Assert.assertEquals((String)"socket at STANDBY state", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)socketAtStandby.getClampsState());
        Assert.assertTrue((String)"carousel is holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertTrue((String)"Socket at STANDBY is LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testWriteCurrent() {
        System.out.println("*** test of method writeCurrent of class SimuCarouselClampController ***");
        int currentToUnlock = -4660;
        clampXminusController.writeCurrent(currentToUnlock);
        Assert.assertEquals((String)"clampXminus1 clamp state", (Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER, (Object)clampXminus1.getClampState());
    }

    @Test
    public void testClamps() throws FcsHardwareException, DriverException {
        System.out.println("*** test of clamps state ***");
        for (int i = 1; i <= 5; ++i) {
            String clampXminusName = "clampXminus" + i;
            System.out.println("Checking ClampState for " + clampXminusName);
            CarouselClamp clampXminus = (CarouselClamp)lookup.getComponentByPath(clampXminusName);
            Assert.assertTrue((String)(clampXminusName + " contains a filter."), (boolean)clampXminus.isFilterEngaged());
            Assert.assertTrue((String)(clampXminusName + " is LOCKED."), (boolean)clampXminus.isLocked());
            String clampXplusName = "clampXplus" + i;
            System.out.println("Checking ClampState for " + clampXplusName);
            CarouselClamp clampXplus = (CarouselClamp)lookup.getComponentByPath(clampXplusName);
            Assert.assertTrue((String)(clampXplusName + " contains a filter."), (boolean)clampXplus.isFilterEngaged());
            Assert.assertTrue((String)(clampXplusName + " is LOCKED."), (boolean)clampXplus.isLocked());
        }
        System.out.println("*** Test clamps state is in UNDEFINED state");
        System.out.println("Should throw an RejectedCommandException");
        hyttc580.simulateClampIsUnlocked(carousel.getSocketAtStandby().getClampXminus());
        carousel.updateStateWithSensors();
        FcsEnumerations.FilterClampState state = FcsEnumerations.FilterClampState.UNDEFINED;
        Assert.assertEquals((String)"Socket At STANDBY clampsState", (Object)state, (Object)carousel.getSocketAtStandby().getClampsState());
        try {
            carousel.unlockClamps();
            Assert.fail((String)"Clamps at STANDBY are not ClampedOnFilter. unlockClamps should raise an Exception.");
        }
        catch (FailedCommandException | RejectedCommandException ex) {
            System.out.println("Clamps at STANDBY are not ClampedOnFilter. Raised exception=" + ex);
        }
        System.out.println("*** Test unLockClamps when a filter is clamped at standby");
        System.out.println("Should work");
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
        plutoGateway.simulateAutochangerIsHoldingFilter();
        plutoGateway.updateValues();
        Assert.assertTrue((String)"filter is also held by autochanger", (boolean)carousel.isAutochangerHoldingFilter());
        Assert.assertEquals((String)"Clamps state at STANDBY", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketAtStandby().getClampsState());
        carousel.unlockClamps();
    }

    @Test
    public void testClampSensors() throws DriverException {
        System.out.println("*** testClampSensors ***");
        try {
            carousel.unlockClamps();
            Assert.fail((String)"Filter is not held by fakeAutochanger. unlockClamps should raise an Exception.");
        }
        catch (FailedCommandException | RejectedCommandException ex) {
            System.out.println("Filter is not held by fakeAutochanger. Raised exception=" + ex);
        }
        Assert.assertTrue((String)"fakePlutoGateway is booted", (boolean)plutoGateway.isBooted());
        plutoGateway.simulateAutochangerIsHoldingFilter();
        plutoGateway.updateValues();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is still holding filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertTrue((String)"filter is also held by autochanger", (boolean)carousel.isAutochangerHoldingFilter());
        carousel.unlockClamps();
        Assert.assertEquals((String)"socket at STANDBY is ", (Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER, (Object)carousel.getSocketAtStandby().getClampsState());
        for (int i = 2; i < 5; ++i) {
            String socketName = "socket" + i;
            Assert.assertEquals((String)(socketName + "'s clamp state"), (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName(socketName).getClampsState());
        }
        System.out.println("Go back to initial conditions");
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testIsHoldingFilter() throws FcsHardwareException, DriverException {
        System.out.println("*** test of isHoldingFilterAtStandby ***");
        hyttc580.simulateClampIsUnlocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsUnlocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"carousel is NOT holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        System.out.println("Go back to initial conditions");
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testCheckConditionForRotation() throws FcsHardwareException, DriverException {
        System.out.println("*** test of checkConditionsForRotation");
        try {
            carousel.checkConditionsForRotation();
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            Assert.fail((String)("in initial conditions, rotation is allowed. No exception should be raised:" + ex));
        }
        System.out.println("Simulate clamps at STANDBY are UNLOCKED");
        hyttc580.simulateClampIsUnlocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsUnlocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        String msg = "Clamps are UNLOCKED but filter is still there.";
        Assert.assertTrue((String)msg, (boolean)carousel.getSocketAtStandby().isUnclampedOnFilter());
        try {
            carousel.checkConditionsForRotation();
            Assert.fail((String)(msg + " checkConditionsForRotation should raise an Exception."));
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            System.out.println("Carousel can't rotate because " + msg + ex);
        }
        System.out.println("Go back to initial conditions. simulate clamps at STANDBY are LOCKED");
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
    }

    @Test
    public void testHoming() {
        System.out.println("test homing of class CarouselModule");
        carouselController.simulatePosition((long)socket1StandbyPos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position is socket1 STANDBY position", (long)socket1StandbyPos, (long)carousel.getPosition());
        carousel.homing();
        Assert.assertEquals((String)"carousel position should not change with homing", (long)socket1StandbyPos, (long)carousel.getPosition());
        Assert.assertTrue((String)"homing is done", (boolean)carousel.isHomingDone());
    }

    @Test
    public void testRotateSocketToStandby() throws FcsHardwareException {
        System.out.println("TEST rotateSocketToStandby");
        System.out.println("rotateSocketToStandby socket2");
        carousel.rotateSocketToStandby("socket2");
        Assert.assertEquals((String)"carousel position should be socket2 standbyPosition", (long)carousel.getSocketByName("socket2").getStandbyPosition(), (long)carousel.getPosition());
        Assert.assertEquals((String)"socket at STANDBY id", (long)2L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket4");
        carousel.rotateSocketToStandby("socket4");
        Assert.assertEquals((String)"socket at STANDBY id", (long)4L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket3");
        carousel.rotateSocketToStandby("socket3");
        Assert.assertEquals((String)"socket at STANDBY id", (long)3L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket5");
        carousel.rotateSocketToStandby("socket5");
        Assert.assertEquals((String)"socket at STANDBY id", (long)5L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket1");
        carousel.rotateSocketToStandby("socket1");
        Assert.assertEquals((String)"carousel position", (long)carousel.getSocketByName("socket1").getStandbyPosition(), (long)carousel.getPosition());
        System.out.println("pdo1 = " + Long.toBinaryString(hyttc580.getPdo1()));
        Assert.assertEquals((String)"socket id at standby", (long)1L, (long)hyttc580.getSocketId(hyttc580.getPdo1()));
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"socket at STANDBY id", (long)1L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket3");
        carousel.rotateSocketToStandby("socket3");
        Assert.assertEquals((String)"socket at STANDBY id", (long)3L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket5");
        carousel.rotateSocketToStandby("socket5");
        Assert.assertEquals((String)"socket at STANDBY id", (long)5L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket1");
        carousel.rotateSocketToStandby("socket1");
        Assert.assertEquals((String)"carousel position", (long)carousel.getSocketByName("socket1").getStandbyPosition(), (long)carousel.getPosition());
        System.out.println("pdo1 = " + Long.toBinaryString(hyttc580.getPdo1()));
        Assert.assertEquals((String)"socket id at standby", (long)1L, (long)hyttc580.getSocketId(hyttc580.getPdo1()));
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"socket at STANDBY id", (long)1L, (long)carousel.getSocketAtStandby().getId());
    }

    @Test
    public void testRotateEmptySocketAtStandby() {
        System.out.println("rotateEmptySocketAtStandby");
        try {
            carousel.rotateEmptySocketAtStandby();
        }
        catch (FailedCommandException | FcsHardwareException | RejectedCommandException ex) {
            Assert.fail((String)("rotateEmptySocketAtStandby should do nothing but not raised an Exception:" + ex));
        }
    }

    @Test
    public void testUpdatePosition() {
        System.out.println("test of updatePosition");
        int pos = this.randomGenerator.nextInt(Math.abs(carousel.getFullTurn()));
        carouselController.setSsiPosition(pos);
        Assert.assertEquals((String)("carouselController position is " + pos), (long)pos, (long)carouselController.readPosition());
        carousel.updatePosition();
        Assert.assertEquals((String)("carousel position is " + pos), (long)pos, (long)carousel.getPosition());
    }

    @Test
    public void testWriteTargetPosition() throws FcsHardwareException {
        System.out.println("###############################################################");
        System.out.println("test of testWriteTargetPosition of class SimuCarouselController");
        System.out.println("###############################################################");
        int pos = carousel.getSocketByName("socket2").getStandbyPosition();
        System.out.println("testCarouselController: rotate to position " + pos);
        int initialPosition = carousel.getPosition();
        int finalPosition = pos;
        carouselController.writeTargetPosition(pos);
        carousel.updatePosition();
        System.out.println("test with pos=" + pos + " and initialPosition=" + initialPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        pos = carousel.getSocketByName("socket4").getStandbyPosition();
        System.out.println("testCarouselController: rotate to position " + pos);
        initialPosition = carousel.getPosition();
        finalPosition = pos;
        carouselController.writeTargetPosition(pos);
        carousel.updatePosition();
        System.out.println("test with pos=" + pos + " and initialPosition=" + initialPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        pos = carousel.getSocketByName("socket5").getStandbyPosition();
        System.out.println("testCarouselController: rotate to position " + pos);
        initialPosition = carousel.getPosition();
        finalPosition = pos;
        carouselController.writeTargetPosition(pos);
        carousel.updatePosition();
        System.out.println("test with pos=" + pos + " and initialPosition=" + initialPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
        pos = carousel.getSocketByName("socket3").getStandbyPosition();
        System.out.println("testCarouselController: rotate to position " + pos);
        initialPosition = carousel.getPosition();
        finalPosition = pos;
        carouselController.writeTargetPosition(pos);
        carousel.updatePosition();
        System.out.println("test with pos=" + pos + " and initialPosition=" + initialPosition);
        Assert.assertEquals((String)"carousel position", (long)finalPosition, (long)carousel.getPosition());
    }

    @Test
    public void testUpdateFakePDOData() {
        System.out.println("updateFakePDOData of class SimuCarouselController");
        long value = 0L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = 1L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = 65535L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = -2234066821449711617L;
        carouselController.updateFakePDOData(carouselController.getCobid1(), value);
        Assert.assertEquals((String)"pdo1", (long)value, (long)carouselController.getPdo1());
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
        value = -2305671193734396952L;
        carouselController.updateFakePDOData(carouselController.getCobid2(), value);
        Assert.assertEquals((String)"pdo2", (long)value, (long)carouselController.getPdo2());
    }

    @Test
    public void testSimulatePosition() throws DriverException {
        System.out.println("simulatePosition of class SimuCarouselController");
        long pos = 0L;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        tcpProxy.updatePDOData();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        pos = 1L;
        System.out.println("pos = " + pos);
        long pdo = pos << 32;
        long mask = 0xFFFFFFFFL;
        long newpdo = pdo | carouselController.getPdo1() & mask;
        carouselController.simulatePosition(pos);
        Assert.assertEquals((String)"pdo1", (long)newpdo, (long)carouselController.getPdo1());
        tcpProxy.updatePDOData();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        pos = 3000L;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        tcpProxy.updatePDOData();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        pos = -204200L;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        tcpProxy.updatePDOData();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carouselController.getPosition());
        carousel.updateState();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -1075906L;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -1948470L;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -2821074L;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -3694258L;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
        pos = -1L;
        System.out.println("pos = " + pos);
        carouselController.simulatePosition(pos);
        carousel.updateStateWithSensors();
        Assert.assertEquals((String)"carousel position", (long)pos, (long)carousel.getPosition());
    }

    public void launchScript() throws Exception {
        System.out.println("************************************************");
        System.out.println("*** Launch Python SCRIPT carouselTest.py ***");
        System.out.println("************************************************");
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/carouselTest.py", (String[])new String[0]);
    }

    static {
        LOCKA = 1000;
        LOCKB = 2000;
        LOCKC = 3000;
        FILTERPRESENCEA = 500;
        FILTERPRESENCEB = 1500;
        FILTERPRESENCEC = 2500;
    }
}

