package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.command.annotations.Command;
import static org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode.HOMING;
import static org.lsst.ccs.subsystems.fcs.EPOSEnumerations.Parameter.HomePosition;
import static org.lsst.ccs.subsystems.fcs.EPOSEnumerations.Parameter.HomingMethod;
import static org.lsst.ccs.subsystems.fcs.EPOSEnumerations.Parameter.PositionSensorType;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 *
 * @author virieux
 */
public interface EPOSControllerForCarousel extends EPOSController {

    /**
     * Set PositionSensorType to Absolute encoder SSI (value=4)
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1, description = "Set PositionSensorType to Absolute encoder SSI (value is 4)")
    default void setPositionSensorTypeEncoderSSI() {
        FCSLOG.info(getName() + " setting PositionSensorType Absolute encoder SSI");
        /* time between 2 commands sent to controller to let it change its state */
        /* tested in January 2020: 50 was too small */
        int sleepTime = 100;
        disableOperation();
        FcsUtils.sleep(sleepTime, getName());
        disableVoltage();
        FcsUtils.sleep(sleepTime, getName());
        writeParameter(PositionSensorType, 4);
    }

    /**
     * Set PositionSensorType to Sinus Incremental Encoder(value=8)
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1, description = "Set PositionSensorType to Sinus Incremental Encoder(value is 8)")
    default void setPositionSensorTypeSinusIncrementalEncoder() {
        FCSLOG.info(getName() + " setting PositionSensorType Sinus Incremental Encoder");
        /* time between 2 commands sent to controller to let it change its state */
        /* tested in January 2020: 50 was too small */
        int sleepTime = 100;
        disableOperation();
        FcsUtils.sleep(sleepTime, getName());
        disableVoltage();
        FcsUtils.sleep(sleepTime, getName());
        writeParameter(PositionSensorType, 8);
    }

    /**
     *
     * @param position
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING3, description = "Define the actual position as position given as argument.")
    @Override
    default void defineAbsolutePosition(int position) {
        // TODO check why this method overrides the EPOSController's
        // defineAbsolutePosition method.
        FCSLOG.debug(getName() + " Defining Absolute Position:" + position);
        this.changeMode(HOMING);
        this.writeParameter(HomePosition, position);
        this.writeParameter(HomingMethod, 35);
        this.enable();
        /* start homing */
        this.writeControlWord(0x1F);
        checkHomingDone();
    }

}
