#####################################################################
# To test sequence of actions on loader :
# goToHandoff, close, goToEngaged, clamp, goToStorage, goToEngaged, unclamp, goToHandoff, open
#####################################################################
### change iteration number / nombre d'iterations a changer si besoin est
iter = 1
#####################################################################

# import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import CCS
#import the definition for a Java Exception                                                                                   
import java.time
from java.lang import Exception
from time import sleep


CCS.setThrowExceptions(True)

#time to wait for switch change
waitTime = int(15)

#time to do a nap
napTime = int(2)

#####################################################################
# launch loaderProto-standalone subsystem and initialize
#####################################################################
loaderSubsName = "loader-standalone_LO1"
loaderStandalone = CCS.attachSubsystem(loaderSubsName)
print "Connected to loader-standalone_LO1 ", loaderStandalone

#getting timeouts
loaderConfigFuture = loaderStandalone.sendAsynchCommand("getConfigurationInfo")
print "getting loader configuration info"
loaderConfig = loaderConfigFuture.get()
timeoutHandoff = java.time.Duration.ofMillis(int(loaderConfig.getCurrentValueForParameter("carrier/timeoutForGoingToHandOff")))
timeoutStorage = java.time.Duration.ofMillis(int(loaderConfig.getCurrentValueForParameter("carrier/timeoutForGoingToStorage")))
timeoutEngaged = java.time.Duration.ofMillis(int(loaderConfig.getCurrentValueForParameter("carrier/timeoutForGoingToEngaged")))
timeoutToOpen = java.time.Duration.ofMillis(int(loaderConfig.getCurrentValueForParameter("clamp/timeoutForOpeningHooks")))

###loader
loader = CCS.attachSubsystem(loaderSubsName + "/loader")

###carrier
carrier = CCS.attachSubsystem(loaderSubsName + "/carrier")

##Clamp
clamp = CCS.attachSubsystem(loaderSubsName + "/clamp")
hooksController = CCS.attachSubsystem(loaderSubsName + "/hooksController")

###plutoGateway
plutoGateway = CCS.attachSubsystem(loaderSubsName + "/loaderPlutoGateway")

###fake autochanger
autochanger = CCS.attachSubsystem(loaderSubsName + "/autochanger")

###AP2
acAP2 = CCS.attachSubsystem(loaderSubsName + "/acAP2")

###AF0
acAF0 = CCS.attachSubsystem(loaderSubsName + "/acAF0")

##Proxy
tcpProxy = CCS.attachSubsystem(loaderSubsName + "/loaderTcpProxy")

storagePosition=int(carrier.sendSynchCommand("getStoragePosition"))
print "STORAGE position=", storagePosition

handoffPosition=int(carrier.sendSynchCommand("getHandoffPosition"))
print "HANDOFF position=", handoffPosition

CCS.setThrowExceptions(True)

result = tcpProxy.sendSynchCommand("allDevicesBooted")
if result:
    print "allDevicesBooted=", result
else:
    raise Exception("CANopen Hardware not ready")

############################################################################
# Check controllers and plutoGateway are READY
############################################################################
#hardware is READY 
#print "Check that controllers and plutoGateway are initialized...."
if plutoGateway.sendSynchCommand("isInitialized"):
    print "plutoGateway.isInitialized()=", result
else:
    raise Exception("plutoGateway not Ready")

if hooksController.sendSynchCommand("isInitialized"):
    print "hooksController.isInitialized()=", result
else:
    raise Exception("hooksController not Ready")

############################################################################
# Check initial conditions
############################################################################
#loader is connected on camera
if loader.sendSynchCommand("isConnectedOnCamera"):
    print "loader carrier is connected on camera: OK"
else:
    raise Exception("loader carrier is not connected on camera")

if acAP2.sendSynchCommand("isOn"):
    print "AP2 is ON: OK"
else:
    raise Exception("AP2 has to be ON to continue")

############################################################################
# def go to initial conditions
############################################################################
def goToInitialConditions():
    print "BEGIN goToInitialConditions"
    print "Initial conditions : empty at STORAGE position..."
    #no filter is in the loader
    if loader.sendSynchCommand("isEmpty"):
        print "loader is NOT holding a filter: OK"
        goToInitialConditionsEmpty()
    #a filter is in the loader 
    else:
        print "a filter is on the loader"
        goToInitialConditionsLoaded()
    print "END goToInitialConditions"

############################################################################
# def go to initial conditions when empty
############################################################################        
def goToInitialConditionsEmpty():
    #homing has to be done
    if not clamp.sendSynchCommand("isHomingDone"):
        print "homing has to be done : please wait while opening clamp... "
        clamp.sendSynchCommand(timeoutToOpen, "open")
    #clamp should be opened
    if not clamp.sendSynchCommand("isOpened"):
        print "clamp has to be opened : opening clamp..."
        clamp.sendSynchCommand(timeoutToOpen, "open")
    #carrier is at STORAGE : nothing to do
    if carrier.sendSynchCommand("isAtStorage"):
        print "loader carrier is at STORAGE position: OK"
    #carrier is NOT at STORAGE : have to move carrier to STORAGE
    else:
        ###go to STORAGE
        print "Loader going to STORAGE without filter ...."
        carrier.sendSynchCommand(timeoutStorage, "goToStorage")        
            
############################################################################
# def go to initial conditions when a filter is in the loader
############################################################################   
def goToInitialConditionsLoaded():
    #clamp should be clamped
    if clamp.sendSynchCommand("isClamped"):
        print "clamp is clamped on filter: OK"
    else:
        print "clamping...."
        clamp.sendSynchCommand(timeoutToOpen, "clamp")
    #clamp is now clamped so carrier can be moved with filter
    sequenceMoveFilterFromStorageToHandoff()
    sequenceOpenClampAndMoveEmptyToStorage()
    

############################################################################
# def to wait for autochanger holding filter
############################################################################

def waitForAutochangerHoldingFilter():
    loaderStandalone.sendSynchCommand("updateStateWithSensors")
    while not autochanger.sendSynchCommand("isHoldingFilter"):
        print "Waiting for autochanger hold filter (AP2 & AF3) ..."
        sleep(waitTime)
        loaderStandalone.sendSynchCommand("updateStateWithSensors")
    else:
        print "autochanger is holding filter"

############################################################################
# def to wait for autochanger NOT holding filter
############################################################################
def waitForAutochangerNOTHoldingFilter():
    loaderStandalone.sendAsynchCommand("updateStateWithSensors")
#    while not autochanger.sendSynchCommand("isNotHoldingFilter"):
    while not acAF0.sendSynchCommand("isOn"):
        print "Waiting for autochanger release filter (AP2 & AF0 & AF1) ..."
        sleep(waitTime)
        loaderStandalone.sendSynchCommand("updateStateWithSensors")
        sleep(2)
    else:
        print "autochanger is NOT holding filter"


############################################################################
# def to do a little nap
############################################################################
def littleNap():
    ### a little nap to let time to see what's hapenning
    print "a little nap to let time to see what's hapenning"
    sleep(napTime)

################################################################################
# Sequence :
# - goToHandoff,
# - close,
# - wait for autochanger to release filter,
# - goToEngaged (slowly)
# - clamp
# - goToStorage (normal speed)
# - goToEngaged (normal speed)
# - unclamp
# - goToHandoff (slowly)
# - open
################################################################################
CCS.setThrowExceptions(True)

###############################################################################
def sequenceMoveEmptyToHandoffAndCloseClamp():
###############################################################################
    print "=> sequenceMoveEmptyToHandoffAndCloseClamp"
    ###goToHandoff
    print "Going to handoff without filter...."
    loader.sendSynchCommand(timeoutHandoff, "moveEmptyToHandoffAndClose")
   
    waitForAutochangerHoldingFilter()



###############################################################################
def sequenceMoveFilterFromHandoffToStorage():
###############################################################################
    print "=> sequenceMoveFilterFromHandoffToStorage"
    ###wait for autochanger not holding filter
    waitForAutochangerNOTHoldingFilter()
    littleNap()
    ###
    print "Executing command : moveFilterToStorage"
    loader.sendSynchCommand(timeoutStorage, "moveFilterToStorage")

    littleNap()

###############################################################################
def sequenceMoveFilterFromStorageToHandoff():
###############################################################################
    print "=>   sequenceMoveFilterFromStorageToHandoff"
    ###moveFilterToHandoff
    #carrier.raiseProfileVelocity();
    #    carrier.goToEngaged();
    #    clamp.unclamp();
    #    carrier.slowProfileVelocity();
    #   carrier.goToHandOff();
    loader.sendSynchCommand(timeoutHandoff, "moveFilterToHandoff")

    waitForAutochangerHoldingFilter()

###############################################################################
def sequenceOpenClampAndMoveEmptyToStorage():
###############################################################################
    print "=> sequenceOpenClampAndMoveEmptyToStorage"
    
    ###go to STORAGE
    print "Loader opens hooks and go to STORAGE without filter ...."
    loader.sendSynchCommand(timeoutHandoff, "openClampAndMoveEmptyToStorage")


################################################################################
# Main Sequence
################################################################################s
goToInitialConditions()
for i in range(iter):
  
    print "begin ITERATION  ", i
    sequenceMoveEmptyToHandoffAndCloseClamp()
    sequenceMoveFilterFromHandoffToStorage()
    sequenceMoveFilterFromStorageToHandoff()
    sequenceOpenClampAndMoveEmptyToStorage()
    print "end ITERATION  ", i
    
print "END LOOP"    






