/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;

public abstract class LatchActuator {
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem s;
    @ConfigurationParameter(description="decimal value of the current limit (in Ampere) to determine the couple")
    protected double currentLimitInVolt = 0.15;
    @ConfigurationParameter(range="-10..10", description="decimal value of the voltage (in Volt) to send to the actuator to determine the speed")
    protected double speedVoltageInVolt = 4.0;
    @ConfigurationParameter(description="minimal decimal value of the speed voltage (used for the GUI)")
    public int speedVoltageMinValue = -10;
    @ConfigurationParameter(description="maximal decimal value of the speed voltage (used for the GUI)")
    public int speedVoltageMaxValue = 10;

    public LatchActuator(double currentLimitInVolt, double speedVoltageInVolt, int speedVoltageMinValue, int speedVoltageMaxValue) {
        this.currentLimitInVolt = currentLimitInVolt;
        this.speedVoltageInVolt = speedVoltageInVolt;
        this.speedVoltageMinValue = speedVoltageMinValue;
        this.speedVoltageMaxValue = speedVoltageMaxValue;
    }

    public double getCurrentLimitInVolt() {
        return this.currentLimitInVolt;
    }

    public void setCurrentLimitInVolt(double currentLimitInVolt) {
        this.currentLimitInVolt = currentLimitInVolt;
    }

    public double getSpeedVoltageInVolt() {
        return this.speedVoltageInVolt;
    }

    public void setSpeedVoltageInVolt(int speedVoltageInVolt) {
        this.speedVoltageInVolt = speedVoltageInVolt;
    }

    public int getSpeedVoltageMaxValue() {
        return this.speedVoltageMaxValue;
    }

    public void setSpeedVoltageMaxValue(int speedVoltageMaxValue) {
        this.speedVoltageMaxValue = speedVoltageMaxValue;
    }

    public int getSpeedVoltageMinValue() {
        return this.speedVoltageMinValue;
    }

    public void setSpeedVoltageMinValue(int speedVoltageMinValue) {
        this.speedVoltageMinValue = speedVoltageMinValue;
    }

    public abstract String open();

    public abstract String close();

    public abstract String powerOff();
}

