/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.LatchActuator;

public class CanOpenLatchActuator
extends LatchActuator {
    private CanOpenDAC dac;
    @ConfigurationParameter
    private int numOfAnalogOutputForSpeedVoltage;
    @ConfigurationParameter
    private int numOfAnalogOutputForCurrentLimit;

    public CanOpenLatchActuator(CanOpenDAC dac, double currentLimitInVolt, double speedVoltageInVolt, int speedVoltageMinValue, int speedVoltageMaxValue, int numOfAnalogOutputForSpeedVoltage, int numOfAnalogOutputForCurrentLimit) {
        super(currentLimitInVolt, speedVoltageInVolt, speedVoltageMinValue, speedVoltageMaxValue);
        this.dac = dac;
        this.numOfAnalogOutputForSpeedVoltage = numOfAnalogOutputForSpeedVoltage;
        this.numOfAnalogOutputForCurrentLimit = numOfAnalogOutputForCurrentLimit;
    }

    public void setNumOfAnalogOutputForSpeedVoltage(int numOfAnalogOutputForSpeedVoltage) {
        this.numOfAnalogOutputForSpeedVoltage = numOfAnalogOutputForSpeedVoltage;
    }

    public void setNumOfAnalogOutputForCurrentLimit(int numOfAnalogOutputForCurrentLimit) {
        this.numOfAnalogOutputForCurrentLimit = numOfAnalogOutputForCurrentLimit;
    }

    @Override
    public String open() {
        int currentLimitInDecimal = (int)(this.currentLimitInVolt * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, currentLimitInDecimal);
        int speedVoltageInDecimal = (int)(this.speedVoltageInVolt * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, speedVoltageInDecimal);
        return this.name + " is OPEN";
    }

    @Override
    public String close() {
        int currentLimitInDecimal = (int)(this.getCurrentLimitInVolt() * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, currentLimitInDecimal);
        int speedVoltageInDecimal = (int)(this.getSpeedVoltageInVolt() * 3210.27287);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, -speedVoltageInDecimal);
        return this.name + " is CLOSED";
    }

    @Override
    public String powerOff() {
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForCurrentLimit, 0);
        this.dac.writeAnalogOutput(this.numOfAnalogOutputForSpeedVoltage, 0);
        return this.name + " is POWER OFF";
    }
}

