/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class LoaderCarrier
extends MobileItem
implements MovedByEPOSController,
ControlledBySensors {
    public static final int TIMEOUT_FOR_MOVING_CARRIER = 120000;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="handoffSensors")
    private BinarySensor handoffSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="storageSensors")
    private BinarySensor storageSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="engagedSensors")
    private BinarySensor engagedSensors;
    private int position = 0;
    private int ssiPosition = 0;
    private int absoluteTargetPosition = 0;
    @ConfigurationParameter(description="delta position in micron : used to know if carrier position is in a range of 2*deltaPosition around a given position")
    private int deltaPosition = 50;
    @ConfigurationParameter(description="Loader Handoff position in micron")
    private int handoffPosition = 1037500;
    @ConfigurationParameter(description="Loader Engaged position in micron")
    private int engagedPosition = 1035500;
    @ConfigurationParameter(description="Loader Storage position in micron")
    private int storagePosition = 0;
    @ConfigurationParameter(description="For the Loader GUI : Maximum current to be sent to the Loader Carrier controller (in mA).")
    private int maxCurrent = 1000;
    @ConfigurationParameter(description="For the Loader GUI : Loader Carrier Maximum speed (in rpm/mn).")
    private int maxSpeed = 227;
    @ConfigurationParameter(description="timeout in milliseconds to go from storage to handoff on loader")
    private long timeoutForGoingToHandOff = 120000L;
    @ConfigurationParameter(description="timeout in milliseconds to go from storage to engaged on loader")
    private long timeoutForGoingToEngaged = 120000L;
    @ConfigurationParameter(description="timeout in milliseconds to go from handoff to storage on loader")
    private long timeoutForGoingToStorage = 120000L;
    @ConfigurationParameter(description="low speed to go with a filter from ENGAGED to HANDOFF position")
    private int lowSpeed = 185;
    @ConfigurationParameter(description="high speed to move carrier when it's empty or with a filter from ENGAGED to STORAGE position")
    private int highSpeed = 220;
    @ConfigurationParameter(description="low acceleration to move carrier with a filter from ENGAGED to STORAGE position")
    private int lowAcceleration = 20;
    @ConfigurationParameter(description="high acceleration to move carrier empty from ENGAGED to STORAGE position")
    private int highAcceleration = 100;
    @ConfigurationParameter(description="low deceleration to move carrier with a filter from ENGAGED to STORAGE position")
    private int lowDeceleration = 20;
    @ConfigurationParameter(description="high deceleration to move carrier with a filter from ENGAGED to STORAGE position")
    private int highDeceleration = 75;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*carrierController")
    private EPOSController carrierController;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*loaderTcpProxy")
    private BridgeToHardware loaderTcpProxy;
    private volatile boolean initialized = false;
    private int speed;
    private int current;
    private long profileVelocity;

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns carrier position.")
    public int getPosition() {
        return this.position;
    }

    protected int getCurrent() {
        return this.current;
    }

    @Override
    public String getControllerName() {
        return this.carrierController.getName();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carrier is initialized and ready to receive commands.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max speed in rpm/mn (format decimal).")
    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the max current in mA (format decimal).")
    public int getMaxCurrent() {
        return this.maxCurrent;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the handoff position in microns (format decimal).")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    public int getEngagedPosition() {
        return this.engagedPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the storage position in microns (format decimal).")
    public int getStoragePosition() {
        return this.storagePosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the timeout for going to Handoff in millis (format decimal).")
    public long getTimeoutForGoingToHandOff() {
        return this.timeoutForGoingToHandOff;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return the timeout for going to Storage in millis (format decimal).")
    public long getTimeoutForGoingToStorage() {
        return this.timeoutForGoingToStorage;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Storage are equal.")
    public boolean isStorageSensorsInError() {
        return this.storageSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at HandOff are equal.")
    public boolean isHandoffSensorsInError() {
        return this.handoffSensors.isInError();
    }

    @Override
    public boolean isInError() {
        return this.handoffSensors.isInError() || this.storageSensors.isInError() || this.engagedSensors.isInError();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Homing of carrier controller. Should be done only if necessary.")
    public void homing() {
        this.carrierController.definePositionFromNegativeLimitSwitch();
        this.carrierController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        FCSLOG.info((Object)(this.name + " homing done."));
    }

    public void initializeController() {
        try {
            this.carrierController.initializeAndCheckHardware();
            this.carrierController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.profileVelocity = this.readProfileVelocity();
            this.initialized = true;
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initialize controller", this.name, (Exception)((Object)ex));
        }
    }

    public void postStart() {
        FCSLOG.info((Object)(this.name + " postStart"));
        if (this.carrierController.isBooted()) {
            this.initializeController();
        }
    }

    @Override
    public boolean myDevicesReady() {
        return this.loaderTcpProxy.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at storage position. This command doesn't read again the sensors.")
    public boolean isAtStorage() {
        return this.storageSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at HANDOFF position. This command doesn't read again the sensors.At HANDOFF engagedSensors and handoffSensors are ON.")
    public boolean isAtHandoff() {
        return this.handoffSensors.isOn() && this.engagedSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at HANDOFF position. This command doesn't read again the sensors.")
    public boolean isAtEngaged() {
        return this.engagedSensors.isOn() && !this.handoffSensors.isOn();
    }

    @Command(type=Command.CommandType.ACTION, level=1, alias="goToHandoff", description="Move the carrier to Handoff position.", timeout=120000)
    public void goToHandOff() {
        if (this.isAtHandoff()) {
            FCSLOG.info((Object)(this.name + " is already at Handoff position. Nothing to do."));
        } else {
            this.loader.checkConditionsForCarrierMotion(this.handoffPosition);
            this.absoluteTargetPosition = this.handoffPosition;
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_HANDOFF, this.timeoutForGoingToHandOff);
            this.afterMotion();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to Engaged position.", timeout=120000)
    public void goToEngaged() {
        if (this.isAtEngaged()) {
            FCSLOG.info((Object)(this.name + " is already at Engaged position. Nothing to do."));
        } else {
            this.loader.checkConditionsForCarrierMotion(this.engagedPosition);
            this.absoluteTargetPosition = this.engagedPosition;
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_ENGAGED, this.timeoutForGoingToEngaged);
            this.afterMotion();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to STORAGE position.", timeout=120000)
    public void goToStorage() {
        if (this.isAtStorage()) {
            FCSLOG.info((Object)(this.name + " is already at Storage position. Nothing to do."));
        } else {
            this.loader.checkConditionsForCarrierMotion(this.storagePosition);
            this.absoluteTargetPosition = this.storagePosition;
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_STORAGE, this.timeoutForGoingToStorage);
            this.afterMotion();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the carrier to absolute position given as argument (in decimal format).", timeout=120000)
    public void goToAbsolutePosition(int absolutePosition) {
        this.updatePosition();
        if (this.position == absolutePosition) {
            FCSLOG.info((Object)(this.name + " is already at position " + absolutePosition));
        } else {
            this.loader.checkConditionsForCarrierMotion(absolutePosition);
            this.absoluteTargetPosition = absolutePosition;
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION, this.timeoutForGoingToStorage);
            this.afterMotion();
        }
    }

    private void checkProfileVelocity() {
        long velocity = this.readProfileVelocity();
        if (this.loader.isHoldingFilter() && velocity > (long)this.lowSpeed) {
            throw new RejectedCommandException(this.name + " ProfileVelocity too high with a filter in the loader.");
        }
    }

    private void checkProfileAcceleration() {
        boolean betweenEngagedAndHandoff;
        long acceleration = this.carrierController.readParameter(EPOSEnumerations.Parameter.ProfileAcceleration);
        boolean bl = betweenEngagedAndHandoff = this.position >= this.engagedPosition && this.absoluteTargetPosition >= this.engagedPosition;
        if (this.loader.isHoldingFilter() && betweenEngagedAndHandoff && acceleration > (long)this.lowAcceleration) {
            throw new RejectedCommandException(this.name + " ProfileAcceleration too high with a filter in the loader.");
        }
    }

    private void checkProfileDeceleration() {
        boolean fromStorageToHandoff;
        boolean betweenEngagedAndHandoff;
        long deceleration = this.carrierController.readParameter(EPOSEnumerations.Parameter.ProfileDeceleration);
        boolean bl = betweenEngagedAndHandoff = this.position >= this.engagedPosition && this.absoluteTargetPosition >= this.engagedPosition;
        if (this.loader.isHoldingFilter() && betweenEngagedAndHandoff && deceleration > (long)this.lowDeceleration) {
            throw new RejectedCommandException(this.name + " ProfileDeceleration too high with a filter in the loader.");
        }
        boolean bl2 = fromStorageToHandoff = this.absoluteTargetPosition > this.position;
        if (this.loader.isEmpty() && fromStorageToHandoff && deceleration > (long)this.lowDeceleration) {
            throw new RejectedCommandException(this.name + " ProfileDeceleration too high to go to handoff without a filter.");
        }
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileVelocity parameter to lowSpeed")
    public void slowProfileVelocity() {
        this.profileVelocity = this.lowSpeed;
        this.carrierController.changeProfileVelocity(this.lowSpeed);
        FCSLOG.info((Object)(this.name + " new ProfileVelocity=" + this.lowSpeed));
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileVelocity parameter to highSpeed")
    public void raiseProfileVelocity() {
        this.profileVelocity = this.highSpeed;
        this.carrierController.changeProfileVelocity(this.highSpeed);
        FCSLOG.info((Object)(this.name + " new ProfileVelocity=" + this.highSpeed));
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileAcceleration parameter to highAcceleration")
    public void raiseProfileAcceleration() {
        this.carrierController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.highAcceleration);
        FCSLOG.info((Object)(this.name + " new ProfileAcceleration=" + this.highAcceleration));
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileAcceleration parameter to lowAcceleration")
    public void slowProfileAcceleration() {
        this.carrierController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.lowAcceleration);
        FCSLOG.info((Object)(this.name + " new ProfileAcceleration=" + this.lowAcceleration));
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileAcceleration parameter to highAcceleration")
    public void raiseProfileDeceleration() {
        this.carrierController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.highDeceleration);
        FCSLOG.info((Object)(this.name + " new ProfileDeceleration=" + this.highDeceleration));
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileAcceleration parameter to lowAcceleration")
    public void slowProfileDeceleration() {
        this.carrierController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.lowDeceleration);
        FCSLOG.info((Object)(this.name + " new ProfileDeceleration=" + this.lowDeceleration));
    }

    @Command(type=Command.CommandType.ACTION, description="read ProfileVelocity parameter in carrierController CPU")
    public long readProfileVelocity() {
        return this.carrierController.readParameter(EPOSEnumerations.Parameter.ProfileVelocity);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        return this.position == this.absoluteTargetPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update carrier position in reading controller.")
    public void updatePosition() {
        this.position = this.carrierController.readPosition();
        this.publishData();
    }

    @Override
    public void updateCurrent() {
        this.current = this.carrierController.readCurrent();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="To update and display position for end user.Updates carrier position in reading controller and returns it.")
    public int readPosition() {
        this.updatePosition();
        return this.position;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.carrierController.checkFault();
            this.position = this.carrierController.readPosition();
            this.updateCurrent();
            this.loader.updateStateWithSensors();
            this.speed = this.carrierController.readVelocity();
        }
        catch (SDORequestException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, "error in updateStateWithSensorsToCheckIfActionIsCompleted: ", this.name, (Exception)((Object)ex));
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.carrierController.checkFault();
        this.checkProfileVelocity();
        this.checkProfileAcceleration();
        this.checkProfileDeceleration();
        this.carrierController.enableAndWriteAbsolutePosition(this.absoluteTargetPosition);
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " STOPPING action " + action.toString() + " within delay " + delay));
        this.carrierController.disableOperation();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is STOPPING action " + action.toString() + " within delay " + delay));
        this.carrierController.stopPosition();
    }

    private void afterMotion() {
        this.checkPositionSensors();
        this.loader.updateFCSStateToReady();
        this.absoluteTargetPosition = 0;
    }

    public void checkPositionSensors() {
        if (this.absoluteTargetPosition == this.storagePosition && !this.isAtStorage()) {
            throw new FailedCommandException(this.name + ": storage sensors don't confirm carrier position.");
        }
        if (this.absoluteTargetPosition == this.engagedPosition && !this.isAtEngaged()) {
            throw new FailedCommandException(this.name + ": engaged sensors don't confirm carrier position.");
        }
        if (this.absoluteTargetPosition == this.handoffPosition && !this.isAtHandoff()) {
            throw new FailedCommandException(this.name + ": handoff sensors don't confirm carrier position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Check if hardware is ready to be started.")
    public void initializeHardware() {
        this.carrierController.checkInitialized();
        this.loader.updateStateWithSensors();
        try {
            this.updatePosition();
        }
        catch (SDORequestException ex) {
            String msg = this.name + ": couldn't update position";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(this.name, (Throwable)ex);
        }
        if (this.isCarrierAlmostAtPosition(this.handoffPosition) && !this.isAtHandoff()) {
            throw new FcsHardwareException(this.name + ": handoff sensors don't confirm position read on carrierController.");
        }
        if (this.isCarrierAlmostAtPosition(this.engagedPosition) && !this.isAtEngaged()) {
            throw new FcsHardwareException(this.name + ": engaged sensors don't confirm position read on carrierController.");
        }
        if (this.isCarrierAlmostAtPosition(this.storagePosition) && !this.isAtStorage()) {
            throw new FcsHardwareException(this.name + ": storage sensors don't confirm position read on carrierController.");
        }
        this.initialized = true;
        this.loader.updateFCSStateToReady();
    }

    private boolean isCarrierAlmostAtPosition(int position) {
        return this.position > position - this.deltaPosition && this.position < position + this.deltaPosition;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Return a printed list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.isInitialized()) {
            sb.append(" is INITIALIZED.");
        } else {
            sb.append(" is NOT INITIALIZED.");
        }
        return sb.toString();
    }

    public StatusDataPublishedByLoaderCarrier createStatusDataPublishedByLoaderCarrier() {
        StatusDataPublishedByLoaderCarrier status = new StatusDataPublishedByLoaderCarrier();
        status.setPosition(this.position);
        status.setSsiPosition(this.ssiPosition);
        status.setSpeed(this.speed);
        status.setProfileVelocity(this.profileVelocity);
        status.setCurrent(this.current);
        status.setAtHandoff(this.handoffSensors.isOn());
        status.setAtStorage(this.storageSensors.isOn());
        status.setAtEngaged(this.engagedSensors.isOn());
        status.setHandoffInError(this.handoffSensors.isInError());
        status.setStorageInError(this.storageSensors.isInError());
        status.setEngagedInError(this.engagedSensors.isInError());
        status.setControllerInError(this.carrierController.isInError());
        status.setHomingDone(this.initialized);
        return status;
    }

    @Override
    public void publishData() {
        StatusDataPublishedByLoaderCarrier status = this.createStatusDataPublishedByLoaderCarrier();
        KeyValueData kvd = new KeyValueData("loaderCarrier", (Serializable)status);
        this.s.publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.carrierController.isBooted()) {
            this.carrierController.disableOperation();
        }
        FCSLOG.info((Object)(this.name + " is shutdown."));
    }
}

