
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;

/**
 * This class's goal is to create the Objects needed for the GUI and the Status
 * Bus in the package single-filter-test.
 * 
 * @author virieux
 */
public class SftUtils {

    /**
     ******************************************************************************
     ** Methods to create Objects to publish data. To be stored in the trending
     * database and update the GUI.
     * *****************************************************************************
     */
    /**
     *
     * @param basicAutoChanger
     * @return
     */
    public static StatusDataPublishedByBasicAutoChanger createStatusDataPublishedByBasicAutoChanger(
            BasicAutoChanger basicAutoChanger) {
        StatusDataPublishedByBasicAutoChanger status = new StatusDataPublishedByBasicAutoChanger();
        status.setFilterOnTrucksName(basicAutoChanger.getFilterOnTrucksName());
        status.setTrucksEmpty(basicAutoChanger.isTrucksEmpty());
        // status.setTrucksLocation(basicAutoChanger.getLastTrucksLocation());
        status.setRailSensorStandbackXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandback().isOn());
        status.setRailSensorStandbackXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandback().isOn());
        status.setRailSensorStandbyXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandby().isOn());
        status.setRailSensorStandbyXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandby().isOn());
        status.setMovingToStandback(basicAutoChanger.isMovingToStandback());
        status.setMovingToStandby(basicAutoChanger.isMovingToStandby());
        return status;
    }

}
