
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;
import org.lsst.ccs.drivers.canopenjni.BootMessageListener;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.EmergencyMessageListener;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;

/**
 *
 * @author emarin
 */
public class SimuCanOpenInterface implements CanOpenInterface {

    boolean firstSync = true;

    PDOData pdoData = new PDOData();

    @LookupField(strategy=Strategy.SIBLINGS)
    private final List<PieceOfHardware> devices = new ArrayList<>();

    @Override
    public void init(int master, String baud, String busName, int nodeID) {
        //nothing to be done for simulation
    }

    @Override
    public PDOData sync() throws DriverException {
        return pdoData;
    }

    /**
     * change pdoData to simulate a PDO
     * @param cobid
     * @param newValue
     */
    public void simulatePDOData(int cobid, long newValue) {
        pdoData.updatePDO(cobid, newValue);
    }

    @Override
    public int scan() {
        return 0;
    }

    @Override
    public String info(int nodeID) throws DriverException {

        // Finding the device serial number
        for(PieceOfHardware poh : devices) {
            if(nodeID == poh.getNodeID()) {
                return "info,"+Integer.toHexString(nodeID)+",,,,,"+poh.getSerialNB();
            }
        }
        return null;
    }

    @Override
    public void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {

    }

    @Override
    public long rsdo(int nodeId, int index, int subindex) throws DriverException {
        return 0L;
    }

    @Override
    public void ssta(int nodeId) {

    }

    @Override
    public void ssto(int nodeId) {

    }

    @Override
    public void reset(int nodeId) {

    }

    @Override
    public void quit() {

    }

    @Override
    public void init() {

    }

    @Override
    public void start() {

    }

    @Override
    public void stop() {

    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void addReceivedPDO(int cobId) throws DriverException {

    }

    @Override
    public void setEmergencyMessageListener(EmergencyMessageListener eml) throws DriverException {
        // unconfigured
    }

    @Override
    public void setBootMessageListener(BootMessageListener bml) throws DriverException {
        // unconfigured
    }

    @Override
    public void clearReceivedPDOs() throws DriverException {
        // nothing to do here in simualtion
    }

    @Override
    public void setTimeoutMillis(long to) throws DriverException {
        // no timeout to be set in simulation
    }

}
