
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 * This is the driver class for the DAC we use in the FCS test bench:
 * CAN-CBX-AO412
 *
 * @author virieux
 */
// public class CanOpenDAC extends Module implements PieceOfHardware {
public class CanOpenDAC extends CanOpenDevice {

    /**
     * In order to have 1 Volt send to the output we have to write 3210.27287 in
     * decimal.
     *
     */
    public static final double bitOverVolts = 3210.27287;

    /**
     * Build a new CanOpenDAC
     * 
     * @param nodeID
     * @param serialNB
     */
    public CanOpenDAC(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    /**
     * Write a value to the output of the DAC
     *
     * @param inputNB in 0..4
     * @param value
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     * @throws org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException
     */
    public void writeAnalogOutput(int inputNB, int value) {

        if ((inputNB < 1) || (inputNB > 4)) {
            throw new IllegalArgumentException("CAN-CBX-AO412 : input has to be 1..4");
        }

        if (isBooted()) {
            // TODO test the value < 65535
            tcpProxy.writeSDO(nodeID, 0x6411, inputNB, 2, value);

        } else {
            String message = String.format("DAC %s / nodeID=%s is NOT BOOTED", name, nodeID);
            FCSLOG.error(message);

            throw new HardwareNotDetectedException("CanOpenDAC is MISSING", name, this.nodeID, this.serialNB);
        }
    }

}
