
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 *
 * @author virieux
 */
public interface EPOSControllerForCarousel extends EPOSController {

    /**
     * Set PositionSensorType to Absolute encoder SSI (value=4)
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1, description = "Set PositionSensorType to Absolute encoder SSI (value=4)")
    default void setPositionSensorTypeEncoderSSI() {
        FCSLOG.info(getName() + " setting PositionSensorType Absolute encoder SSI");
        writeParameter(EPOSEnumerations.Parameter.PositionSensorType, 4);
    }

    /**
     * Set PositionSensorType to Sinus Incremental Encoder(value=8)
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1, description = "Set PositionSensorType to Sinus Incremental Encoder(value=8)")
    default void setPositionSensorTypeSinusIncrementalEncoder() {
        FCSLOG.info(getName() + " setting PositionSensorType Sinus Incremental Encoder");
        writeParameter(EPOSEnumerations.Parameter.PositionSensorType, 8);
    }

    /**
     *
     * @param position
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING3, description = "Define the actual position as position given as argument.")
    @Override
    default void defineAbsolutePosition(int position) {
        // TODO check why this method overrides the EPOSController's
        // defineAbsolutePosition method.
        FCSLOG.debug(getName() + " Defining Absolute Position:" + position);
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
        this.enable();
        /* start homing */
        this.writeControlWord(0x1F);
        checkHomingDone();
    }



}
