/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForCarousel;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOSCarousel;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class SimuCarouselController
extends CanOpenEPOSCarousel
implements EPOSControllerForCarousel {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private SimuTTC580 hyttc580;
    protected int targetPosition;
    protected int position = 0;
    protected int ssiPosition;
    protected int targetCurrent;
    protected int actualCurrent;
    private int statusWord = 0;

    public SimuCarouselController(int nodeID, String serialNB) {
        super(nodeID, serialNB);
        this.mode = EPOSEnumerations.EposMode.PROFILE_POSITION;
        this.enabledToPublish = true;
    }

    public void setSsiPosition(int ssiPosition) {
        this.ssiPosition = ssiPosition;
        this.position = ssiPosition;
    }

    public void init() {
        this.updateFakePDOData(this.cobid1, 0L);
        this.updateFakePDOData(this.cobid2, 0L);
        this.setSsiPosition(this.carousel.getSocketByName("socket1").getStandbyPosition());
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.")
    public void writeTargetPosition(int absolutePosition) throws FcsHardwareException {
        FCSCst.FCSLOG.info((Object)(this.name + " => carousel is rotating."));
        FCSCst.FCSLOG.info((Object)(this.name + " => initial position=" + this.position));
        FCSCst.FCSLOG.info((Object)(this.name + " => target position=" + absolutePosition));
        int iterNB = 10;
        int initialPosition = this.carousel.getPosition();
        int step = (absolutePosition - initialPosition) / iterNB;
        FCSCst.FCSLOG.info((Object)("step=" + step));
        try {
            for (int i = 1; i < iterNB; ++i) {
                int newPos = initialPosition + i * step;
                this.setSsiPosition(newPos);
                FCSCst.FCSLOG.info((Object)(this.name + " i=" + i + ", position=" + this.position));
                try {
                    Thread.sleep(50L);
                    if (!this.carousel.getHaltRequired().get()) continue;
                    FCSCst.FCSLOG.fine((Object)(this.name + " STOP simulated carousel motion."));
                    return;
                }
                catch (InterruptedException ex) {
                    throw new FcsHardwareException(this.name + " sleep was interrupted.", ex);
                }
            }
            int finalPos = absolutePosition % this.carousel.getFullTurn();
            this.setSsiPosition(finalPos);
            this.simulateSocketSensors(finalPos);
        }
        catch (FcsHardwareException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + " should not raise an Exception:"), (Throwable)ex);
        }
    }

    private void simulateSocketSensors(int pos) {
        System.out.println(this.name + " simulateSocketSensors with position = " + pos);
        this.carousel.getSocketsMap().values().stream().forEach(socket -> {
            if (socket.getStandbyPosition() == pos) {
                this.simulatePosition(pos);
                this.hyttc580.simulateSocketAtStandby((short)socket.getId());
                this.hyttc580.simulateSlaveStatus((short)1);
            } else {
                this.hyttc580.simulateSocketNotAtStandby((short)socket.getId());
                this.hyttc580.simulateSlaveStatusNotAtS((short)2);
            }
            this.tcpProxy.updatePDOData();
            this.carousel.updateState();
        });
    }

    public void updateFakePDOData(int cobid, long newPdo) {
        if (cobid == this.cobid1) {
            this.setPdo1(newPdo);
        } else if (cobid == this.cobid2) {
            this.setPdo2(newPdo);
        }
        ((SimuCanOpenInterface)this.tcpProxy.getCanInterface()).simulatePDOData(cobid, newPdo);
    }

    public void simulatePosition(long pos) {
        System.out.println("simulate carousel position : " + pos);
        long pdo = pos << 32;
        long mask = 0xFFFFFFFFL;
        long newpdo = pdo | this.getPdo1() & mask;
        System.out.println("newpdo1 = " + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="For simulator only : Update position with a position given as argument.")
    public void setPosition(int actualPosition) {
        this.position = actualPosition;
    }

    @Override
    public boolean isTargetReached() {
        return this.position == this.targetPosition || this.actualCurrent == this.targetCurrent;
    }

    @Override
    public boolean isParametersOK() {
        return true;
    }

    @Override
    public void defineAbsolutePosition(int position) {
        this.position = position;
    }

    @Override
    public void writeParameters(EPOSEnumerations.EposMode mode) {
    }

    @Override
    public void writeParameter(EPOSEnumerations.Parameter param, int value) {
        FCSCst.FCSLOG.debug((Object)(this.name + "writeParameter"));
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) {
    }

    @Override
    public void writeCurrent(int aValue) {
        this.actualCurrent = aValue;
    }

    @Override
    public void stopAction() {
    }

    @Override
    public int readPosition() {
        return this.position;
    }

    @Override
    public int readSSIPosition() {
        return this.ssiPosition;
    }

    @Override
    public int readCurrent() {
        return this.actualCurrent;
    }

    @Override
    public EPOSEnumerations.EposMode readMode() {
        return this.mode;
    }

    @Override
    public int readStatusWord() {
        return this.statusWord;
    }

    @Override
    public void quickStop() {
        FCSCst.FCSLOG.finest((Object)(this.name + " quickStop done."));
    }

    @Override
    public int readNumberOfErrors() {
        return 0;
    }

    @Override
    public int readErrorRegister() {
        return 0;
    }

    @Override
    public int[] readErrorHistory() {
        return new int[0];
    }

    @Override
    public String displayErrorHistory() {
        return "No ERROR";
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() {
    }

    @Override
    public String readParameters(EPOSEnumerations.EposMode mode) {
        return this.getName() + ":no parameter to read.";
    }

    @Override
    public void checkParameters(EPOSEnumerations.EposMode aMode) {
    }

    @Override
    public void writeControlWord(int w) {
        FCSCst.FCSLOG.debug((Object)(this.name + " writeControlWord : 0x" + Integer.toHexString(w) + " (in decimal:" + w + ")"));
        this.statusWord = w;
    }

    @Override
    public void switchOnEnableOperation() {
        this.writeControlWord(7);
    }
}

