/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

public class LoaderCanOpenProxy
extends CanOpenProxy {
    public LoaderCanOpenProxy(long hardwareBootTimeout) {
        super(hardwareBootTimeout);
    }

    @Override
    public void start() {
    }

    @Override
    public void postStart() {
    }

    @Override
    public void connectToCANbus() {
        FCSCst.FCSLOG.info((Object)(this.name + " connecting to CANbus. " + this.toString()));
        try {
            this.canInterface.init(this.master, this.baud, this.busName, this.masterNodeID);
            this.canbusConnected = true;
        }
        catch (DriverException ex) {
            String msg = this.name + " could not init canInterface. " + this.toString();
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, msg, (Exception)((Object)ex));
        }
        try {
            this.canInterface.scan();
            Thread.sleep(this.hardwareBootTimeout);
        }
        catch (InterruptedException | DriverException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " could not scan CANbus." + this.toString(), (Exception)ex);
        }
    }
}

