/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.List;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class FcsMain
extends MainModule {
    private static final long serialVersionUID = 7669526660659959402L;
    private final BridgeToHardware bridgeToLoader;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FilterManager filterManager;

    public FcsMain(BridgeToHardware bridge, BridgeToHardware bridgeToLoader) {
        super(bridge);
        this.bridgeToLoader = bridgeToLoader;
    }

    public void init() {
        ((AgentPropertiesService)this.subs.getAgentService(AgentPropertiesService.class)).setAgentProperty("org.lsst.ccs.subsystem.fcs.wholefcs", "fcs");
    }

    @Override
    public void updateFCSStateToReady() {
        if (this.carousel.isInitialized() && this.autochanger.isInitialized() && this.loader.isInitialized()) {
            this.updateAgentState(FcsEnumerations.FilterState.READY, FcsEnumerations.FilterReadinessState.READY);
        }
    }

    public String getOnlineFilterName() {
        if (this.autochanger.isHoldingFilter()) {
            return this.autochanger.getFilterOnTrucksName();
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns the name of the filter which is at ONLINE.")
    public String printFilterONLINEName() {
        if (this.getOnlineFilterName() != null) {
            return this.getOnlineFilterName();
        }
        return "NONE";
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="returns the filter which has for name the String given as argument.")
    public Filter getFilterByName(String filterName) {
        return this.filterManager.getFilterByName(filterName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the changer is connected.")
    public boolean isChangerConnected() {
        return this.bridge.isReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected.")
    public boolean isLoaderConnected() {
        return this.bridgeToLoader.isReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the changer is ready.")
    public boolean isChangerReady() {
        return this.bridge.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the loader is ready.")
    public boolean isLoaderReady() {
        return this.bridgeToLoader.allDevicesBooted();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Disconnect the loader hardware.")
    public void disconnectLoader() {
        this.bridgeToLoader.disconnectHardware();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Connect the loader hardware.")
    public void connectLoader() {
        this.bridgeToLoader.connectHardware();
    }

    public void checkFilterName(String aName) {
        this.filterManager.checkFilterName(aName);
    }

    public void checkAutochangerTrucksLocation() {
        this.autochanger.getAutochangerTrucks().updatePosition();
        if (this.autochanger.getAutochangerTrucks().isAtOnline() && this.autochanger.isHoldingFilter() && this.autochanger.getOnlineClamps().isLocked()) {
            String filterName = this.filterManager.getFilterNameByID(this.autochanger.getFilterID());
            this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_" + filterName.substring(6, filterName.length())), FcsEnumerations.FilterReadinessState.READY);
        } else if (this.autochanger.isHoldingFilter() && this.autochanger.getOnlineClamps().isLocked()) {
            this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_NONE"), FcsEnumerations.FilterReadinessState.READY);
        } else {
            this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_NONE"), FcsEnumerations.FilterReadinessState.NOT_READY);
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the list of LOADER CANopen hardware that this subsystem manages.")
    public List<String> listLoaderHardwareNames() {
        return this.bridgeToLoader.listHardwareNames();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Move filter to ONLINE position.", alias="setFilterONLINE", timeout=60)
    public void setFilter(int filterID) {
        FCSCst.FCSLOG.info((Object)(this.name + ": filter ID to move is " + filterID));
        if (!this.filterManager.containsFilterID(filterID)) {
            throw new IllegalArgumentException(this.name + ": Unknown filter id : " + filterID);
        }
        if (this.autochanger.isFilterONLINE(filterID)) {
            throw new RejectedCommandException("filter " + filterID + " is already at ONLINE.");
        }
        if (this.carousel.isFilterOnCarousel(filterID)) {
            FCSCst.FCSLOG.info((Object)(this.name + ":filter " + filterID + " is on carousel."));
            this.carouselMoveFilterToStandby(filterID);
        } else if (this.autochanger.isFilterOnAC(filterID)) {
            FCSCst.FCSLOG.info((Object)(this.name + ": filter " + filterID + " is on autochanger."));
            this.autochangerMoveFilterToOnline(filterID);
        } else {
            throw new RejectedCommandException(this.name + ": can't setFilter " + filterID + " ONLINE because filter is not in camera");
        }
        String filterName = this.filterManager.getFilterNameByID(filterID);
        String letter = filterName.substring(6, filterName.length());
        this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_" + letter), FcsEnumerations.FilterReadinessState.READY);
        FCSCst.FCSLOG.info((Object)("filter " + filterID + " is ONLINE."));
    }

    public boolean isInCamera(int filterID) {
        return this.carousel.isFilterOnCarousel(filterID) || this.autochanger.isFilterOnAC(filterID);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Move filter to ONLINE position.", alias="setFilterONLINE", timeout=60)
    private void doMoveFilterONLINE(int filterID) {
        if (this.carousel.isFilterOnCarousel(filterID)) {
            FCSCst.FCSLOG.info((Object)(this.name + ":filter " + filterID + " is on carousel."));
            this.carouselMoveFilterToStandby(filterID);
        } else if (this.autochanger.isFilterOnAC(filterID)) {
            FCSCst.FCSLOG.info((Object)(this.name + ": filter " + filterID + " is on autochanger."));
            this.autochangerMoveFilterToOnline(filterID);
        }
    }

    public void setFilterBis(int filterID) {
        this.subs.helper().precondition(this.filterManager.containsFilterID(filterID), "%s: Unknown filter id : %s", new Object[]{this.name, filterID}).precondition(!this.autochanger.isFilterONLINE(filterID), "filter %s is already at ONLINE.", new Object[]{filterID}).precondition(this.isInCamera(filterID), "filter %s in out of camera", new Object[]{filterID}).action(() -> this.doMoveFilterONLINE(filterID));
        String filterName = this.filterManager.getFilterNameByID(filterID);
        String letter = filterName.substring(6, filterName.length());
        this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_" + letter), FcsEnumerations.FilterReadinessState.READY);
        FCSCst.FCSLOG.info((Object)("filter " + filterID + " is ONLINE."));
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="change subsystem state.")
    public void changeState(String state) {
        this.updateAgentState(FcsEnumerations.FilterState.valueOf(state), FcsEnumerations.FilterReadinessState.READY);
        FCSCst.FCSLOG.fine((Object)("SUBSYSTEM STATE=" + this.isInState(FcsEnumerations.FilterState.valueOf(state))));
    }

    private void carouselMoveFilterToStandby(int filterID) {
        if (this.carousel.isAtStandby(filterID)) {
            throw new RejectedCommandException(this.name + " : filter " + filterID + " is at STANDBY position. No need to rotate carousel.");
        }
        FCSCst.FCSLOG.info((Object)(this.name + ": filter" + filterID + " is on carousel but not at STANDBY position. Need to rotate carousel."));
        if (!this.autochanger.isEmpty() && this.autochanger.getFilterID() != filterID) {
            FCSCst.FCSLOG.info((Object)(this.autochanger.getFilterOnTrucksName() + " is on autochanger. It has to be stored on carousel."));
            if (!this.autochanger.getAutochangerTrucks().isAtOnline() && !this.autochanger.getAutochangerTrucks().isAtHandoff()) {
                this.autochanger.getAutochangerTrucks().goToHandOff();
            }
            this.carousel.rotateEmptySocketAtStandby();
            this.autochangerStoreFilterOnCarousel();
        }
        this.autochanger.getAutochangerTrucks().goToHandOff();
        FCSCst.FCSLOG.info((Object)(this.name + ": can be rotated to STANDBY to set filter " + filterID));
        this.carousel.rotateSocketToStandby(this.carousel.getFilterSocket(filterID).getName());
    }

    @Deprecated
    private void autochangerMoveFilterToOnline(int filterID) {
        if (!this.autochanger.isEmpty() && !this.autochanger.isFilterOnAC(filterID)) {
            String msg = this.name + ": autochanger is loaded with another filter than " + filterID;
            FCSCst.FCSLOG.error((Object)msg);
            throw new FailedCommandException(msg);
        }
        if (this.autochanger.isEmpty() && this.carousel.isAtStandby(filterID)) {
            FCSCst.FCSLOG.info((Object)(this.name + ": filter " + filterID + " is at STANDBY"));
            this.autochanger.getAutochangerTrucks().goToStandby();
            this.autochanger.getLatches().close();
            if (this.autochanger.getFilterID() != filterID) {
                throw new FailedCommandException("FilterID at STANDBY is not consistant with filterID in FCS memory.");
            }
            this.carousel.unlockClamps();
        } else if (this.autochanger.getFilterID() == filterID) {
            FCSCst.FCSLOG.info((Object)(this.name + ": filter " + filterID + " is already on autochanger Trucks."));
        }
        this.autochanger.getAutochangerTrucks().goToOnline();
        this.autochanger.getOnlineClamps().closeAndLockClamps();
        this.carousel.releaseClamps();
    }

    private void autochangerStoreFilterOnCarousel() {
        if (this.carousel.isReadyToGrabAFilterAtStandby()) {
            if (this.autochanger.getAutochangerTrucks().isAtOnline() && this.autochanger.getOnlineClamps().isLocked()) {
                this.autochanger.getOnlineClamps().unlockAndOpenClamps();
            }
        } else {
            throw new FcsHardwareException(this.name + " autochanger can't store filter at STANDBY because carousel clamps are not ready to receive a filter.");
        }
        this.autochanger.getAutochangerTrucks().goToStandby();
        this.autochanger.ungrabFilterAtStandby();
    }

    public void loadFilter(int filterID) {
        if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
            throw new RejectedCommandException(this.name + " can't load a filter when socket at STANDBY position is not empty and ready.");
        }
        if (!this.autochanger.getAutochangerTrucks().isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new RejectedCommandException(this.name + " autochanger is not empty at STANDOFF position; can't load a filter.");
        }
        this.connectLoader();
        if (!this.loader.isHoldingFilter() || !this.loader.getCarrier().isAtStorage()) {
            throw new RejectedCommandException(this.name + " can't load filter because loader is not holding a filter at storage position.");
        }
        this.loader.getCarrier().goToHandOff();
        this.autochanger.getAutochangerTrucks().goToHandOff();
        this.autochanger.grabFilterAtHandoff(filterID);
        this.loader.getClamp().open();
        this.loader.getCarrier().goToStorage();
        this.disconnectLoader();
    }

    public void unloadFilter(int filterID) {
        if (this.carousel.isFilterOnCarousel(filterID)) {
            throw new RejectedCommandException(this.name + " : filter " + filterID + " is not on the carousel, can't unload it.");
        }
        if (!this.carousel.isAtStandby(filterID)) {
            throw new RejectedCommandException(this.name + " : filter " + filterID + " is not on the carousel at standby position, can't unload it.");
        }
        if (!this.autochanger.getAutochangerTrucks().isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new RejectedCommandException(this.name + " autochanger is not empty at STANDOFF position; can't unload a filter.");
        }
        this.connectLoader();
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move empty to standby position.");
        this.autochanger.getAutochangerTrucks().goToStandby();
        this.autochanger.getLatches().close();
        FCSCst.FCSLOG.info((Object)"=======> Carousel is ungrabbing filter at standby position.");
        this.carousel.unlockClamps();
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move loaded with the filter to handoff position.");
        this.autochanger.moveFilterToHandoff(filterID);
        FCSCst.FCSLOG.info((Object)"=======> Carousel about to release Clamps.");
        this.carousel.releaseClamps();
        this.loader.getCarrier().goToHandOff();
        this.loader.getClamp().close();
        this.autochanger.ungrabFilterAtHandoff(filterID);
        this.loader.getClamp().clamp();
        this.loader.getCarrier().goToStorage();
        this.disconnectLoader();
    }

    @Override
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        this.carousel.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
        if (this.carousel.isAtStandby()) {
            this.carousel.getSocketAtStandby().updateFilterID();
        }
        if (this.loader.isConnectedOnCamera() && this.loader.isCANbusConnected()) {
            this.loader.updateStateWithSensors();
        }
    }

    public void postStart() {
        this.checkAutochangerTrucksLocation();
    }
}

