/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.FakeFilterHolder;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;

public class AutochangerMain
extends MainModule {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Autochanger autochanger;
    private FakeFilterHolder carousel;
    private FakeFilterHolder loader;

    public AutochangerMain(BridgeToHardware bridge) {
        super(bridge);
    }

    public void init() {
        ((AgentPropertiesService)this.subs.getAgentService(AgentPropertiesService.class)).setAgentProperty("org.lsst.ccs.subsystem.fcs.autochanger", "autochanger");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update autochanger state in reading the sensors.")
    public void updateStateWithSensors() {
        this.autochanger.updateStateWithSensors();
        this.carousel.updateStateWithSensors();
        this.loader.updateStateWithSensors();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.autochanger.isInitialized() && this.isInState((Enum)AlertState.ALARM)) {
            this.updateAgentState(FcsEnumerations.FilterState.READY, FcsEnumerations.FilterReadinessState.READY);
        }
    }
}

