/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnDevice;

public class Inclinometer
implements SensorPluggedOnDevice {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    @LookupName
    private String name = "unset";
    @ConfigurationParameter
    private int byteNumero;
    @ConfigurationParameter
    private String deviceName;
    private double inclinaison;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public int getByteNumero() {
        return this.byteNumero;
    }

    @Override
    public void updateValue(int newValue) {
        FCSCst.FCSLOG.fine((Object)(this.name + " uptating inclinaison"));
        this.inclinaison = Inclinometer.convertVoltage2Degree(newValue / 10);
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns inclinaison value in degrees. Doesn't read again CANopen device.")
    public double getInclinaison() {
        return this.inclinaison;
    }

    private static double convertVoltage2Degree(int voltage) {
        if (voltage < 0 || voltage > 5) {
            throw new IllegalArgumentException(voltage + ": bad value for voltage. Voltage has to be between 0 and 5");
        }
        double sin_angle = ((double)voltage - 2.5) / 11.52;
        return Math.toDegrees(Math.asin(sin_angle));
    }

    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)Double.valueOf(this.inclinaison)));
    }
}

