/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;

public class SimuAutochangerLinearRailControllerTest {
    private static Subsystem subs;
    private static SimuAutochangerLinearRailController masterController;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***********************************************");
        System.out.println("  TESTS OF SimuAutochangerLinearRailController");
        System.out.println("***********************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        subs = BootUtils.getSubsystemFromFile((String)"autochanger", (String)"");
        subs.startAgent();
        ((AgentStateService)subs.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = subs.getComponentLookup();
        masterController = (SimuAutochangerLinearRailController)lookup.getComponentByPath("linearRailMasterController");
    }

    @AfterClass
    public static void after() throws Exception {
        subs.shutdownAgent();
        System.out.println("********* end of SimuAutochangerLinearRailController tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSetSsiPosition() {
        System.out.println("setSsiPosition");
        int ssiPosition = 6532;
        masterController.setSsiPosition(ssiPosition);
        Assert.assertEquals((String)("masterController.readSSIPosition() should return " + ssiPosition), (long)ssiPosition, (long)masterController.readSSIPosition());
    }

    public void testGetEncoderRibbonMinValue() {
        System.out.println("getEncoderRibbonMinValue");
        int expResult = 8161299;
        int result = masterController.getEncoderRibbonMinValue();
        Assert.assertEquals((String)("masterController.getEncoderRibbonMinValue() should return " + expResult), (long)expResult, (long)result);
    }

    @Test
    public void testWriteTargetPosition() {
        System.out.println("writeTargetPosition");
        int positionToReached = 2500;
        masterController.writeTargetPosition(positionToReached);
        Assert.assertEquals((String)("masterController.readPosition() should be " + positionToReached), (long)masterController.readPosition(), (long)positionToReached);
    }

    @Test
    public void testHoming() {
        System.out.println("homing");
        masterController.homing();
        Assert.assertTrue((String)"homing is done", (boolean)masterController.isHomingDone());
    }

    @Test
    public void testIsHomingDone() {
        System.out.println("isHomingDone");
        Assert.assertTrue((String)"Homing is done in postStart of 2 Trucks.", (boolean)masterController.isHomingDone());
    }

    @Test
    public void testActivateBrakeAndDisable() {
        System.out.println("activateBrakeAndDisable");
        masterController.activateBrakeAndDisable();
        Assert.assertTrue((String)"masterController brake should be activated", (boolean)masterController.isBrakeActivated());
        Assert.assertFalse((String)"masterController should be disabled", (boolean)masterController.isEnabled());
    }

    @Test
    public void testEnableAndReleaseBrake() {
        System.out.println("enableAndReleaseBrake");
        masterController.enableAndReleaseBrake();
        Assert.assertFalse((String)"masterController brake is no more activated", (boolean)masterController.isBrakeActivated());
        Assert.assertTrue((String)"masterController is enabled", (boolean)masterController.isEnabled());
    }

    @Test
    public void testDoReleaseBrake() {
        System.out.println("doReleaseBrake");
        masterController.doReleaseBrake();
        Assert.assertFalse((String)"masterController brake should be released", (boolean)masterController.isBrakeActivated());
    }
}

