
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.LookupName;

/**
 *
 * @author virieux
 */
public abstract class SftTruckMotor {

    @LookupName
    protected String name;

    private TruckMotorListener truckListener;
    /*
     * FOR THE GUI
     *
     */
    private volatile boolean movingToStandby;
    private volatile boolean movingToStandback;

    public boolean isMovingToStandback() {
        return movingToStandback;
    }

    public boolean isMovingToStandby() {
        return movingToStandby;
    }

    public void setMovingToStandback(boolean movingToStandback) {
        this.movingToStandback = movingToStandback;
        truckListener.onTruckEvent();
    }

    public void setMovingToStandby(boolean movingToStandby) {
        this.movingToStandby = movingToStandby;
        truckListener.onTruckEvent();
    }

    public abstract void moveToStandback();

    public abstract void moveToStandby();

    public abstract void off();

    void setTruckMotorListener(TruckMotorListener l) {
        this.truckListener = l;
    }

}
