
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;

/**
 * A model for the carousel sensors.
 *
 * @author virieux
 */
public class CarouselSensor implements SensorPluggedOnTTC580 {

    @LookupName
    private String name = "unset";

    /**
     * name of the CAN OPEN device this sensor is plugged on. carousel sensors are
     * plugged on a ttc580.
     */
    @ConfigurationParameter
    protected String deviceName;

    /**
     * numeric value for this sensor
     */
    int value;

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getDeviceName() {
        return deviceName;
    }

    @Override
    @Command(type = Command.CommandType.QUERY, description = "return sensor value, in mV")
    public int getValue() {
        return value;
    }

    /**
     * update value from value read on device
     *
     * @param newValue
     */
    @Override
    public void updateValue(int newValue) {
        value = newValue;
    }
}
