/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.time.Duration;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerWithBrake;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class AutochangerTruck
implements MovedByEPOSController,
HasLifecycle,
AlertRaiser {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem s;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupName
    private String name;
    public static final String CURRENT_MONITOR_TASK_NAME = "-monitorCurrent";
    private final ComplementarySensors handoffPositionSensors;
    private final ComplementarySensors onlinePositionSensors;
    private final ComplementarySensors standbyPositionSensors;
    private final EPOSControllerWithBrake controller;
    private int position;
    private int current;
    private int averageCurrent;
    private int followingError;
    private int averageVelocity;

    public AutochangerTruck(EPOSControllerWithBrake controller, ComplementarySensors handoffPositionSensors, ComplementarySensors onlinePositionSensors, ComplementarySensors standbyPositionSensors) {
        this.controller = controller;
        this.handoffPositionSensors = handoffPositionSensors;
        this.onlinePositionSensors = onlinePositionSensors;
        this.standbyPositionSensors = standbyPositionSensors;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.s;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    public void build() {
        FCSCst.FCSLOG.info((Object)(this.name + " is controlled by " + this.controller.getName()));
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(this.name + CURRENT_MONITOR_TASK_NAME, this::monitorCurrent).withIsFixedRate(true).withLogLevel(Level.WARNING).withPeriod(Duration.ofSeconds(60L)));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if truck is at HANDOFF position.")
    public boolean isAtHandoff() {
        return this.handoffPositionSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if truck is at ONLINE position.")
    public boolean isAtOnline() {
        return this.onlinePositionSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if truck is at STANDBY position.")
    public boolean isAtStandby() {
        return this.standbyPositionSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Standby are equal. Doesn't read again sensors.")
    public boolean isStandbySensorsInError() {
        return this.standbyPositionSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Handoff are equal.Doesn't read again sensors.")
    public boolean isHandoffSensorsInError() {
        return this.handoffPositionSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Online are equal.Doesn't read again sensors.")
    public boolean isOnlineSensorsInError() {
        return this.onlinePositionSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if position sensors are in error.Doesn't read again sensors.")
    public boolean isPositionSensorsInError() {
        return this.isOnlineSensorsInError() || this.isHandoffSensorsInError() || this.isStandbySensorsInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return truck position.")
    public int getPosition() {
        return this.position;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return controller name.")
    public String getControllerName() {
        return this.controller.getName();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update truck position in reading controller.")
    public void updatePosition() {
        try {
            this.position = this.controller.readPosition();
            this.publishData();
        }
        catch (SDORequestException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, "=> ERROR IN READING CONTROLLER:", this.controller.getName(), ex);
        }
    }

    @Override
    public void updateCurrent() {
        if (this.controller.isBooted()) {
            try {
                this.current = this.controller.readCurrent();
                this.averageCurrent = this.controller.readCurrentAverageValue();
                this.followingError = this.controller.readFollowingError();
                this.averageVelocity = this.controller.readVelocity();
                this.publishData();
            }
            catch (SDORequestException ex) {
                this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, " could not updateCurrent", this.controller.getName(), ex);
            }
        }
    }

    public StatusDataPublishedByAutochangerTruck createStatusDataPublishedByAutoChangerTruck() {
        StatusDataPublishedByAutochangerTruck s = new StatusDataPublishedByAutochangerTruck();
        s.setControllerName(this.getControllerName());
        s.setHandoffInError(this.handoffPositionSensors.isInError());
        s.setOnlineInError(this.onlinePositionSensors.isInError());
        s.setStandbyInError(this.standbyPositionSensors.isInError());
        s.setHandoffSensorValue(this.handoffPositionSensors.isOn());
        s.setOnlineSensorValue(this.onlinePositionSensors.isOn());
        s.setStandbySensorValue(this.standbyPositionSensors.isOn());
        s.setPosition(this.position);
        s.setCurrent(this.current);
        s.setAverageCurrent(this.averageCurrent);
        s.setAverageVelocity(this.averageVelocity);
        s.setFollowingError(this.followingError);
        s.setControllerInFault(this.controller.isInError());
        return s;
    }

    @Override
    public void publishData() {
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByAutoChangerTruck()));
    }
}

