/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public interface EPOSControllerWithBrake
extends EPOSController {
    public void activateBrakeAndDisable();

    default public void doReleaseBrake() {
        int val = (int)this.readParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2one(val, 15));
        this.publishData();
        FCSCst.FCSLOG.info((Object)(this.getName() + ": brake released."));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Enable and release brake to permit motion. Not allowed in MASTER_ENCODER mode.")
    default public void enableAndReleaseBrake() {
        if (this.isInMode(EPOSEnumerations.EposMode.MASTER_ENCODER)) {
            throw new RejectedCommandException(this.getName() + " brake can't be released when in mode MASTER_ENCODER");
        }
        this.enable();
        this.doReleaseBrake();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Activate brake to prevent motion.")
    default public void activateBrake() {
        int val = (int)this.readParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState, FcsUtils.force2zero(val, 15));
        this.publishData();
        FCSCst.FCSLOG.info((Object)(this.getName() + ": brake activated."));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return true if brake if activated.")
    default public boolean isBrakeActivated() {
        int digitalOutput = (int)this.readParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityState);
        return (digitalOutput >> 15 & 1) == 0;
    }

    @Override
    default public StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController() {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController(this.isBooted(), this.isInitialized());
        status.setInError(this.isInError());
        status.setErrorRegister(this.getErrorRegister());
        status.setErrorHistory(this.getErrorHistory());
        status.setEnabled(this.isEnabledToPublish());
        status.setMode(this.getMode());
        status.setControllerWithBrake(true);
        status.setBrakeActivated(this.isBrakeActivated());
        return status;
    }
}

