/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.errors.ClampsOrLatchesDisagreeException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.TTC580Utils;

public class CarouselSocket
extends MobileItem
implements ClearAlertHandler {
    private int id;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule mainModule;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Carousel carousel;
    private CarouselClamp clampXminus;
    private CarouselClamp clampXplus;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*clampXminusController")
    private EPOSController clampXminusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*clampXplusController")
    private EPOSController clampXplusController;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private SensorPluggedOnTTC580 slaveModuleSensor;
    private FcsEnumerations.SlaveModuleStatus slaveModuleStatus;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*autochanger")
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private FilterManager filterManager;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService persistenceService;
    private final boolean loadFilterLocationAtStartup = true;
    private final boolean loadFilterLocationAtShutdown = true;
    @ConfigurationParameter(range="-4500000..4500000")
    private int standbyPosition;
    @Persist
    private int filterID;
    private volatile FcsEnumerations.FilterClampState clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
    private long timeoutForUnlocking = 4000L;
    private long timeoutForReleasing = 4000L;

    public CarouselSocket(int id, CarouselClamp clampXminus, CarouselClamp clampXplus, int standbyPosition) {
        this.id = id;
        this.clampXminus = clampXminus;
        this.clampXplus = clampXplus;
        this.standbyPosition = standbyPosition;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CarouselClamp getClampXminus() {
        return this.clampXminus;
    }

    public void setClampXminus(CarouselClamp clampXminus) {
        this.clampXminus = clampXminus;
    }

    public CarouselClamp getClampXplus() {
        return this.clampXplus;
    }

    public void setClampXplus(CarouselClamp clampXplus) {
        this.clampXplus = clampXplus;
    }

    public int getFilterID() {
        return this.filterID;
    }

    public String getFilterName() {
        if (this.filterID == 0) {
            return "NO FILTER";
        }
        return this.filterManager.getFilterNameByID(this.filterID);
    }

    public void setFilterID(int filterID) {
        this.filterID = filterID;
        this.publishData();
    }

    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    @Command
    public FcsEnumerations.SlaveModuleStatus getSlaveModuleStatus() {
        return this.slaveModuleStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this socket is at STANDBY position on the carousel.")
    public boolean isAtStandby() {
        return Math.abs(this.standbyPosition - this.carousel.getPosition()) <= 1000 && this.carousel.getSocketAtStandbyID() == this.id;
    }

    public void init() {
        this.persistenceService.setAutomatic(true, true);
        this.timeoutForReleasing = Math.max(this.clampXminus.timeoutForReleasing, this.clampXplus.timeoutForReleasing);
        this.timeoutForUnlocking = Math.max(this.clampXminus.timeoutForUnlocking, this.clampXplus.timeoutForUnlocking);
        this.clampXminus.setController(this.clampXminusController);
        this.clampXplus.setController(this.clampXplusController);
    }

    private boolean isAutochangerHoldingFilter() {
        return this.autochanger.isAtStandby() && this.autochanger.isHoldingFilter();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.mainModule.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return clamps state - doesn't read again sensors.")
    public FcsEnumerations.FilterClampState getClampsState() {
        return this.clampsState;
    }

    @Command
    public void updateState() {
        FCSLOG.info((Object)(this.name + " updating state....."));
        long beginTime = System.currentTimeMillis();
        this.slaveModuleStatus = this.slaveModuleSensor.getValue() >= 1 && this.slaveModuleSensor.getValue() <= 7 ? FcsEnumerations.SlaveModuleStatus.getStatusByCode((int)this.slaveModuleSensor.getValue()) : FcsEnumerations.SlaveModuleStatus.UNKNOWN_STATUS;
        if (this.slaveModuleSensor.getValue() < 4 && this.slaveModuleSensor.getValue() > 0) {
            this.updateClampsState();
        } else {
            this.clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " slave module status = " + this.slaveModuleSensor.getValue() + " => " + this.slaveModuleStatus, this.name);
        }
        this.publishData();
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateState duration = " + duration));
    }

    private void updateClampsState() {
        boolean inError;
        this.clampXminus.updateState();
        this.clampXplus.updateState();
        boolean bl = inError = this.clampXminus.getClampState() == FcsEnumerations.FilterClampState.ERROR || this.clampXplus.getClampState() == FcsEnumerations.FilterClampState.ERROR;
        if (this.clampXminus.getClampState() == this.clampXplus.getClampState()) {
            this.clampsState = this.clampXminus.getClampState();
            FCSLOG.info((Object)(this.name + " : clamps are updated"));
        } else if (this.clampXminus.getClampState() == FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY && this.clampXplus.getClampState() == FcsEnumerations.FilterClampState.READYTOCLAMP) {
            this.clampsState = this.clampXminus.isReleased() && this.clampXplus.isReleased() ? FcsEnumerations.FilterClampState.READYTOCLAMP : FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
        } else if (!inError) {
            this.clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
        } else {
            this.clampsState = FcsEnumerations.FilterClampState.ERROR;
            String msg = this.name + ": clampState at Xminus side is different from clampState at Xplus side. ";
            msg = msg + this.clampXminus.getName() + " state=" + this.clampXminus.getClampState() + " ";
            msg = msg + this.clampXplus.getName() + " state=" + this.clampXplus.getClampState();
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, msg, this.name);
        }
    }

    public void updateFilterID() {
        if (this.isEmpty()) {
            this.filterID = 0;
        } else if (this.autochanger.isAtStandby()) {
            this.filterID = this.autochanger.getFilterID();
        }
    }

    public void updateOffsetPresenceSensor(long sdo) {
        this.clampXminus.setFilterPresenceValueA(TTC580Utils.getOffsetPresenceSensorXminus(sdo));
        this.clampXplus.setFilterPresenceValueA(TTC580Utils.getOffsetPresenceSensorXplus(sdo));
    }

    public void updateOffsetLockSensor(long sdo) {
        this.clampXminus.setLockSensorValueA(TTC580Utils.getOffsetLockSensorXminus(sdo));
        this.clampXplus.setLockSensorValueA(TTC580Utils.getOffsetLockSensorXplus(sdo));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is no filter in the socket.")
    public boolean isEmpty() {
        return this.clampXminus.getFilterPresenceStatus() == FcsEnumerations.FilterPresenceStatus.NOFILTER && this.clampXplus.getFilterPresenceStatus() == FcsEnumerations.FilterPresenceStatus.NOFILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is a filter in the socket and the clampsare LOCKED.")
    public boolean isClampedOnFilter() {
        return this.clampsState == FcsEnumerations.FilterClampState.CLAMPEDONFILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is a filter in the socket and the clampsare UNLOCKED.")
    public boolean isUnclampedOnFilter() {
        return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is NO filter in the socket and the clampsare UNLOCKED.")
    public boolean isUnclampedEmpty() {
        return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if this socket is ready to clamp a filter.")
    public boolean isReadyToClamp() {
        return this.clampsState == FcsEnumerations.FilterClampState.READYTOCLAMP;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release the 2 clamps of this socket if the socket is at STANDBY position.")
    public void releaseClamps() {
        this.updateState();
        FCSLOG.info((Object)("Checking conditions for release clamp " + this.name + " on socket at standby position."));
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " is NOT AT STANDBY - can't unlock clamps.");
        }
        if (this.clampsState != FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY) {
            FCSLOG.fine((Object)(this.name + " clampsState=" + this.clampsState));
            FCSLOG.fine((Object)(this.clampXminus.getName() + " clampState=" + this.clampXminus.getClampState()));
            FCSLOG.finest((Object)(this.clampXminus.getName() + " lockStatus=" + this.clampXminus.getLockStatus()));
            FCSLOG.finest((Object)(this.clampXminus.getName() + " filterPresenceStatus=" + this.clampXminus.getFilterPresenceStatus()));
            FCSLOG.fine((Object)(this.clampXplus.getName() + " clampState=" + this.clampXplus.getClampState()));
            FCSLOG.finest((Object)(this.clampXplus.getName() + " lockStatus=" + this.clampXplus.getLockStatus()));
            FCSLOG.finest((Object)(this.clampXplus.getName() + " filterPresenceStatus=" + this.clampXplus.getFilterPresenceStatus()));
            throw new RejectedCommandException(this.name + ": Can't release clamps if socket is not UNCLAMPED and EMPTY. ");
        }
        FCSLOG.info((Object)(this.name + ": Releasing clamps at standby position."));
        this.executeAction(FcsEnumerations.MobileItemAction.RELEASECLAMPS, this.timeoutForReleasing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock the 2 clamps of this socket if the socket is at STANDBY position.")
    public void unlockClamps() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " is NOT AT STANDBY - can't unlock clamps.");
        }
        this.updateState();
        if (this.clampsState != FcsEnumerations.FilterClampState.CLAMPEDONFILTER) {
            throw new RejectedCommandException(this.name + ":Can't unlock clamps if isn't clamped on filter.");
        }
        if (!this.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException("CANNOT UNLOCK CLAMPS if FILTER is not HELD by autochanger.");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.UNLOCKCLAMPS, this.timeoutForUnlocking);
        FCSLOG.info((Object)"Just about to remove filter from carousel (software update)");
        this.filterID = 0;
        FCSLOG.info((Object)"Command unlockClamps completed");
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns a String representation of a CarouselSocket.")
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(",FilterID in socket : ");
        sb.append(this.filterID).append("\n");
        return sb.toString();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCKCLAMPS) {
            return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
        }
        if (action == FcsEnumerations.MobileItemAction.RELEASECLAMPS) {
            return this.clampsState == FcsEnumerations.FilterClampState.READYTOCLAMP;
        }
        throw new IllegalArgumentException("Action on clamps on socket must be UNLOCKCLAMPS or RELEASECLAMPS");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.updateState();
        }
        catch (ClampsOrLatchesDisagreeException ex) {
            String msg = this.name + " a little delai between the update of the 2 clamps : have to wait ...";
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, msg, this.name, (Exception)((Object)ex));
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCKCLAMPS) {
            this.clampXminusController.enable();
            this.clampXplusController.enable();
            this.clampXminusController.writeCurrent(this.clampXminus.getCurrentToUnlock());
            this.clampXplusController.writeCurrent(this.clampXplus.getCurrentToUnlock());
        } else if (action == FcsEnumerations.MobileItemAction.RELEASECLAMPS) {
            this.clampXminusController.disableOperation();
            this.clampXplusController.disableOperation();
        } else {
            throw new IllegalArgumentException("Action on clamps on socket must be UNLOCKCLAMPS or RELEASECLAMPS");
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)(this.name + " stopAction : nothing to be done."));
    }

    @Override
    public void publishData() {
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByCarouselSocket()));
    }

    public StatusDataPublishedByCarouselSocket createStatusDataPublishedByCarouselSocket() {
        StatusDataPublishedByCarouselSocket status = new StatusDataPublishedByCarouselSocket();
        status.setAtStandby(this.isAtStandby());
        status.setSlaveStatus(this.slaveModuleStatus);
        status.setClampsState(this.clampsState);
        status.setEmpty(this.isEmpty());
        status.setFilterID(this.filterID);
        status.setSocketID(this.id);
        status.setFilterName(this.getFilterName());
        return status;
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        String alertId = this.name + this.getAlertSeparator() + FcsEnumerations.FcsAlert.CA_SENSOR_ERROR.name();
        if (alert.getAlertId().equals(alertId)) {
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    @Override
    public void shutdown() {
        this.persistenceService.persistNow();
    }
}

