import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.drivers.canopenjni.*
import org.lsst.ccs.drivers.canopenjni.rmi.*
import org.lsst.ccs.description.groovy.CCSBuilder

// testbenchAPC with 1 CANbus and 2 CANopen devices
CCSBuilder builder = ["testbenchAPC"]


builder.
    main ( APCTestBenchMain,
        bridge:ref("tcpProxy"),
        thermometer:ref("thermometer"),
        led:ref("led"),
        fakeLed:ref("fakeLed"),
        fakeSensor:ref("fakeSensor"))

//begin description of Main submodules
{       
    // tcp Proxy
    tcpProxy (CanOpenProxy, hardwareBootTimeout:1000) {
        
        canInterface(CanOpenCommands, coi:new CanFestivalJNI())
        
        // can open devices for changer devices (autochanger and carousel)
        ao412 (CanOpenDAC, nodeID:2, serialNB:"c7c40227")
        ai814 (CanCBXAI814, nodeID:0x3a, serialNB:"c7c50331",transmissionType:1)

    }//end description of bridge0's children
    
    // thermometer description 
    thermometer (CanOpenThermometer,adc:ref("ai814"),numOfAnalogInput:1)
    
    // fake Sensor description 
    fakeSensor (CanOpenThermometer,adc:ref("ai814"),numOfAnalogInput:3)
    
    // led description 
    led (CanOpenLED,dac:ref("ao412"),outputNumero:1)
    
    // fake led description 
    fakeLed (CanOpenLED,dac:ref("ao412"),outputNumero:2)
    
}//end description of Main submodules




