
package org.lsst.ccs.subsystems.fcs.utils;

/**
 *
 * @author virieux
 */
public class TTC580Utils {

    /**
     * return lock sensor for clampXminus
     *
     * @param pdo
     * @return
     */
    public static int getLockXm(long pdo) {
        return (int) (pdo >>> 36) & 0xFFF;
    }

    /**
     * return filter presence sensor for clampXminus
     *
     * @param pdo
     * @return
     */
    public static int getFilterPresenceXm(long pdo) {
        return (int) (pdo >>> 24) & 0xFFF;
    }

    /**
     * return lock sensor for clampXplus
     *
     * @param pdo
     * @return
     */
    public static int getLockXp(long pdo) {
        return (int) (pdo >>> 12) & 0xFFF;
    }

    /**
     * return filter presence sensor value for clampXplus.
     *
     * this value is coded on the last 12 bits (reading from left to right).
     *
     * @param pdo
     * @return
     */
    public static int getFilterPresenceXp(long pdo) {
        return (int) pdo & 0xFFF;
    }

    /**
     * return slave module status.
     *
     * There is one slave module per socket (so 5 slave modules). A slave module is
     * a ttc-30 where clamps sensors are plugged.
     *
     * @param pdo
     * @return
     */
    public static int getSlaveModuleStatus(long pdo) {
        /* 58 = 64 - nbBits (nbBits = 6) */
        return (int) (pdo >>> 58) & 0b000111;
    }

    /**
     *
     * @param sdo
     * @return Offset for Balluff X- (FilterPresenceSensor)
     */
    public static int getOffsetPresenceSensorXminus(long sdo) {
        return (int) (sdo & 0xFFFF);
    }

    /**
     *
     * @param sdo
     * @return offset for Balluff X+ (FilterPresenceSensor)
     */
    public static int getOffsetPresenceSensorXplus(long sdo) {
        return (int) (sdo >> 16 & 0xFFFF);
    }

    /**
     *
     * @param sdo
     * @return Offset for Balluff X- (LockSensor)
     */
    public static int getOffsetLockSensorXminus(long sdo) {
        return (int) (sdo & 0xFFFF);
    }

    /**
     *
     * @param sdo
     * @return offset for Balluff X+ (LockSensor)
     */
    public static int getOffsetLockSensorXplus(long sdo) {
        return (int) (sdo >> 16 & 0xFFFF);
    }

    public static int getErrorSource(int error) {
        return (error >> 28) & 0xF;
    }

    public static int getErrorType(int error) {
        return (error >> 24) & 0xF;
    }

    public static int getErrorCounter(int error) {
        return (error >> 16) & 0xFF;
    }

    public static int getErrorCode(int error) {
        return error & 0xFFFF;
    }

}
