
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;

/**
 * This class represents the electronic device used in autochanger to plug the
 * proximity sensor. The proximity sensor is used to know at which distance are
 * the autochanger trucks from the focal plan. The value returned by the sensor
 * is the quantity readAnalogInput for the input where the sensor is plugged
 * (01). It has to be multiplied by NANO_VOLTS_PER_BIT to obtain a voltage value
 * in nano volts.
 * 
 * @author virieux
 */
public class CanCBXAI420 extends CanOpenDevice implements ADCInterface {

    /**
     * One bit read on the input of the ADC represents 4.6566 nanoVolts
     */
    public static final double NANO_VOLTS_PER_BIT = 4.6566;

    public CanCBXAI420(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Command
    @Override
    public int readAnalogInput(int inputNB) {
        /* 1 <= inputNB <= 4 */
        /* Object 0x6402 is an integer 32 */
        return (int) tcpProxy.readSDO(nodeID, 0x6402, inputNB);
    }

    /**
     * read voltage in volts
     * 
     * @param inputNB
     * @return
     */
    @Command(type = Command.CommandType.QUERY, description = "read voltage in volts for the input chanel inputNB")
    @Override
    public double readVoltage(int inputNB) {
        if (inputNB <= 0 || inputNB > 4)
            throw new IllegalArgumentException(inputNB + " : has to be between 1 and 4");
        return readAnalogInput(inputNB) * NANO_VOLTS_PER_BIT * Math.pow(10, -9);
    }

}
