
package org.lsst.ccs.subsystems.fcs.common;

/**
 * This interface is to be implemented by every class which is a model for a
 * hardware that is moved by an EPOSController. The goal of this interface is to
 * factorise methods :
 * - to process emergency messages coming from the CANbus either when a
 * controller is in fault or when a command faultReset has been sent to the
 * controller.
 * - to monitor current
 *
 * @author virieux
 */
public interface MovedByEPOSController {

    /**
     * Return the name of the controller.
     * 
     * @return
     */
    String getControllerName();

    /**
     * publishes data on the STATUS bus
     */
    void publishData();

    /**
     * Read Current on controller and save value read.
     */
    void updateCurrent();

    /**
     * Read actual current and publish it on STATUS bus.
     */
    default void monitorCurrent() {
        updateCurrent();
        publishData();
    }

}
