/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForCarousel;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.common.TTC580Interface;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Carousel
extends MobileItem
implements HardwareController,
FilterHolder,
AlertRaiser {
    private static final long serialVersionUID = -2376279469784152348L;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    @ConfigurationParameter(range="0..500000")
    private int rotationTimeout = 20000;
    private int position = 0;
    private int relativeTargetPosition;
    private final int speed = 0;
    private int current = 0;
    private final int stepNB = 4362240;
    private final int halfTurn = 2181120;
    @ConfigurationParameter(description="if encoderSign = 1, encoder goes from 0 to stepNB,if encoderSign = -1, encoder goes from 0 to stepNB")
    private int encoderSign = -1;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private EPOSController clampXminusController;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private EPOSController clampXplusController;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private EPOSControllerForCarousel carouselController;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private TTC580Interface hyttc580;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    protected PieceOfHardware ai814;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, CarouselSocket> socketsMap = new TreeMap<String, CarouselSocket>();
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    protected BridgeToHardware tcpProxy;
    private boolean initialized = false;
    private boolean clampsStateInitialized = false;
    private boolean homingDone = false;
    private int socketAtStandbyID;
    private CarouselSocket socketAtStandby;

    public void build() {
    }

    @Command(description="Return true if CANopen devices are booted and initialized and homing has been done.")
    boolean isInitialized() {
        return this.myDevicesReady();
    }

    @Command(description="Return true if clamp state is initialized for all clamps.")
    public boolean isClampsStateInitialized() {
        return this.clampsStateInitialized;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if carouselController homing is done.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    public int getStepNB() {
        return 4362240;
    }

    public int getEncoderSign() {
        return this.encoderSign;
    }

    public Map<String, CarouselSocket> getSocketsMap() {
        return this.socketsMap;
    }

    public CarouselSocket getSocketByName(String socketName) {
        if (this.socketsMap.containsKey(socketName)) {
            return this.socketsMap.get(socketName);
        }
        throw new IllegalArgumentException(this.name + ": no such name for socket:" + socketName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return carousel position.", alias="printPosition")
    public int getPosition() {
        return this.position;
    }

    public EPOSController getClampXminusController() {
        return this.clampXminusController;
    }

    public EPOSController getClampXplusController() {
        return this.clampXplusController;
    }

    public CarouselClamp getClampXminus() {
        if (this.socketAtStandby == null) {
            return null;
        }
        return this.socketAtStandby.getClampXminus();
    }

    public CarouselClamp getClampXplus() {
        if (this.socketAtStandby == null) {
            return null;
        }
        return this.socketAtStandby.getClampXplus();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a socket is HALTED at STANDBY position, false otherwise.")
    public boolean isAtStandby() {
        return this.socketAtStandbyID >= 1 && this.socketAtStandbyID <= 5;
    }

    public CarouselSocket getSocketAtStandby() {
        return this.socketAtStandby;
    }

    public int getSocketAtStandbyID() {
        return this.socketAtStandbyID;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns name of filter at STANDBY position  or NO_FILTER if there is no filter at STANDBY.")
    public String getFilterAtStandbyName() {
        if (this.socketAtStandby == null) {
            return "NO FILTER";
        }
        return this.socketAtStandby.getFilterName();
    }

    public boolean isFilterOnCarousel(int filterID) {
        return this.socketsMap.values().stream().anyMatch(socket -> socket.getFilterID() == filterID);
    }

    @Command(description="To change filterID on socket which ID is given as argument.")
    public void changeFilterID(int filterID, int socketID) {
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + ": bad value - enter a digit between 1 and 5");
        }
        if (this.isFilterOnCarousel(filterID)) {
            int sockID = this.getFilterSocket(filterID).getId();
            throw new IllegalArgumentException(filterID + " filter already on carousel on socket" + sockID);
        }
        String socketName = "socket" + socketID;
        this.socketsMap.get(socketName).setFilterID(filterID);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if Autochanger is holding filter at STANDBY.")
    public boolean isAutochangerHoldingFilter() {
        this.autochanger.updateStateWithSensors();
        return this.autochanger.isHoldingFilter();
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.carouselController.isBooted()) {
            this.initializeRotationController();
        }
        if (this.clampXminusController.isBooted()) {
            this.initializeClampController(this.clampXminusController);
        }
        if (this.clampXplusController.isBooted()) {
            this.initializeClampController(this.clampXplusController);
        }
        try {
            this.initializeClampsState();
        }
        catch (DriverException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initiliaze clamps state.", this.name, (Exception)((Object)ex));
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    private void initializeRotationController() {
        try {
            this.carouselController.initializeAndCheckHardware();
            this.initialized = true;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller", this.carouselController.getName(), (Exception)ex);
        }
    }

    private void initializeClampController(EPOSController controller) {
        try {
            controller.initializeAndCheckHardware();
            if (controller.readMode() != EPOSEnumerations.EposMode.CURRENT) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, controller.getName() + "  is not in CURRENT mode.", controller.getName());
            }
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller", controller.getName(), (Exception)ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="CarouselHoming")
    public void homing() {
        this.homingDone = false;
        this.carouselController.disableVoltage();
        this.carouselController.setPositionSensorTypeEncoderSSI();
        int ssiPosition = this.carouselController.readSSIPosition();
        this.carouselController.setPositionSensorTypeSinusIncrementalEncoder();
        int newSSIPosition = this.computeNewPosition(ssiPosition);
        this.carouselController.enable();
        this.carouselController.defineAbsolutePosition(newSSIPosition);
        this.homingDone = true;
        this.carouselController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.carouselController.disableVoltage();
        this.updatePosition();
        this.publishData();
    }

    private void checkHomingDone() {
        if (!this.isHomingDone()) {
            throw new FcsHardwareException(this.name + " homing has to be done before motion.");
        }
    }

    public void checkSensorTypeIncremental() {
        int sensorType = this.carouselController.readPositionSensorType();
        if (sensorType != 8) {
            throw new FcsHardwareException(this.name + " PositionSensorType has to be set to Incremental Encoder before motion.");
        }
    }

    @Override
    public void publishData() {
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData("carousel", (Serializable)this.createStatusDataPublishedByCarousel()));
    }

    public StatusDataPublishedByCarousel createStatusDataPublishedByCarousel() {
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel();
        status.setPosition((double)this.position);
        status.setCurrent((double)this.current);
        status.setSpeed(0.0);
        status.setHomingDone(this.homingDone);
        status.setAtStandby(this.isAtStandby());
        status.setSocketAtStandbyID(this.socketAtStandbyID);
        status.setFilterAtStandbyName(this.getFilterAtStandbyName());
        if (this.isAtStandby()) {
            status.setSocketAtStandbyName(this.socketAtStandby.getName());
        } else if (this.socketAtStandbyID == 0) {
            status.setSocketAtStandbyName("NO_SOCKET_AT_STANDBY");
        } else if (this.socketAtStandbyID == 7) {
            status.setSocketAtStandbyName("ERROR_READING_ID");
        }
        return status;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if Carousel is stopped and no filter is at STANDBY position")
    public boolean isReadyToGrabAFilterAtStandby() {
        if (this.isRotating()) {
            return false;
        }
        if (this.socketAtStandby == null) {
            return false;
        }
        return this.socketAtStandby.isEmpty() && this.socketAtStandby.isReadyToClamp();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if a filter is clamped at STANDBY position")
    public boolean isHoldingFilterAtStandby() {
        if (this.isRotating()) {
            return false;
        }
        if (this.socketAtStandby == null || this.socketAtStandby.isEmpty()) {
            return false;
        }
        return this.socketAtStandby.isClampedOnFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carousel is rotating.")
    public boolean isRotating() {
        return this.isMoving();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update carousel position in reading controller.")
    public void updatePosition() {
        if (this.homingDone) {
            try {
                this.position = this.carouselController.readPosition();
            }
            catch (SDORequestException ex) {
                FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
            }
        } else {
            throw new RejectedCommandException("Carousel homing not done : do carousel homing before updatePosition.");
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update field current in reading controller.")
    public void updateCurrent() {
        try {
            this.current = this.carouselController.readCurrent();
        }
        catch (SDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    public void updateClampsStateWithSensorsFromPDO() {
        PDOData pdoStore = this.tcpProxy.updatePDOData();
        FCSLOG.finest((Object)(this.name + ":pdoStore=" + pdoStore.toString()));
        this.socketsMap.values().stream().forEach(socket -> socket.updateState());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamps state in sending 5 sync.")
    public void initializeClampsState() throws DriverException {
        FCSLOG.info((Object)(this.name + " Initializing clamps state...."));
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        for (int count = 1; count <= 5; count = (int)((byte)(count + 1))) {
            FCSLOG.info((Object)(this.name + " sync no " + count));
            this.hyttc580.updateFromPDO(this.tcpProxy.updatePDOData());
            this.updateState();
        }
        this.clampsStateInitialized = true;
        this.publishData();
    }

    private synchronized void putFilterOnCarousel(Filter filter) {
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + ": there is no socket at standby position to put a filter in.");
        }
        this.socketAtStandby.setFilterID(filter.getFilterID());
        this.publishData();
    }

    public CarouselSocket getFilterSocket(int filterID) {
        CarouselSocket socket = null;
        for (CarouselSocket sock : this.socketsMap.values()) {
            if (sock.getFilterID() != filterID) continue;
            return sock;
        }
        return socket;
    }

    private int getStandbyPositionForFilter(Filter filter) {
        CarouselSocket socket = this.getFilterSocket(filter.getFilterID());
        if (socket == null) {
            throw new IllegalArgumentException(this.name + " filter is not on carousel " + filter.getName());
        }
        return socket.getStandbyPosition();
    }

    public synchronized String grabFilterAtStandby(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(this.name + ": grabbeFilterAtStandby must receive a non null argument as a filter");
        }
        if (this.isRotating()) {
            throw new RejectedCommandException(this.name + ": grabbeFilterAtStandby can't grabbe a filter while rotating");
        }
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + ": grabbeFilterAtStandby can't be executed because there is no socket at standby position.");
        }
        this.socketAtStandby.updateState();
        if (this.socketAtStandby.isEmpty()) {
            throw new RejectedCommandException(this.name + ": grabbeFilterAtStandby can't be executed because no filter is detected in socket at standby position.");
        }
        if (this.socketAtStandby.isClampedOnFilter()) {
            FCSLOG.info((Object)(this.name + ": grabbing " + filter.getName() + " at standby position."));
            this.putFilterOnCarousel(filter);
            FCSLOG.info((Object)(this.name + ": " + filter.getName() + " is grabbed on carousel."));
            return this.name + ": " + filter.getName() + " is grabbed at standby position";
        }
        throw new RejectedCommandException(this.name + ": grabbeFilterAtStandby can't be executed because the clamps are not CLAMPED ON FILTER.");
    }

    public void ungrabFilterAtStandby(String filterName) {
        if (filterName == null) {
            throw new IllegalArgumentException("Filter to ungrabb should not be null");
        }
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + ":A socket has to be halted at standby position for this operation.");
        }
        if (!this.socketAtStandby.isClampedOnFilter()) {
            throw new RejectedCommandException(this.name + ": can't ungrabb filter which is already unclamped.");
        }
        FCSLOG.info((Object)(this.name + ": ungrabbing " + filterName + " at standby position."));
        this.unlockClamps();
        FCSLOG.info((Object)(this.name + ": socket at standby state : " + this.socketAtStandby.toString()));
        FCSLOG.info((Object)(this.name + ": " + filterName + " is ungrabbed from carousel."));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release clamps at standby position to get ready to clamp again")
    public void releaseClamps() {
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + ":Can't release clamps when no socket is halted at standby position.");
        }
        this.socketAtStandby.releaseClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamps at STANDBY.")
    public void unlockClamps() {
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException("Can't unlock clamps while a socket is not halted at standby position.");
        }
        FCSLOG.info((Object)"Unlocking clamps at standby.");
        this.socketAtStandby.unlockClamps();
    }

    public boolean isAtStandby(Filter filter) {
        return this.getPosition() == this.getStandbyPositionForFilter(filter);
    }

    public void releaseClampsContact() {
    }

    @Override
    public boolean myDevicesReady() {
        return this.tcpProxy.allDevicesBooted() && this.initialized;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if carousel rotation is permitted.")
    public void checkConditionsForRotation() {
        if (!this.initialized) {
            throw new FcsHardwareException("Carousel hardware is not initialized. Can't rotate.");
        }
        if (this.isAtStandby() && this.socketAtStandby.isUnclampedOnFilter()) {
            String message = "Filter at STANDBY position is not held by clamps. Can't rotate carousel.";
            FCSLOG.error((Object)message);
            throw new RejectedCommandException(message);
        }
        if (!this.autochanger.isAtHandoff()) {
            throw new RejectedCommandException(this.name + " can't rotate if autochanger is not at HANDOFF position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel to a relative position.", timeout=60000)
    public void rotateToRelativePosition(int relativePosition) {
        if (Math.abs(relativePosition) > 2181120) {
            throw new IllegalArgumentException(relativePosition + ":  |relativePosition| should be <= " + 2181120);
        }
        FCSLOG.info((Object)(this.name + " is at position: " + this.position + "; about to rotate to relative position: " + relativePosition));
        this.relativeTargetPosition = relativePosition;
        this.executeAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION, this.rotationTimeout);
        if (!this.s.isInState((Enum)AlertState.ALARM)) {
            this.s.updateAgentState(new Enum[]{FcsEnumerations.FilterState.CAROUSEL_STOPPED});
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move a socket which name is given as argument to STANDBY position.", alias="moveSocketToStandby", timeout=50000)
    public void rotateSocketToStandby(String socketName) {
        FcsUtils.checkSocketName(socketName);
        CarouselSocket socketToMove = this.socketsMap.get(socketName);
        int requiredPosition = socketToMove.getStandbyPosition();
        String msgWhenCompleted = this.name + ":" + socketName + " is at STANDBY position on carousel.";
        if (this.position != requiredPosition) {
            FCSLOG.info((Object)(this.name + " is at position: " + this.position + "; about to rotate to position: " + requiredPosition));
            int deltaPosition = requiredPosition - this.position;
            FCSLOG.info((Object)(this.name + " delta position = " + deltaPosition));
            this.relativeTargetPosition = this.computeShortestRelativePosition(deltaPosition);
            this.rotateToRelativePosition(this.relativeTargetPosition);
        }
        FCSLOG.info((Object)msgWhenCompleted);
    }

    public void rotateEmptySocketAtStandby() {
        for (Map.Entry<String, CarouselSocket> entry : this.socketsMap.entrySet()) {
            CarouselSocket socket = entry.getValue();
            if (!socket.isEmpty()) continue;
            this.rotateSocketToStandby(entry.getKey());
            return;
        }
        FCSLOG.error((Object)"no empty socket on carousel - nothing to do.");
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION.equals((Object)action)) {
            return this.carouselController.isTargetReached();
        }
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.carouselController.checkFault();
            this.updatePosition();
            this.updateCurrent();
            FCSLOG.debug((Object)(this.name + " position=" + this.position));
        }
        catch (SDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> SDO ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.carouselController.checkInitialized();
        this.carouselController.checkFault();
        this.homing();
        this.checkHomingDone();
        this.s.updateAgentState(new Enum[]{FcsEnumerations.FilterState.valueOf((String)"ROTATING"), FcsEnumerations.FilterReadinessState.NOT_READY});
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION.equals((Object)action)) {
            this.carouselController.enableAndWriteRelativePosition(this.relativeTargetPosition);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            FCSLOG.warning((Object)ex);
        }
        this.carouselController.stopPosition();
        this.homing();
        this.carouselController.disableVoltage();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.carouselController.stopPosition();
        this.carouselController.disableVoltage();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="compute new position to take in account tours which can have been runned")
    public int computeNewPosition(int pos) {
        int modulo = pos % 4362240;
        int newPos = pos * this.encoderSign > 0 || modulo == 0 ? modulo : this.encoderSign * (4362240 - Math.abs(modulo));
        FCSLOG.finest((Object)("stepNB=4362240 pos=" + pos + " modulo=" + modulo + " ==> new Position = " + newPos));
        return newPos;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Compute relative position to find the shortest way to run carousel.")
    public int computeShortestRelativePosition(int d) {
        int relativePosition;
        if (Math.abs(d) <= 2181120) {
            relativePosition = d;
        } else {
            int s = d > 0 ? -1 : 1;
            relativePosition = s * Math.min(Math.abs(d), 4362240 - Math.abs(d));
        }
        return relativePosition;
    }

    @Override
    public boolean isHoldingFilter() {
        return this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isNotHoldingFilter() {
        return !this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isAtHandoff() {
        return false;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read sensors and update state", timeout=2000)
    public void updateStateWithSensors() {
        long beginTime = System.currentTimeMillis();
        if (!this.clampsStateInitialized) {
            throw new FcsHardwareException(this.name + ": clamps state not initialized.  Please launch command initializeClampsState.");
        }
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        try {
            this.hyttc580.updateFromPDO(this.tcpProxy.updatePDOData());
            this.updateState();
        }
        catch (DriverException ex) {
            throw new FcsHardwareException(this.name + "Can't updatePDO data.", (Throwable)ex);
        }
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateStateWithSensors duration = " + duration));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update socket at standby state from hyttc580 data.", timeout=2000)
    public void updateStateWithSensorsAtStandby() {
        long duration;
        long beginTime = System.currentTimeMillis();
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        try {
            this.hyttc580.updateFromPDO(this.tcpProxy.updatePDOData());
            duration = System.currentTimeMillis() - beginTime;
            FCSLOG.info((Object)(this.name + " hyttc580.updateFromPDO(tcpProxy.updatePDOData()) duration = " + duration));
        }
        catch (DriverException ex) {
            throw new FcsHardwareException(this.name + "Can't updatePDO data.", (Throwable)ex);
        }
        this.updateSocketAtStandbyState();
        duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateStateWithSensorsAtStandby duration = " + duration));
    }

    public void updateSocketAtStandbyState() {
        long beginTime = System.currentTimeMillis();
        this.socketAtStandbyID = this.hyttc580.getSocketId(this.hyttc580.getPdo1());
        if (this.socketAtStandbyID >= 1 && this.socketAtStandbyID <= 5) {
            this.socketAtStandby = this.socketsMap.get("socket" + this.socketAtStandbyID);
            this.socketAtStandby.updateState();
            this.socketAtStandby.getClampXminus().setAtStandby(true);
            this.socketAtStandby.getClampXplus().setAtStandby(true);
        } else {
            this.socketAtStandby = null;
        }
        this.publishData();
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateSocketAtStandbyState duration = " + duration));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update state from hyttc580 data.", timeout=2000)
    public void updateState() throws DriverException {
        long beginTime = System.currentTimeMillis();
        this.updateSocketAtStandbyState();
        this.subs.getScheduler().schedule(() -> this.updateSocketNotAtStandby(), 0L, TimeUnit.SECONDS);
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateState duration = " + duration));
    }

    public void updateSocketNotAtStandby() {
        long beginTime = System.currentTimeMillis();
        short socketNotAtStandbyID = this.hyttc580.getSocketId(this.hyttc580.getPdo2());
        if (socketNotAtStandbyID >= 1 && socketNotAtStandbyID <= 5) {
            CarouselSocket socketToUpdate = this.socketsMap.get("socket" + socketNotAtStandbyID);
            socketToUpdate.updateState();
            socketToUpdate.getClampXminus().setAtStandby(false);
            socketToUpdate.getClampXplus().setAtStandby(false);
        }
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateSocketNotAtStandby duration = " + duration));
    }
}

