/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenADC;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenSensor14bits;

public class SimuCanOpenADCTest {
    private static Subsystem sensorSubsystem = null;
    private static SimuCanOpenSensor14bits sensor14bits;
    private static SimuCanOpenADC adc;
    private static SimuCanOpenInterface canInterface;
    private static CanOpenProxy tcpProxy;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF SimuCanOpenADC                 ");
        System.out.println("***************************************");
        sensorSubsystem = BootUtils.getSubsystemFromFile((String)"canOpenSensor14bitsTest");
        sensorSubsystem.startAgent();
        ComponentLookup lookup = sensorSubsystem.getComponentLookup();
        sensor14bits = (SimuCanOpenSensor14bits)lookup.getComponentByPath("main/sensor14bits");
        adc = (SimuCanOpenADC)lookup.getComponentByPath("main/tcpProxy/ai814");
        System.out.println("sensor14bits = " + sensor14bits.toString());
        canInterface = (SimuCanOpenInterface)lookup.getComponentByPath("main/tcpProxy/canInterface");
        System.out.println("adc = " + adc.toString());
        tcpProxy = (CanOpenProxy)lookup.getComponentByPath("main/tcpProxy");
    }

    @AfterClass
    public static void after() throws Exception {
        sensorSubsystem.shutdownAgent();
    }

    @Before
    public void setUp() throws DriverException {
        adc.initializeAndCheckHardware();
        canInterface.sync();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testUpdateFakePDOData() {
        System.out.println("updateFakePDOData");
        int numOfAnalogInput = 0;
        int value = 0;
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[0] == value", (SimuCanOpenADCTest.adc.inputs[0] == value ? 1 : 0) != 0);
        numOfAnalogInput = 0;
        value = 1;
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[1] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        numOfAnalogInput = 1;
        value = 1;
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[1] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        numOfAnalogInput = 2;
        value = 127;
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[2] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        tcpProxy.updatePDOData();
        Assert.assertTrue((String)"adc.inputs[2] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        numOfAnalogInput = 3;
        value = 3456;
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[3] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        numOfAnalogInput = 4;
        value = 4095;
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[4] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        numOfAnalogInput = 5;
        value = 138;
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[5] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[5] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        numOfAnalogInput = 6;
        value = 1025;
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[6] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        numOfAnalogInput = 7;
        value = 32567;
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[7] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        adc.updateFakePDOData(numOfAnalogInput, value);
        Assert.assertTrue((String)"adc.inputs[7] == value", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] == value ? 1 : 0) != 0);
        numOfAnalogInput = 8;
        value = 9600;
        try {
            adc.updateFakePDOData(numOfAnalogInput, value);
            Assert.fail((String)"updateFakePDOData should raise an IllegalArgumentException when numOfAnalogInput >= 8");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
    }

    @Test
    public void testCheckValues() {
        int aValue1 = 0;
        int aValue2 = 3500;
        System.out.println("***************************************");
        System.out.println("checkValues of class SimuCanOpenADC ");
        adc.checkValues(aValue1, aValue2);
        try {
            adc.checkValues(aValue2, aValue1);
            Assert.fail((String)"second argument must be greater than first argument. Should raise Exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        try {
            adc.checkValues(-300, aValue2);
            Assert.fail((String)"first argument must be > 0. Should raise Exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        try {
            adc.checkValues(aValue2, 32768);
            Assert.fail((String)"second argument must be < SENSOR14BITS_MAX. Should raise Exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        try {
            adc.checkValues(0, 65535);
            Assert.fail((String)"second argument must be < SENSOR14BITS_MAX. Should raise Exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        try {
            adc.checkValues(-1, 200);
            Assert.fail((String)"first argument must be > SENSOR14BITS_MIN. Should raise Exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
    }

    @Test
    public void testComputeNewValue() {
        System.out.println("computeNewValue");
        int aValue1 = 2800;
        int aValue2 = 4095;
        int newValue = adc.computeNewValue(aValue1, aValue2);
        System.out.println("new value=" + newValue);
        if (newValue < aValue1 || newValue > aValue2) {
            Assert.fail((String)"result out of range");
        }
        aValue1 = 4;
        aValue2 = 6;
        newValue = adc.computeNewValue(aValue1, aValue2);
        System.out.println("newValue=" + newValue);
        Assert.assertTrue((String)("new value should be greater than " + aValue1), (newValue >= aValue1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("new value should be less than " + aValue2), (newValue <= aValue2 ? 1 : 0) != 0);
    }

    @Test
    public void testSimulateNewValue() throws DriverException {
        System.out.println("simulateNewValue");
        int numOfAnalogInput = 0;
        int minValue = 0;
        int maxValue = 10;
        adc.simulateNewValue(numOfAnalogInput, minValue, maxValue);
        Assert.assertTrue((String)"inputs[0] <= 10", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] <= maxValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"inputs[0] >= 0", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] >= minValue ? 1 : 0) != 0);
        canInterface.sync();
        Assert.assertTrue((String)"inputs[0] <= 10", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] <= maxValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"inputs[0] >= 0", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] >= minValue ? 1 : 0) != 0);
        numOfAnalogInput = 4;
        minValue = 63;
        maxValue = 10567;
        adc.simulateNewValue(numOfAnalogInput, minValue, maxValue);
        Assert.assertTrue((String)"inputs[4] <= 10567", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] <= maxValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"inputs[4] >= 0x3F", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] >= minValue ? 1 : 0) != 0);
        canInterface.sync();
        Assert.assertTrue((String)"inputs[4] <= 10567", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] <= maxValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"inputs[4] >= 0x3F", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] >= minValue ? 1 : 0) != 0);
        numOfAnalogInput = 6;
        minValue = 0;
        maxValue = 10;
        adc.simulateNewValue(numOfAnalogInput, minValue, maxValue);
        Assert.assertTrue((String)"inputs[6] <= 10", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] <= maxValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"inputs[6] >= 0", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] >= minValue ? 1 : 0) != 0);
        canInterface.sync();
        Assert.assertTrue((String)"inputs[6] <= 10", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] <= maxValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"inputs[6] >= 0", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] >= minValue ? 1 : 0) != 0);
        numOfAnalogInput = 7;
        minValue = 127;
        maxValue = 4095;
        adc.simulateNewValue(numOfAnalogInput, minValue, maxValue);
        Assert.assertTrue((String)"inputs[7] <= 0x7F", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] <= maxValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"inputs[7] >= 0x0FFF", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] >= minValue ? 1 : 0) != 0);
        canInterface.sync();
        Assert.assertTrue((String)"inputs[7] <= 0x7F", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] <= maxValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"inputs[7] >= 0x0FFF", (SimuCanOpenADCTest.adc.inputs[numOfAnalogInput] >= minValue ? 1 : 0) != 0);
    }

    @Test
    public void testSimulateSensorValue() throws DriverException {
        System.out.println("simulateSensorValue");
        adc.simulateSensorValue((CanOpenSensor14bits)sensor14bits, 79, 95);
        Assert.assertEquals((String)"getValue() is equal to readNewValue()", (long)sensor14bits.getValue(), (long)sensor14bits.readNewValue());
        Assert.assertTrue((String)"value should be < 0x5f", (sensor14bits.getValue() < 95 ? 1 : 0) != 0);
        Assert.assertTrue((String)"value should be > 0x4f", (sensor14bits.getValue() >= 79 ? 1 : 0) != 0);
        adc.simulateSensorValue((CanOpenSensor14bits)sensor14bits, 0, 4095);
        Assert.assertEquals((String)"getValue() is equal to readNewValue()", (long)sensor14bits.getValue(), (long)sensor14bits.readNewValue());
        Assert.assertTrue((String)"value should be < 0x0FFF", (sensor14bits.getValue() < 4095 ? 1 : 0) != 0);
        Assert.assertTrue((String)"value should be > 0", (sensor14bits.getValue() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdatePDOData() throws DriverException {
        System.out.println("updatePDOData");
        adc.simulateSensorValue((CanOpenSensor14bits)sensor14bits, 5, 6);
        int newValue = sensor14bits.getValue();
        int valueADC = adc.getInputs()[sensor14bits.getNumOfAnalogInput()];
        Assert.assertEquals((String)"valueADC", (long)newValue, (long)valueADC);
        System.out.println("=> canInterface pdoData=" + canInterface.sync().toString());
        System.out.println("=> tcpProxy pdoData=" + tcpProxy.sync().toString());
        System.out.println("1- sensor14bits.getValue()=" + sensor14bits.getValue());
        tcpProxy.updatePDOData();
        System.out.println("2- sensor14bits.getValue()=" + sensor14bits.getValue());
        sensor14bits.updateValue();
        valueADC = adc.getInputs()[sensor14bits.getNumOfAnalogInput()];
        Assert.assertEquals((String)"valueADC", (long)newValue, (long)valueADC);
        Assert.assertEquals((String)"sensor14bits.getValue()", (long)sensor14bits.readNewValue(), (long)sensor14bits.getValue());
        valueADC = adc.getInputs()[sensor14bits.getNumOfAnalogInput()];
        Assert.assertEquals((String)"valueADC", (long)newValue, (long)valueADC);
        System.out.println("3- sensor14bits.getValue()=" + sensor14bits.getValue());
        Assert.assertEquals((String)"sensor14bits.getValue() ", (long)newValue, (long)sensor14bits.getValue());
    }
}

