/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerLatch;
import org.lsst.ccs.subsystems.fcs.AutochangerMain;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerStandalonePlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;

public class AutochangerOnlineClampsTest
extends CcsTestCaseTemplate {
    private static Subsystem autochangerSubsystem = null;
    private static AutochangerMain main;
    private static Autochanger autochanger;
    private static AutochangerTwoTrucks trucks;
    private static AutochangerTwoLatches latches;
    private static AutochangerLatch latchXminus;
    private static AutochangerLatch latchXplus;
    private static AutochangerThreeOnlineClamps onlineClamps;
    private static AutochangerOnlineClamp onlineClampXminus;
    private static AutochangerOnlineClamp onlineClampXplus;
    private static AutochangerOnlineClamp onlineClampYminus;
    private static SimuAutochangerStandalonePlutoGateway plutoGateway;
    private static SimuEPOSController onlineClampXminusController;
    private static AutochangerOnlineClamp[] clampsList;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("*************************************************************");
        System.out.println("    TESTS OF AUTOCHANGER ONLINE CLAMPS IN STANDALONE MODE    ");
        System.out.println("*************************************************************");
        autochangerSubsystem = BootUtils.getSubsystemFromFile((String)"autochanger__simulation", (String)"");
        autochangerSubsystem.startAgent();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        WriterProvider.getInstance().getPrintWriter("autochanger-standalone-simu_slow_timers.properties");
        WriterProvider.getInstance().getPrintWriter("autochanger-standalone-simu_fast_timers.properties");
        ComponentLookup lookup = autochangerSubsystem.getComponentLookup();
        main = (AutochangerMain)lookup.getComponentByName("main");
        autochanger = (Autochanger)lookup.getComponentByName("autochanger");
        autochanger.updateStateWithSensors();
        trucks = (AutochangerTwoTrucks)lookup.getComponentByName("autochangerTrucks");
        plutoGateway = (SimuAutochangerStandalonePlutoGateway)lookup.getComponentByName("acSensorsGateway");
        plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        latches = (AutochangerTwoLatches)lookup.getComponentByName("latches");
        latchXminus = (AutochangerLatch)lookup.getComponentByName("latchXminus");
        latchXplus = (AutochangerLatch)lookup.getComponentByName("latchXplus");
        onlineClamps = (AutochangerThreeOnlineClamps)lookup.getComponentByName("onlineClamps");
        onlineClampXminus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampXminus");
        onlineClampXplus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampXplus");
        onlineClampYminus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampYminus");
        onlineClampXminusController = (SimuEPOSController)lookup.getComponentByName(onlineClampXminus.getControllerName());
        clampsList = new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus, onlineClampYminus};
        Assert.assertEquals((String)"onlineClampXminusController.getName()=onlineClampXminus.getControllerName()", (Object)onlineClampXminusController.getName(), (Object)onlineClampXminus.getControllerName());
        Assert.assertTrue((String)"After initialization phase, simulated hardware should be ready.", (boolean)main.allDevicesBooted());
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.configureController();
            Assert.assertTrue((String)"After configuration, clamps should be ready", (boolean)clamp.myDevicesReady());
        }
    }

    @Before
    public void setUp() throws Exception {
        System.out.println("****************************************************");
        System.out.println("***********  BEFORE EACH TEST    *******************");
        System.out.println("****************************************************");
        System.out.println("***go back to initial conditions: autochanger empty at HANDOFF");
        System.out.println("simulateAutochangerTrucksIsAtHandoff");
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.setIncrementCurrentToClose(300);
            clamp.setIncrementCurrentToOpen(300);
            clamp.setIncrementCurrentToClamp(532);
            clamp.setInitialCurrentToClose(300);
            clamp.setFinalCurrentToClose(1800);
            clamp.setCurrentToOpen(-300);
            clamp.setCurrentToClamp(4992);
            clamp.setMaxTimeToClose(1000);
            clamp.setMaxTimeToOpen(1400);
            clamp.setMaxTimeToLock(1200);
            clamp.setMaxTimeToUnlock(1200);
        }
        plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        System.out.println("simulateAutochangerIsEmpty");
        plutoGateway.simulateAutochangerIsEmpty();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXminus should be empty", (boolean)latchXminus.isEmpty());
        Assert.assertTrue((String)"latchXplus should be empty", (boolean)latchXplus.isEmpty());
        Assert.assertTrue((String)"Autochanger latches should be empty", (boolean)latches.isEmpty());
        Assert.assertTrue((String)"Autochanger should be empty", (boolean)autochanger.isEmpty());
        System.out.println("simulateAutochangerAreUnlocked");
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        System.out.println("simulateAutochangerOnlineClampsAreUnlocked");
        plutoGateway.simulateAutochangerOnlineClampsAreOpened();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Latches are UNLOCKED", (boolean)latches.isOpened());
        Assert.assertTrue((String)"ONLINE clamps are OPENED", (boolean)onlineClamps.isOpened());
        autochangerSubsystem.getAlertService().clearAllAlerts();
    }

    @Test
    public void test_close_open_onlineClamp() {
        System.out.println("*****************************************");
        System.out.println("*** test_close_open_onlineClamp       ***");
        System.out.println("*****************************************");
        Assert.assertTrue((String)"Online clamps are OPENED", (boolean)onlineClamps.isOpened());
        Assert.assertTrue((String)"onlineClampXminusController is initialized", (boolean)onlineClampXminusController.isInitialized());
        Assert.assertTrue((String)"onlineClampXminus hardware is ready", (boolean)onlineClampXminus.myDevicesReady());
        Assert.assertTrue((String)"onlineClampXminus is initialized", (boolean)onlineClampXminus.isInitialized());
        Assert.assertTrue((String)"ONLINE clamps hardware is ready", (boolean)onlineClamps.myDevicesReady());
        Assert.assertTrue((String)"ONLINE clamps is initialized", (boolean)onlineClamps.isInitialized());
        System.out.println("*** test method close of class AutochangerOnlineClampModule - test with onlineClampXminus");
        System.out.println("*** test close onlineClampXminus  - should fail because autochanger trucks are at HANDOFF");
        try {
            onlineClampXminus.close();
            Assert.fail((String)"autochanger is at HANDOFF - can't close clamps. Should raise a RejectedCommandException.");
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        plutoGateway.simulateAutochangerTrucksAreOnline();
        trucks.updatePosition();
        System.out.println("*** test close onlineClampXminus again - should fail because autochanger is empty");
        try {
            onlineClampXminus.close();
            Assert.fail((String)"onlineClampXminus can't be CLOSED if there is no filter in autochanger trucks. Should raise a RejectedCommandException.");
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger is not empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Latches are LOCKED", (boolean)latches.isClosed());
        System.out.println("*** test close the 3 onlineClamps - should success");
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.close();
            Assert.assertTrue((String)(clamp.getName() + " is CLOSED"), (boolean)clamp.isClosed());
            Assert.assertTrue((clamp.getSentCurrent() == clamp.getFinalCurrentToClose() ? 1 : 0) != 0);
        }
        System.out.println("*** test close onlineClampXminus again - should do nothing but log.");
        onlineClampXminus.close();
        Assert.assertTrue((String)"onlineClampXminus is CLOSED", (boolean)onlineClampXminus.isClosed());
        Assert.assertTrue((onlineClampXminus.getSentCurrent() == onlineClampXminus.getFinalCurrentToClose() ? 1 : 0) != 0);
        System.out.println("*** test open onlineClamps");
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.open();
            Assert.assertTrue((String)(clamp.getName() + " is OPENED"), (boolean)clamp.isOpened());
            Assert.assertTrue((clamp.getSentCurrent() == clamp.getCurrentToOpen() ? 1 : 0) != 0);
        }
    }

    @Test
    public void test_lock_unlock_onlineClamp() {
        System.out.println("*****************************************");
        System.out.println("*** test_lock_unlock_onlineClamp");
        System.out.println("*****************************************");
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger is not empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Latches are LOCKED", (boolean)latches.isClosed());
        AutochangerOnlineClamp clampToTest = onlineClampYminus;
        try {
            clampToTest.lock();
            Assert.fail((String)(clampToTest.getName() + " can't be locked because it's opened. It has to be closed before."));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        try {
            clampToTest.unlock();
            Assert.fail((String)(clampToTest.getName() + " can't be unlocked because it's opened."));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        try {
            clampToTest.close();
            Assert.fail((String)"clampToTest.close() should fail because autochanger is not ONLINE.");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        plutoGateway.simulateAutochangerTrucksAreOnline();
        autochanger.updateStateWithSensors();
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.close();
            Assert.assertTrue((String)(clamp.getName() + " is CLOSED"), (boolean)clamp.isClosed());
        }
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.lock();
            Assert.assertTrue((String)(clamp.getName() + " is LOCKED"), (boolean)clamp.isLocked());
        }
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.lock();
            Assert.assertTrue((String)(clamp.getName() + " is LOCKED"), (boolean)clamp.isLocked());
        }
        clampToTest = onlineClampXminus;
        try {
            clampToTest.close();
            Assert.fail((String)(clampToTest.getName() + " can't be closed because it's locked. It has to be unlocked."));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        clampToTest = onlineClampXplus;
        try {
            clampToTest.open();
            Assert.fail((String)(clampToTest.getName() + " can't be opened because it's locked. It has to be unlocked first."));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.unlock();
            Assert.assertTrue((String)(clamp.getName() + " is CLOSED"), (boolean)clamp.isClosed());
            Assert.assertEquals((String)(clamp.getName() + " value of current sent to controller is currentToClose"), (long)clamp.getSentCurrent(), (long)clamp.getFinalCurrentToClose());
        }
        System.out.println("*** open again onlineClamps");
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.open();
            Assert.assertTrue((String)(clamp.getName() + " is OPENED"), (boolean)clamp.isOpened());
            Assert.assertTrue((clamp.getSentCurrent() == clamp.getCurrentToOpen() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExecuteCurrentRamp() throws Exception {
        System.out.println("*****************************************");
        System.out.println("***   test executeCurrentRamp         ***");
        System.out.println("*****************************************");
        int maxTime = 1000;
        int initialValue = 0;
        int finalValue = 2000;
        int increment = 250;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, increment, maxTime, 0);
        int readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = 0;
        finalValue = -2000;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, increment, maxTime, 0);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = -2000;
        finalValue = 0;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, increment, maxTime, 0);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = 2000;
        finalValue = 0;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, increment, maxTime, 0);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
        initialValue = 300;
        finalValue = 3000;
        increment = 300;
        maxTime = 900;
        System.out.println("initial value =" + initialValue + " final value=" + finalValue);
        onlineClampXminus.executeCurrentRamp(initialValue, finalValue, increment, maxTime, 0);
        readCurrent = onlineClampXminus.getController().readCurrent();
        Assert.assertEquals((String)("onlineClampXminus readCurrent should be = " + finalValue), (long)finalValue, (long)readCurrent);
    }

    @Test
    public void testcloseAndUnlockClamps() {
        System.out.println("*****************************************");
        System.out.println("***   test closeAndLockClamps         ***");
        System.out.println("*****************************************");
        try {
            onlineClamps.closeAndLockClamps();
            Assert.fail((String)"onlineClamps.closeAndLockClamps() should fail because autochanger is not at ONLINE.");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        plutoGateway.simulateAutochangerTrucksAreOnline();
        autochanger.updateStateWithSensors();
        try {
            onlineClamps.closeAndLockClamps();
            Assert.fail((String)"onlineClamps.closeAndLockClamps() should fail because autochanger is empty.");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        onlineClamps.closeAndLockClamps();
        System.out.println("clamps STATUS=" + onlineClamps.getLockStatus());
        Assert.assertTrue((String)"clamps are LOCKED", (boolean)onlineClamps.isLocked());
        System.out.println("***   end of test lockClamps         ***");
    }

    @Test
    public void testUnlockAndOpenClamps() {
        System.out.println("*****************************************");
        System.out.println("***   test unlockAndOpenClamps        ***");
        System.out.println("*****************************************");
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        autochanger.updateStateWithSensors();
        onlineClamps.unlockAndOpenClamps();
        Assert.assertTrue((String)"clamps are OPENED", (boolean)onlineClamps.isOpened());
        for (AutochangerOnlineClamp clamp : clampsList) {
            Assert.assertTrue((clamp.getSentCurrent() == clamp.getCurrentToOpen() ? 1 : 0) != 0);
        }
        System.out.println("***   end of test unlockAndOpenClamps         ***");
    }

    @Test
    public void testOpenClampsX() {
        System.out.println("*****************************************");
        System.out.println("***   test openClampsX        ***");
        System.out.println("*****************************************");
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        autochanger.updateStateWithSensors();
        onlineClamps.openClampsX();
        for (AutochangerOnlineClamp clamp : new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus}) {
            Assert.assertTrue((String)(clamp.getName() + " is open "), (boolean)clamp.isOpened());
            Assert.assertTrue((String)(clamp.getName() + " sentCurrent is currentToOpen"), (clamp.getSentCurrent() == clamp.getCurrentToOpen() ? 1 : 0) != 0);
        }
        System.out.println("***   end of test openClampsX         ***");
    }

    @Test
    public void testCloseClampsX() {
        System.out.println("*****************************************");
        System.out.println("***   test closeClampsX        ***");
        System.out.println("*****************************************");
        plutoGateway.simulateFilterIsOnAutochanger();
        plutoGateway.simulateAutochangerTrucksAreOnline();
        autochanger.updateStateWithSensors();
        onlineClamps.closeClampsX();
        for (AutochangerOnlineClamp clamp : new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus}) {
            Assert.assertTrue((String)(clamp.getName() + " is closed "), (boolean)clamp.isClosed());
            Assert.assertTrue((String)(clamp.getName() + " sentCurrent is finalCurrentToClose"), (clamp.getSentCurrent() == clamp.getFinalCurrentToClose() ? 1 : 0) != 0);
        }
        System.out.println("***   end of test closeClampsX         ***");
    }

    @AfterClass
    public static void after() throws Exception {
        autochangerSubsystem.shutdownAgent();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        WriterProvider.getInstance().getPrintWriter("autochanger-standalone-simu_slow_timers.properties").flush();
        WriterProvider.getInstance().getPrintWriter("autochanger-standalone-simu_fast_timers.properties").flush();
        WriterProvider.getInstance().getPrintWriter("autochanger-standalone-simu_slow_timers.properties").close();
        WriterProvider.getInstance().getPrintWriter("autochanger-standalone-simu_fast_timers.properties").close();
    }
}

