/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;

public class CanOpenEPOSTest
extends CcsTestCaseTemplate {
    private static Subsystem s;
    private static CanOpenEPOS controller;
    private static final String name = "controller1";
    private static final Map<String, Integer> paramsForCurrent;
    private static final Map<String, Integer> paramsForProfilePosition;
    private static final Map<String, Integer> paramsForHoming;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF CanOpenEPOS");
        System.out.println("***************************************");
        paramsForCurrent.put(EPOSEnumerations.Parameter.MotorType.toString(), 11);
        paramsForCurrent.put(EPOSEnumerations.Parameter.ContinuousCurrentLimit.toString(), 2360);
        paramsForCurrent.put(EPOSEnumerations.Parameter.OutputCurrentLimit.toString(), 4720);
        paramsForProfilePosition.put(EPOSEnumerations.Parameter.MotionProfileType.toString(), 0);
        paramsForHoming.put(EPOSEnumerations.Parameter.HomeOffset.toString(), 0);
        s = BootUtils.getSubsystemFromFile((String)"testCanOpenEPOS");
        s.startAgent();
        controller = (CanOpenEPOS)s.getComponentLookup().getComponentByName(name);
        CanOpenEPOSTest.controller.booted = true;
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        s.shutdownAgent();
        System.out.println("********* end of CanOpenEPOS tests *************");
    }

    @Before
    public void setUp() {
        controller.resetError();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testIsEnabledToPublish() {
        System.out.println("isEnabledToPublish");
        CanOpenEPOS instance = controller;
        boolean expResult = false;
        boolean result = instance.isEnabledToPublish();
        Assert.assertEquals((String)"Controller is not enabled.", (Object)expResult, (Object)result);
    }

    @Test
    public void testCheckAndResetFault() throws InterruptedException {
        System.out.println("### checkFault");
        controller.checkFault();
        Assert.assertFalse((String)"simulated controller should not be in error", (boolean)CanOpenEPOSTest.controller.inError);
        Assert.assertFalse((String)"Subsystem should NOT be in ALARM State.", (boolean)s.isInState((Enum)AlertState.ALARM));
        EmergencyMessage emcy = new EmergencyMessage(controller.getNodeID(), controller.getName(), 16, "Error10", 848, "ERROR 350");
        controller.onEmergencyMessage(emcy);
        Assert.assertTrue((String)"simulated controller should be in error", (boolean)CanOpenEPOSTest.controller.inError);
        Assert.assertEquals((String)("controller errorRegister should be: " + emcy.getErrorRegisterName()), (Object)CanOpenEPOSTest.controller.errorRegister, (Object)emcy.getErrorRegisterName());
        Assert.assertTrue((String)"Subsystem is in ALARM State.", (boolean)s.isInState((Enum)AlertState.ALARM));
        controller.faultReset();
        Assert.assertFalse((String)"no more fault : controller should not be in error", (boolean)CanOpenEPOSTest.controller.inError);
        Assert.assertFalse((String)"Subsystem is NOT in ALARM State.", (boolean)s.isInState((Enum)AlertState.ALARM));
    }

    @Test
    public void testFaultReset() {
        System.out.println("### faultReset");
        controller.faultReset();
        Assert.assertFalse((String)"no fault : faultReset should not change anything", (boolean)CanOpenEPOSTest.controller.inError);
    }

    @Test
    public void testConvertEPOSValue() {
        System.out.println("testConvertEPOSValue");
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.MaxFollowingError;
        long value = Long.MAX_VALUE;
        long paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)value, (long)paramValue);
        Assert.assertTrue((String)"paramValue > 0", (paramValue > 0L ? 1 : 0) != 0);
        value = Long.MAX_VALUE;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)value, (long)paramValue);
        Assert.assertTrue((String)"paramValue > 0", (paramValue > 0L ? 1 : 0) != 0);
        value = (long)Math.pow(2.0, 31.0);
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)value, (long)paramValue);
        Assert.assertTrue((String)"paramValue > 0", (paramValue > 0L ? 1 : 0) != 0);
        param = EPOSEnumerations.Parameter.MaxPositionLimit;
        value = (long)Math.pow(2.0, 31.0) - 1L;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)value, (long)paramValue);
        value = (long)Math.pow(2.0, 31.0);
        param = EPOSEnumerations.Parameter.MaxPositionLimit;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)(-value), (long)paramValue);
        param = EPOSEnumerations.Parameter.CurrentThresholdHomingMode;
        value = 500L;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)500L, (long)paramValue);
        Assert.assertTrue((String)"paramValue > 0", (paramValue > 0L ? 1 : 0) != 0);
        value = 65534L;
        Assert.assertEquals((String)"paramValue", (long)-2L, (long)((short)value));
        param = EPOSEnumerations.Parameter.PolePairNumber;
        value = 255L;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)value, (long)paramValue);
        Assert.assertTrue((String)"paramValue > 0", (paramValue > 0L ? 1 : 0) != 0);
        param = EPOSEnumerations.Parameter.HomingMethod;
        value = 255L;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)-1L, (long)paramValue);
        value = 35L;
        paramValue = EPOSController.convertEPOSValue((EPOSEnumerations.Parameter)param, (long)value, (String)"controllerName");
        Assert.assertEquals((String)"paramValue", (long)35L, (long)paramValue);
    }

    static {
        paramsForCurrent = new HashMap<String, Integer>();
        paramsForProfilePosition = new HashMap<String, Integer>();
        paramsForHoming = new HashMap<String, Integer>();
    }
}

