/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.security.SecureRandom;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGatewayWithFilterID;

public class FilterIdentificatorTest
extends CcsTestCaseTemplate {
    private static Subsystem filterIdentificatorSubsystem = null;
    private static FilterIdentificator filterIdentificator;
    private static SimuPlutoGatewayWithFilterID plutoGateway;
    private final SecureRandom randomGenerator = new SecureRandom();

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("************************************************************************");
        System.out.println("***               TESTS OF FilterIdentificator                      ****");
        System.out.println("************************************************************************");
        filterIdentificatorSubsystem = BootUtils.getSubsystemFromFile((String)"filterIdentificator__simulation", (String)"");
        filterIdentificatorSubsystem.startAgent();
        ComponentLookup lookup = filterIdentificatorSubsystem.getComponentLookup();
        filterIdentificator = (FilterIdentificator)lookup.getComponentByPath("main/filterIdentificator");
        plutoGateway = (SimuPlutoGatewayWithFilterID)lookup.getComponentByPath("main/tcpProxy/acSensorsGateway");
    }

    @Before
    public void setUp() throws Exception {
        Utils.printJoliSetUp("FilterIdentificatorTest");
        filterIdentificatorSubsystem.getAlertService().clearAllAlerts();
        plutoGateway.simulateFilterID(29);
        plutoGateway.updateValues();
        filterIdentificator.updateFilterId();
        int expResult = 29;
        int result = filterIdentificator.getFilterId();
        Assert.assertEquals((String)"In the begining filterID=1", (long)expResult, (long)result);
    }

    @After
    public void tearDown() throws Exception {
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("****************************************************");
        System.out.println("*** FilterIdentificator test end    ***");
        System.out.println("****************************************************");
        filterIdentificatorSubsystem.shutdownAgent();
    }

    @Test
    public void testgetFilterId() {
        System.out.println("getFilterId");
        int id = filterIdentificator.getFilterId();
        System.out.println("getFilterId=" + id + " binaire=" + Integer.toBinaryString(id));
        plutoGateway.replaceValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(0), true);
        plutoGateway.updateValues();
        filterIdentificator.updateFilterId();
        id = filterIdentificator.getFilterId();
        System.out.println("getFilterId=" + id + " binaire=" + Integer.toBinaryString(id));
        Assert.assertEquals((String)"filterID", (long)28L, (long)filterIdentificator.getFilterId());
        plutoGateway.replaceValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(1), false);
        plutoGateway.updateValues();
        filterIdentificator.updateFilterId();
        id = filterIdentificator.getFilterId();
        System.out.println("getFilterId=" + id + " binaire=" + Integer.toBinaryString(id));
        Assert.assertEquals((String)"filterID", (long)30L, (long)filterIdentificator.getFilterId());
    }

    @Test
    public void testSimulateFilterID() {
        System.out.println("simulateFilterID");
        plutoGateway.simulateFilterID(5);
        plutoGateway.updateValues();
        filterIdentificator.updateFilterId();
        Assert.assertEquals((String)"Now filterID is 5", (long)5L, (long)filterIdentificator.getFilterId());
        plutoGateway.simulateFilterID(12);
        plutoGateway.updateValues();
        filterIdentificator.updateFilterId();
        Assert.assertEquals((String)"Now filterID is 12", (long)12L, (long)filterIdentificator.getFilterId());
        try {
            plutoGateway.simulateFilterID(0);
            Assert.fail((String)"argument of simulateFilterID can't be 0");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        try {
            plutoGateway.simulateFilterID(64);
            Assert.fail((String)"argument of simulateFilterID must be < 64");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        int randomFilterID = this.randomGenerator.nextInt(63);
        if (randomFilterID > 0) {
            System.out.println("simulateFilterID with randomFilterID=" + randomFilterID);
            plutoGateway.simulateFilterID(randomFilterID);
            plutoGateway.updateValues();
            filterIdentificator.updateFilterId();
            Assert.assertEquals((String)("Now filterID is " + randomFilterID), (long)randomFilterID, (long)filterIdentificator.getFilterId());
        }
    }

    @Test
    public void testIdentification() {
        plutoGateway.replaceValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(0), false);
        plutoGateway.replaceValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(1), true);
        plutoGateway.replaceValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(2), true);
        plutoGateway.replaceValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(3), true);
        plutoGateway.replaceValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(4), false);
        plutoGateway.replaceValues((DigitalSensor)filterIdentificator.getFilterIDSensors().get(5), true);
        plutoGateway.updateValues();
        filterIdentificator.updateFilterId();
        int id = filterIdentificator.getFilterId();
        System.out.println("getFilterId=" + id + " binaire=" + Integer.toBinaryString(id));
        Assert.assertEquals((String)"filterID", (long)17L, (long)filterIdentificator.getFilterId());
    }
}

