
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;
import org.lsst.ccs.framework.HasLifecycle;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * Used only in single-filter-test simulation to simulate the devices through we read latches sensors.
 * @author virieux
 */
public class SimuCompactIO extends CompactIO implements HasLifecycle {

    @ConfigurationParameter
    private int initialValue;
    
    @LookupField(strategy=Strategy.BYNAME)
    private DigitalSensor filterPresenceSensorLatchXminus;
    @LookupField(strategy=Strategy.BYNAME)
    private DigitalSensor filterPresenceSensorLatchXplus;

    /**
     * Build a new SimuCompactIOModule
     * @param nodeID
     * @param serialNB
     * @param initialValue 
     */
    public SimuCompactIO( 
            int nodeID, 
            String serialNB,
            int initialValue) {
        super(nodeID, serialNB);
        this.initialValue = initialValue;
    }
    
    

    public int getInitialValue() {
        return initialValue;
    }

    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    public void setValue(int hex) {
        this.value = hex;
    }

    @Override
    public void init() {
        this.value = this.initialValue;
    }

    @Override
    public int readNewValue() {
        return this.value;
    }
    

    /**
     * This method updates the 2 filter presence simulated digital sensors (one
     * on each side of the filter).
     *
     * @param aDigitalValue has to be "0" or "1"
     */
    public void simulateFilterPresenceInLatches(int aDigitalValue) {

        int inputNumeroXminus = this.filterPresenceSensorLatchXminus.getInputNumero();
        int inputNumeroXplus = this.filterPresenceSensorLatchXplus.getInputNumero();

        this.replaceDigitalValues(inputNumeroXminus, aDigitalValue, inputNumeroXplus, aDigitalValue);
    }

    /**
     * This method replace the values of 2 channels in value with the
 digital values given as argument. The value for channel1 is replaced by
     * digitalValue1. The value for channel2 is replaced by digitalValue2. This
     * is useful when we want to simulate a new value sent by the sensors.
     * @param channel1
     * @param digitalValue1
     * @param channel2
     * @param digitalValue2
     */
    public void replaceDigitalValues(int channel1, int digitalValue1, int channel2, int digitalValue2) {
        if (channel1 < 0 || channel1 > 7) {
            throw new IllegalArgumentException("bad value for channel1 : Channel numero has to be between 1 and 8.");
        }
        if (channel2 < 0 || channel2 > 7) {
            throw new IllegalArgumentException("bad value for channel2 : Channel numero has to be between 1 and 8.");
        }
        if (digitalValue1 != 0 && digitalValue1 != 1) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }
        if (digitalValue2 != 0 && digitalValue2 != 1) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }

        FCSLOG.debug(name + "=> old value = " + this.value);
        int inter = FcsUtils.forceBit(value, channel1, digitalValue1);
        int newDIOValue = FcsUtils.forceBit(inter, channel2, digitalValue2);
        FCSLOG.debug(name + "=> new value = " + newDIOValue);
        this.value = newDIOValue;
    }
    
}
